/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.errors;

import binnie.core.gui.minecraft.ContainerCraftGUI;
import binnie.core.gui.minecraft.CustomSlot;
import binnie.core.machines.errors.CoreErrorCode;
import binnie.core.machines.errors.EnumErrorType;
import binnie.core.machines.errors.ErrorStateRegistry;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ErrorState
implements INbtReadable,
INbtWritable {
    private IErrorStateDefinition nameDefinition;
    private IErrorStateDefinition definition;
    private int[] data;
    private boolean itemError;
    private boolean tankError;
    private boolean powerError;

    public ErrorState(IErrorStateDefinition definition) {
        this(definition, definition);
    }

    public ErrorState(IErrorStateDefinition definition, int[] data) {
        this(definition, definition, data);
    }

    public ErrorState(IErrorStateDefinition definition, int data) {
        this(definition, definition, new int[]{data});
    }

    public ErrorState(IErrorStateDefinition nameDefinition, IErrorStateDefinition definition) {
        this(nameDefinition, definition, new int[0]);
    }

    public ErrorState(IErrorStateDefinition nameDefinition, IErrorStateDefinition definition, int[] data) {
        EnumErrorType type = definition.getType();
        this.data = data;
        this.itemError = type.isItemError();
        this.tankError = type.isTankError();
        this.powerError = type.isPowerError();
        this.nameDefinition = nameDefinition;
        this.definition = definition;
    }

    public ErrorState(NBTTagCompound nbtTagCompound) {
        this.data = new int[0];
        this.itemError = false;
        this.tankError = false;
        this.powerError = false;
        this.definition = CoreErrorCode.UNKNOWN;
        this.nameDefinition = CoreErrorCode.UNKNOWN;
        this.readFromNBT(nbtTagCompound);
    }

    public String toString() {
        return this.nameDefinition.getName();
    }

    public String getTooltip() {
        return this.definition.getDescription();
    }

    public String getTooltip(ContainerCraftGUI container) {
        Collection<CustomSlot> slots = this.getCustomSlots(container);
        HashSet validators = new HashSet();
        for (CustomSlot slot : slots) {
            SlotValidator validator;
            InventorySlot inventorySlot = slot.getInventorySlot();
            if (inventorySlot == null || (validator = inventorySlot.getValidator()) == null) continue;
            validators.add(validator);
        }
        return this.definition.getDescription(validators);
    }

    public int[] getData() {
        return this.data;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.nameDefinition = ErrorStateRegistry.getErrorState(nbt.func_74779_i("name"));
        this.definition = ErrorStateRegistry.getErrorState(nbt.func_74779_i("desc"));
        this.data = nbt.func_74759_k("data");
        this.itemError = nbt.func_74767_n("item");
        this.tankError = nbt.func_74767_n("tank");
        this.powerError = nbt.func_74767_n("power");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.nameDefinition.getUID());
        nbt.func_74778_a("desc", this.definition.getUID());
        nbt.func_74783_a("data", this.data);
        if (this.isItemError()) {
            nbt.func_74757_a("item", true);
        }
        if (this.isTankError()) {
            nbt.func_74757_a("tank", true);
        }
        if (this.isPowerError()) {
            nbt.func_74757_a("power", true);
        }
        return nbt;
    }

    public boolean isItemError() {
        return this.itemError;
    }

    public boolean isTankError() {
        return this.tankError;
    }

    public boolean isPowerError() {
        return this.powerError;
    }

    public Collection<CustomSlot> getCustomSlots(ContainerCraftGUI container) {
        ArrayList<CustomSlot> slots = new ArrayList<CustomSlot>();
        if (this.isItemError()) {
            IntArraySet slotNumbers = new IntArraySet(this.getData());
            for (CustomSlot cslot : container.getCustomSlots()) {
                if (cslot.field_75224_c instanceof InventoryPlayer || !slotNumbers.contains(cslot.getSlotIndex())) continue;
                slots.add(cslot);
            }
        }
        return slots;
    }
}

