/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.errors;

import binnie.core.ModId;
import binnie.core.machines.errors.EnumErrorType;
import binnie.core.machines.inventory.Validator;
import binnie.core.util.I18N;
import java.util.ArrayList;
import java.util.Collection;

public interface IErrorStateDefinition {
    public String getDescription();

    default public String getDescription(Collection<Validator<?>> validators) {
        ArrayList<String> validatorStrings = new ArrayList<String>();
        for (Validator<?> validator : validators) {
            String validatorString = validator.getTooltip();
            if (validatorStrings.contains(validatorString)) continue;
            validatorStrings.add(validatorString);
        }
        if (validatorStrings.size() == 0) {
            return this.getDescription();
        }
        String validationString = validatorStrings.size() == 1 ? (String)validatorStrings.get(0) : ((Object)validatorStrings).toString();
        return I18N.localise(ModId.CORE, "errors.missing.validated.slot.desc", validationString);
    }

    public String getName();

    public String getUID();

    public EnumErrorType getType();
}

