/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.IMachine;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.core.machines.power.IProcessTimed;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ComponentProcess
extends ComponentProcessIndefinate
implements IProcessTimed {
    private float progressAmount = 0.0f;

    public ComponentProcess(IMachine machine) {
        super(machine, 0.0f);
    }

    @Override
    public float getEnergyPerTick() {
        return this.getProcessEnergy() / this.getProcessLength();
    }

    @Override
    public float getProgressPerTick() {
        return 100.0f / (float)this.getProcessLength();
    }

    @Override
    protected void onStartTask() {
        this.progressAmount += 0.01f;
    }

    @Override
    protected void onCancelTask() {
        this.progressAmount = 0.0f;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.progressAmount >= 100.0f) {
            this.onFinishTask();
            this.progressAmount = 0.0f;
        }
    }

    public void alterProgress(float f) {
        this.progressAmount += f;
    }

    @Override
    protected void progressTick() {
        super.progressTick();
        this.alterProgress(this.getProgressPerTick());
    }

    @Override
    public boolean inProgress() {
        return this.progressAmount > 0.0f;
    }

    @Override
    public float getProgress() {
        return this.progressAmount;
    }

    public void setProgress(float f) {
        this.progressAmount = f;
    }

    protected void onFinishTask() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.progressAmount = nbt.func_74760_g("progress");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt1) {
        NBTTagCompound nbt = super.writeToNBT(nbt1);
        nbt.func_74776_a("progress", this.progressAmount);
        return nbt;
    }

    @Override
    public abstract int getProcessLength();

    @Override
    public abstract int getProcessEnergy();
}

