/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.triggers;

import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import forestry.core.triggers.Sprite;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

class BinnieAction
implements IActionExternal {
    private static int incrementalID = 800;
    public static BinnieAction actionPauseProcess;
    public static BinnieAction actionCancelTask;
    private final String desc;
    @Nullable
    @SideOnly(value=Side.CLIENT)
    private Sprite icon;
    private final String tag;
    private final String modID;
    private final String iconFile;
    private int id = incrementalID++;

    BinnieAction(String desc, String tag, String iconFile) {
        this(desc, tag, BinnieCore.getInstance(), iconFile);
    }

    private BinnieAction(String desc, String tag, AbstractMod mod, String iconFile) {
        this.tag = tag;
        StatementManager.registerStatement((IStatement)this);
        this.modID = mod.getModId();
        this.iconFile = iconFile;
        this.desc = desc;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getUniqueTag() {
        return this.tag;
    }

    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        if (this.icon == null) {
            this.icon = new Sprite(new ResourceLocation(this.modID, String.format("textures/items/%s.png", this.iconFile)));
        }
        return this.icon;
    }

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    public IStatementParameter createParameter(int index) {
        return null;
    }

    public IStatement rotateLeft() {
        return this;
    }

    public void actionActivate(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
    }

    public IStatement[] getPossible() {
        return new IStatement[0];
    }
}

