/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.triggers;

import binnie.core.machines.Machine;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.triggers.BinnieTrigger;
import binnie.core.triggers.TriggerData;

public class TriggerPower {
    private TriggerPower() {
    }

    public static TriggerData powerNone(Object tile) {
        return new TriggerData(BinnieTrigger.triggerPowerNone, TriggerPower.getPercentage(tile) < (double)0.05f);
    }

    public static TriggerData powerLow(Object tile) {
        return new TriggerData(BinnieTrigger.triggerPowerLow, TriggerPower.getPercentage(tile) < (double)0.35f);
    }

    public static TriggerData powerMedium(Object tile) {
        double percentage = TriggerPower.getPercentage(tile);
        return new TriggerData(BinnieTrigger.triggerPowerMedium, percentage >= (double)0.35f && percentage <= (double)0.65f);
    }

    public static TriggerData powerHigh(Object tile) {
        return new TriggerData(BinnieTrigger.triggerPowerHigh, TriggerPower.getPercentage(tile) > (double)0.65f);
    }

    public static TriggerData powerFull(Object tile) {
        return new TriggerData(BinnieTrigger.triggerPowerFull, TriggerPower.getPercentage(tile) > (double)0.95f);
    }

    private static double getPercentage(Object tile) {
        IPoweredMachine process = Machine.getInterface(IPoweredMachine.class, tile);
        if (process != null) {
            return (float)process.getInterface().getEnergy() / (float)process.getInterface().getCapacity();
        }
        return 0.0;
    }
}

