/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.items.types;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum EnumIndustrialFrame implements IBeeModifier
{
    EMPTY("Empty", 5, 0),
    LIGHT("Glowstone Lighting", 2, 4){

        @Override
        protected void init() {
            this.lighted = true;
        }
    }
    ,
    RAIN("Rain Shielding", 2, 4){

        @Override
        protected void init() {
            this.rain = true;
        }
    }
    ,
    SUNLIGHT("Sunlight Simulator", 4, 8){

        @Override
        protected void init() {
            this.lighted = true;
            this.sunlight = true;
        }
    }
    ,
    SOUL("Low Grade Mutagen", 5, 15){

        @Override
        protected void init() {
            this.mutationMod = 1.3f;
        }
    }
    ,
    URANIUM("High Grade Mutagen", 10, 50){

        @Override
        protected void init() {
            this.mutationMod = 2.0f;
        }
    }
    ,
    CAGE("Meshed Restrainer", 3, 12){

        @Override
        protected void init() {
            this.territoryMod = 0.4f;
        }
    }
    ,
    FREEDOM("Territory Extension", 3, 16){

        @Override
        protected void init() {
            this.territoryMod = 1.4f;
        }
    }
    ,
    HONEY("Honey Amplifier", 4, 12){

        @Override
        protected void init() {
            this.productionMod = 1.4f;
        }
    }
    ,
    JELLY("Gelatin Amplifier", 8, 36){

        @Override
        protected void init() {
            this.productionMod = 1.8f;
        }
    }
    ,
    LEAF("Pollinator MK I", 3, 15){

        @Override
        protected void init() {
            this.floweringMod = 1.4f;
        }
    }
    ,
    POLLEN("Pollinator MK II", 7, 25){

        @Override
        protected void init() {
            this.floweringMod = 2.0f;
        }
    }
    ,
    CLAY("Lifespan Extensor", 2, 10){

        @Override
        protected void init() {
            this.lifespanMod = 1.4f;
        }
    }
    ,
    EMERALD("Eon Simulator", 7, 20){

        @Override
        protected void init() {
            this.lifespanMod = 2.0f;
        }
    }
    ,
    NETHER_STAR("Immortality Gate", 12, 50){

        @Override
        protected void init() {
            this.lifespanMod = 20.0f;
        }
    }
    ,
    POISON("Mortality Inhibitor", 8, 18){

        @Override
        protected void init() {
            this.lifespanMod = 0.5f;
        }
    };

    private final String name;
    protected float territoryMod = 1.0f;
    protected float mutationMod = 1.0f;
    protected float lifespanMod = 1.0f;
    protected float productionMod = 1.0f;
    protected float floweringMod = 1.0f;
    protected boolean lighted = false;
    protected boolean sunlight = false;
    protected boolean rain = false;
    private final int wearMod;
    private final int power;

    private EnumIndustrialFrame(String name, int wear, int power) {
        this.name = name;
        this.wearMod = wear;
        this.power = power;
        this.init();
    }

    protected void init() {
    }

    public static ItemStack getItemStack(Item item, EnumIndustrialFrame frame) {
        ItemStack stack = new ItemStack(item);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("frame", frame.ordinal());
        stack.func_77982_d(nbt);
        return stack;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.territoryMod;
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.mutationMod;
    }

    public float getLifespanModifier(IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        return this.lifespanMod;
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.productionMod;
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.floweringMod;
    }

    public boolean isSealed() {
        return this.rain;
    }

    public boolean isSelfLighted() {
        return this.lighted;
    }

    public boolean isSunlightSimulated() {
        return this.sunlight;
    }

    public boolean isHellish() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getWearModifier() {
        return this.wearMod;
    }

    public int getPowerUsage() {
        return this.power;
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }
}

