/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.blocks.wood;

import binnie.extratrees.blocks.property.PropertyETWoodType;
import binnie.extratrees.wood.EnumETLog;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.BlockForestryFence;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public abstract class BlockETFence
extends BlockForestryFence<EnumETLog>
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    private BlockETFence(boolean fireproof, int blockNumber) {
        super(fireproof, blockNumber);
        String name = "fences.";
        if (fireproof) {
            name = name + "fireproof.";
        }
        name = name + blockNumber;
        this.setRegistryName(new ResourceLocation("extratrees", name));
        this.func_149663_c(name);
    }

    public static List<BlockETFence> create(boolean fireproof) {
        ArrayList<BlockETFence> blocks = new ArrayList<BlockETFence>();
        PropertyETWoodType[] variants = PropertyETWoodType.create("variant", 16);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyETWoodType variant = variants[i];
            BlockETFence block = new BlockETFence(fireproof, i){

                public PropertyETWoodType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    public EnumETLog getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.getBlockNumber() * 16;
        return EnumETLog.byMetadata(variantMeta);
    }
}

