/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.BinnieWorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenEucalyptus {

    public static class RainbowGum
    extends BinnieWorldGenTree {
        public RainbowGum(ITreeGenData tree) {
            super(tree, 7, 3);
        }

        @Override
        protected void generateLeaves() {
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(0.5f, 0.6f) * (float)this.height;
            float width = (float)this.height * this.randBetween(0.15f, 0.2f);
            if (width < 1.5f) {
                width = 1.5f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f3, 0.0f), width, 1, this.leaf, false);
                float f4 = leafSpawn;
                leafSpawn = f4 - 1.0f;
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f4, 0.0f), width - 0.5f, 1, this.leaf, false);
            }
        }
    }

    public static class RoseGum
    extends BinnieWorldGenTree {
        public RoseGum(ITreeGenData tree) {
            super(tree, 9, 3);
        }

        @Override
        protected void generateLeaves() {
            int offset = (this.girth - 1) / 2;
            for (int x = 0; x < this.girth; ++x) {
                for (int y = 0; y < this.girth; ++y) {
                    for (int i = 0; i < 2; ++i) {
                    }
                }
            }
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(0.4f, 0.5f) * (float)this.height;
            float width = (float)this.height * this.randBetween(0.05f, 0.1f);
            if (width < 1.5f) {
                width = 1.5f;
            }
            this.bushiness = 0.5f;
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.bushiness = 0.1f;
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.9f, 1.1f) * width, 1, this.leaf, false);
            }
        }
    }

    public static class SwampGum
    extends BinnieWorldGenTree {
        public SwampGum(ITreeGenData tree) {
            super(tree, 14, 3);
        }

        @Override
        protected void generateLeaves() {
            int leafSpawn = this.height + 2;
            int weakerBottom = (int)((double)this.height * (0.5 + (double)(this.rand.nextFloat() * 0.3f)));
            int bottom = (int)((double)this.height * (0.45 + (double)(this.rand.nextFloat() * 0.2f)));
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), (float)this.girth + 0.75f, 1, this.leaf, false);
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), (float)this.girth + 1.75f, 1, this.leaf, false);
            while (leafSpawn > weakerBottom) {
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), (float)this.girth + 1.0f + 1.75f * this.rand.nextFloat(), 1, this.leaf, false);
            }
            while (leafSpawn > bottom) {
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), (float)this.girth + 0.75f + 1.25f * this.rand.nextFloat(), 1, this.leaf, false);
            }
            for (int i = 0; i < 7; ++i) {
                if ((double)this.rand.nextFloat() > 0.45) {
                    --leafSpawn;
                    continue;
                }
                this.generateSphere(new BinnieWorldGenTree.Vector(this.rand.nextInt(this.girth) * (this.rand.nextBoolean() ? -1 : 1), leafSpawn--, this.rand.nextInt(this.girth) * (this.rand.nextBoolean() ? -1 : 1)), 1, this.leaf, false);
            }
        }
    }
}

