/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.core.utils.VectUtil;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class WorldGenUtils {
    public static int randBetween(Random rand, int a, int b) {
        return a + rand.nextInt(b - a);
    }

    public static float randBetween(Random rand, float a, float b) {
        return a + rand.nextFloat() * (b - a);
    }

    public static void generateCylinderFromTreeStartPos(World world, Random rand, ITreeBlockType block, BlockPos startPos, int girth, float radius, int height, float bushiness, WorldGenHelper.EnumReplaceMode replace) {
        WorldGenUtils.generateCylinderFromPos(world, rand, block, startPos.func_177982_a(girth / 2, 0, girth / 2), radius, height, bushiness, replace);
    }

    public static void generateCylinderFromPos(World world, Random rand, ITreeBlockType block, BlockPos center, float radius, int height, float bushiness, WorldGenHelper.EnumReplaceMode replace) {
        BlockPos start = new BlockPos((double)((float)center.func_177958_n() - radius), (double)center.func_177956_o(), (double)((float)center.func_177952_p() - radius));
        int x = 0;
        while ((float)x < radius * 2.0f + 1.0f) {
            for (int y = height - 1; y >= 0; --y) {
                int z = 0;
                while ((float)z < radius * 2.0f + 1.0f) {
                    Vec3i treeCenter;
                    BlockPos position = start.func_177982_a(x, y, z);
                    if (position.func_177951_i(treeCenter = new Vec3i(center.func_177958_n(), position.func_177956_o(), center.func_177952_p())) <= (double)(radius * radius) + 0.01 && (position.func_177951_i(treeCenter) < (double)(radius * radius - 0.25f) || rand.nextFloat() >= bushiness)) {
                        EnumFacing direction = VectUtil.direction((Vec3i)position, (Vec3i)treeCenter);
                        block.setDirection(direction);
                        WorldGenHelper.addBlock((World)world, (BlockPos)position, (ITreeBlockType)block, (WorldGenHelper.EnumReplaceMode)replace);
                    }
                    ++z;
                }
            }
            ++x;
        }
    }
}

