/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.brewery.recipes;

import binnie.core.Binnie;
import binnie.core.util.FluidStackUtil;
import binnie.core.util.OreDictionaryUtil;
import binnie.extratrees.api.recipes.IBreweryCrafting;
import binnie.extratrees.api.recipes.IBreweryRecipe;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BrewedGrainRecipe
implements IBreweryRecipe {
    public static final FluidStack WATER = Binnie.LIQUID.getFluidStack("water", 1000);
    private final FluidStack output;
    private final String grainOreName;
    @Nullable
    private final String ingredientOreName;
    private final ItemStack yeast;

    public BrewedGrainRecipe(FluidStack output, String grainOreName, @Nullable String ingredientOreName, ItemStack specificYeast) {
        this.output = output;
        this.grainOreName = grainOreName;
        this.ingredientOreName = ingredientOreName;
        this.yeast = specificYeast;
    }

    @Override
    @Nullable
    public FluidStack getOutput(IBreweryCrafting crafting) {
        if (WATER.isFluidEqual(crafting.getInputFluid()) && this.isIngredient(crafting.getIngredient()) && this.yeast.func_77969_a(crafting.getYeast())) {
            int grainCount = 0;
            for (ItemStack stack : crafting.getInputGrains()) {
                if (stack == null) {
                    return null;
                }
                if (!this.isGrain(stack)) continue;
                ++grainCount;
            }
            if (grainCount >= 2) {
                return this.output.copy();
            }
        }
        return null;
    }

    @Override
    public FluidStack getInput() {
        return WATER;
    }

    @Override
    public FluidStack getOutput() {
        return this.output;
    }

    @Override
    public Collection<Object> getInputs() {
        if (this.ingredientOreName == null) {
            return ImmutableList.of((Object)this.grainOreName, (Object)this.yeast);
        }
        return ImmutableList.of((Object)this.grainOreName, (Object)this.yeast, (Object)this.ingredientOreName);
    }

    @Override
    public Collection<Object> getOutputs() {
        return Collections.singleton(this.output);
    }

    @Override
    public boolean isIngredient(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return this.ingredientOreName == null;
        }
        return this.ingredientOreName != null && OreDictionaryUtil.hasOreName(itemStack, this.ingredientOreName);
    }

    @Override
    public List<ItemStack> getIngredients() {
        if (this.ingredientOreName == null) {
            return Collections.emptyList();
        }
        return OreDictionaryUtil.getOres(this.ingredientOreName);
    }

    @Override
    public boolean isGrain(ItemStack itemStack) {
        return !itemStack.func_190926_b() && OreDictionaryUtil.hasOreName(itemStack, this.grainOreName);
    }

    @Override
    public List<ItemStack> getGrains() {
        return OreDictionaryUtil.getOres(this.grainOreName);
    }

    @Override
    public ItemStack getYeast() {
        return this.yeast;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("grainOreName", (Object)this.grainOreName).add("output", (Object)FluidStackUtil.toString(this.output)).add("ingredientOreName", (Object)this.ingredientOreName).add("yeast", (Object)this.yeast).toString();
    }
}

