/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.sequencer;

import binnie.core.machines.Machine;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.IProcess;
import binnie.genetics.config.ConfigurationMain;
import binnie.genetics.genetics.GeneTracker;
import binnie.genetics.genetics.SequencerItem;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.GeneticsErrorCode;
import com.google.common.base.Preconditions;
import net.minecraft.item.ItemStack;

public class SequencerLogic
extends ComponentProcess
implements IProcess {
    public SequencerLogic(Machine machine) {
        super(machine);
    }

    public static float getSequenceStrength(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 1.0f;
        }
        float mult = 1.0f - (float)(stack.func_77952_i() % 6) / 5.0f;
        return 1.0f - mult * mult * 0.75f;
    }

    @Override
    public int getProcessLength() {
        ItemStack stack = this.getUtil().getStack(5);
        return (int)((float)ConfigurationMain.sequencerTimeMultiplier * SequencerLogic.getSequenceStrength(stack));
    }

    @Override
    public int getProcessEnergy() {
        return this.getProcessLength() * ConfigurationMain.sequencerEnergyMultiplier;
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(5)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.SEQUENCER_NO_DNA, 5);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (this.getMachine().getOwner() == null) {
            return new ErrorState(GeneticsErrorCode.NO_OWNER);
        }
        if (this.getUtil().getSlotCharge(0) == 0.0f) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.SEQUENCER_INSUFFICIENT_DYE, 0);
        }
        ItemStack stackDone = this.getUtil().getStack(6);
        if (!stackDone.func_190926_b() && stackDone.func_190916_E() >= 64) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.SEQUENCER_NO_SPACE, new int[]{6});
        }
        return super.canProgress();
    }

    @Override
    protected void onStartTask() {
        int seq;
        SequencerItem seqItem;
        super.onStartTask();
        ItemStack item = this.getUtil().getStack(5);
        if (!item.func_190926_b() && (seqItem = SequencerItem.create(item)) != null && (seq = seqItem.getSequenced()) != 0) {
            this.setProgress(seq);
        }
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        this.updateSequence();
        ItemStack stack = this.getUtil().getStack(5);
        Preconditions.checkState((!stack.func_190926_b() ? 1 : 0) != 0);
        SequencerItem seqItem = SequencerItem.create(stack);
        Preconditions.checkState((seqItem != null ? 1 : 0) != 0);
        GeneTracker.getTracker(this.getMachine().getWorld(), this.getMachine().getOwner()).registerGene(seqItem.getGene());
        this.getUtil().decreaseStack(5, 1);
        if (this.getUtil().getStack(6).func_190926_b()) {
            this.getUtil().setStack(6, GeneticsItems.EmptySequencer.get(1));
        } else {
            this.getUtil().decreaseStack(6, -1);
        }
    }

    @Override
    protected void onTickTask() {
        this.updateSequence();
        this.getUtil().useCharge(0, 0.4f * this.getProgressPerTick() / 100.0f);
    }

    private void updateSequence() {
        int prog = (int)this.getProgress();
        ItemStack item = this.getUtil().getStack(5);
        Preconditions.checkState((!item.func_190926_b() ? 1 : 0) != 0);
        SequencerItem seqItem = SequencerItem.create(item);
        Preconditions.checkState((seqItem != null ? 1 : 0) != 0);
        int seq = seqItem.getSequenced();
        if (prog != seq) {
            seqItem.setSequenced(prog);
            seqItem.writeToItem(item);
        }
    }
}

