/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Container.part;

import AppliedIntegrations.Container.ContainerWithPlayerInventory;
import AppliedIntegrations.Container.slot.SlotRestrictive;
import AppliedIntegrations.Gui.Widgets.WidgetEnergySelector;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PartGUI.PacketTerminalUpdate;
import AppliedIntegrations.Parts.Energy.PartEnergyTerminal;
import AppliedIntegrations.api.IEnergySelectorContainer;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.AEEnergyStack;
import AppliedIntegrations.grid.EnergyList;
import appeng.api.config.SortOrder;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.GuiImgButton;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceOutput;
import net.minecraft.item.ItemStack;

public class ContainerEnergyTerminal
extends ContainerWithPlayerInventory
implements IEnergySelectorContainer {
    private static final int OUTPUT_POSITION_X = 26;
    private static final int OUTPUT_POSITION_Y = 92;
    private static final int INPUT_POSITION_X = 8;
    private static final int INPUT_POSITION_Y = 92;
    private static int INPUT_INV_INDEX = 37;
    public EntityPlayer player;
    private PartEnergyTerminal terminal;
    public final List<WidgetEnergySelector> widgetEnergySelectors = new ArrayList<WidgetEnergySelector>();
    public EnergyStack selectedStack = new EnergyStack(null, 0L);
    public GuiImgButton sortButton;
    public SortOrder sortMode = SortOrder.NAME;
    public IItemList<IAEEnergyStack> list = new EnergyList();
    public Ordering<IAEEnergyStack> sorter = new Ordering<IAEEnergyStack>(){

        public int compare(@Nullable IAEEnergyStack left, @Nullable IAEEnergyStack right) {
            if (left == null || right == null) {
                return 0;
            }
            if (ContainerEnergyTerminal.this.sortMode == SortOrder.NAME) {
                String leftEnergyName = left.getEnergy() == null ? "null" : left.getEnergy().getEnergyName();
                String rightEnergyName = right.getEnergy() == null ? "null" : right.getEnergy().getEnergyName();
                return leftEnergyName.compareTo(rightEnergyName);
            }
            if (ContainerEnergyTerminal.this.sortMode == SortOrder.AMOUNT) {
                Long leftAmount = left.getStackSize();
                Long rightAmount = right.getStackSize();
                return leftAmount.compareTo(rightAmount);
            }
            if (ContainerEnergyTerminal.this.sortMode == SortOrder.MOD) {
                String leftModid = left.getEnergy() == null ? "null" : left.getEnergy().getModid();
                String rightModid = right.getEnergy() == null ? "null" : right.getEnergy().getModid();
                return leftModid.compareTo(rightModid);
            }
            return 0;
        }
    };

    public ContainerEnergyTerminal(PartEnergyTerminal terminal, EntityPlayer player) {
        super(player);
        this.bindPlayerInventory((IInventory)player.field_71071_by, 122, 180);
        this.terminal = terminal;
        this.player = player;
        if (!terminal.getHostWorld().field_72995_K) {
            IMEMonitor<IAEEnergyStack> inv = terminal.getEnergyInventory();
            if (inv != null) {
                inv.addListener((IMEMonitorHandlerReceiver)terminal, null);
                for (ContainerEnergyTerminal listener : terminal.listeners) {
                    NetworkHandler.sendTo(new PacketTerminalUpdate((IItemList<IAEEnergyStack>)inv.getStorageList(), terminal.getSortOrder(), terminal), (EntityPlayerMP)listener.player);
                }
            }
            terminal.listeners.add(this);
        }
        this.func_75146_a(new SlotRestrictive(terminal.energyIOInventory, 0, 8, 92));
        this.func_75146_a((Slot)new SlotFurnaceOutput(this.player, (IInventory)terminal.energyIOInventory, 1, 26, 92));
    }

    public void updateList(IItemList<IAEEnergyStack> list) {
        List sorted = this.sorter.sortedCopy(list);
        this.list = new EnergyList();
        sorted.forEach(arg_0 -> this.list.add(arg_0));
        this.updateStacksPrecise(sorted);
    }

    public void updateStacksPrecise(List<IAEEnergyStack> sorted) {
        int i;
        if (sorted.size() > 0) {
            for (i = 0; i < this.list.size(); ++i) {
                this.widgetEnergySelectors.get(i).setCurrentStack(new EnergyStack(sorted.get(i).getEnergy(), sorted.get(i).getStackSize()));
            }
        } else {
            for (i = 0; i < this.widgetEnergySelectors.size(); ++i) {
                this.widgetEnergySelectors.get(i).setCurrentStack(new EnergyStack(null, 0L));
            }
        }
        if (this.selectedStack.getEnergy() != null && this.selectedStack.amount > 0L) {
            IAEEnergyStack precise = (IAEEnergyStack)this.list.findPrecise((IAEStack)AEEnergyStack.fromStack(this.selectedStack));
            this.selectedStack = precise != null ? precise.getStack() : new EnergyStack(null, 0L);
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < INPUT_INV_INDEX - 1 ? !this.func_75135_a(itemstack1, INPUT_INV_INDEX - 1, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, INPUT_INV_INDEX - 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    @Override
    public void setSelectedEnergy(LiquidAIEnergy energy) {
    }

    @Override
    public void func_75134_a(@Nonnull EntityPlayer player) {
        super.func_75134_a(player);
        IMEMonitor<IAEEnergyStack> inv = this.terminal.getEnergyInventory();
        if (inv == null) {
            return;
        }
        inv.removeListener((IMEMonitorHandlerReceiver)this.terminal);
        this.terminal.listeners.remove(this);
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    @Override
    public ISyncHost getSyncHost() {
        return this.terminal;
    }

    @Override
    public void setSyncHost(ISyncHost host) {
        if (host instanceof PartEnergyTerminal) {
            this.terminal = (PartEnergyTerminal)host;
        }
    }
}

