/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Container.tile.MultiController;

import AppliedIntegrations.Container.ContainerWithPlayerInventory;
import AppliedIntegrations.Container.slot.SlotRestrictive;
import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.MultiController.PacketScrollServerToClient;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.tile.MultiController.TileMultiControllerCore;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ContainerMultiControllerCore
extends ContainerWithPlayerInventory {
    public static final int CARD_SLOT_VIEW_ROWS = 5;
    public static final int CARD_SLOT_ROWS = 17;
    public static final int CARD_SLOT_COLUMNS = 9;
    private TileMultiControllerCore master;

    public ContainerMultiControllerCore(EntityPlayer player, TileMultiControllerCore master) {
        super(player);
        this.addCardSlots(master.cardInv.getViewInventory());
        this.master = master;
        this.master.listeners.add(this);
        super.bindPlayerInventory((IInventory)player.field_71071_by, 107, 165);
    }

    public void scrollTo(double slotScroll) {
        if (slotScroll == 0.0) {
            return;
        }
        this.master.setSlotDiff(this.master.getSlotDiff() + (slotScroll < 0.0 ? -9 : 9));
    }

    private void addCardSlots(AIGridNodeInventory cardInv) {
        int i = 0;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (cardInv == null) continue;
                this.func_75146_a(new SlotRestrictive(cardInv, i, 9 + x * 18, y * 18 + 3));
                ++i;
            }
        }
    }

    @Override
    public void func_75134_a(@Nonnull EntityPlayer player) {
        super.func_75134_a(player);
        this.master.setSlotDiff(0);
    }

    @Override
    protected void syncHostWithGUI() {
        super.syncHostWithGUI();
        NetworkHandler.sendTo(new PacketScrollServerToClient(this.master.getSlotDiff(), (TileMultiControllerCore)this.getSyncHost()), (EntityPlayerMP)this.player);
    }

    @Override
    public boolean func_75145_c(EntityPlayer p) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        return ItemStack.field_190927_a;
    }

    @Override
    public ISyncHost getSyncHost() {
        return this.master;
    }

    @Override
    public void setSyncHost(ISyncHost host) {
        if (host instanceof TileMultiControllerCore) {
            this.master = (TileMultiControllerCore)host;
        }
    }
}

