/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Container.tile.MultiController;

import AppliedIntegrations.Container.ContainerWithPlayerInventory;
import AppliedIntegrations.Container.slot.SlotRestrictive;
import AppliedIntegrations.Gui.MultiController.SubGui.Buttons.GuiSecurityPermissionsButton;
import AppliedIntegrations.api.AIApi;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.IChannelContainerWidget;
import AppliedIntegrations.api.Storage.IChannelWidget;
import AppliedIntegrations.tile.MultiController.TileMultiControllerTerminal;
import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.util.Platform;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerMultiControllerTerminal
extends ContainerWithPlayerInventory {
    public static ArrayList<IStorageChannel<? extends IAEStack<?>>> channelList = new ArrayList(AEApi.instance().storage().storageChannels());
    private final SlotRestrictive cardSlot;
    public TileMultiControllerTerminal terminal;
    private LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, List<IChannelContainerWidget<?>>>> permissionChannelWidgetMap = new LinkedHashMap();

    public ContainerMultiControllerTerminal(TileMultiControllerTerminal terminal, EntityPlayer player) {
        super(player);
        super.bindPlayerInventory((IInventory)player.field_71071_by, 119, 177);
        this.cardSlot = new SlotRestrictive(terminal.editorInv, 0, 37, 86){

            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "appliedintegrations:gui/slots/network_card_slot";
            }
        };
        super.func_75146_a(this.cardSlot);
        this.terminal = terminal;
        this.terminal.listeners.add(this);
        if (Platform.isServer()) {
            return;
        }
        this.initWidgets(terminal);
    }

    public void initWidgets(TileMultiControllerTerminal terminal) {
        GuiSecurityPermissionsButton.getPermissionList().forEach(permissions -> {
            LinkedHashMap tempMap = new LinkedHashMap();
            AEApi.instance().storage().storageChannels().forEach(chan -> {
                Constructor<? extends IChannelWidget> channelWidgetConstructor = Objects.requireNonNull(AIApi.instance()).getWidgetFromChannel((IStorageChannel<? extends IAEStack<?>>)chan);
                if (channelWidgetConstructor != null) {
                    LinkedList<IChannelContainerWidget> widgetList = new LinkedList<IChannelContainerWidget>();
                    for (int x = 0; x < 9; ++x) {
                        for (int y = 0; y < 3; ++y) {
                            try {
                                IChannelWidget widget = channelWidgetConstructor.newInstance(9 + 18 * x, 18 + 18 * y);
                                if (!(widget instanceof IChannelContainerWidget)) continue;
                                widgetList.add((IChannelContainerWidget)widget);
                                this.func_75146_a(((IChannelContainerWidget)widget).getSlotWrapper());
                                continue;
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                                // empty catch block
                            }
                        }
                    }
                    tempMap.put(chan, widgetList);
                }
            });
            this.permissionChannelWidgetMap.put((SecurityPermissions)permissions, tempMap);
        });
        this.forEachWidget(terminal::addWidgetSlotLink);
    }

    public void forEachWidget(Consumer<IChannelContainerWidget<?>> function) {
        this.permissionChannelWidgetMap.forEach((perm, map) -> map.forEach((chan, list) -> list.forEach(function)));
    }

    public boolean hasCard() {
        return !this.cardSlot.func_75211_c().func_190926_b();
    }

    public ItemStack getCard() {
        return this.cardSlot.func_75211_c();
    }

    public LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, List<IChannelContainerWidget<?>>>> getOuterMap() {
        return this.permissionChannelWidgetMap;
    }

    @Override
    public void func_75134_a(@Nonnull EntityPlayer player) {
        super.func_75134_a(player);
        this.terminal.listeners.remove(this);
    }

    @Override
    public boolean func_75145_c(EntityPlayer p_75145_1_) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        return ItemStack.field_190927_a;
    }

    @Override
    public ISyncHost getSyncHost() {
        return this.terminal;
    }

    @Override
    public void setSyncHost(ISyncHost host) {
        if (host instanceof TileMultiControllerTerminal) {
            this.terminal = (TileMultiControllerTerminal)host;
        }
    }
}

