/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Gui.MultiController.FilterSlots;

import AppliedIntegrations.Gui.Hosts.IWidgetHost;
import AppliedIntegrations.Gui.Widgets.EnergyWidget;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PartGUI.PacketClientToServerFilter;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.IChannelWidget;
import AppliedIntegrations.grid.AEEnergyStack;
import appeng.api.storage.data.IAEStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WidgetEnergySlot
extends EnergyWidget
implements IChannelWidget<IAEEnergyStack> {
    public int id;
    public boolean shouldRender;

    public WidgetEnergySlot(IWidgetHost hostGui, int id, int posX, int posY, boolean shouldRender) {
        super(hostGui, posX, posY);
        this.id = id;
        this.shouldRender = shouldRender;
    }

    @Override
    public void onMouseClicked(@Nonnull EnergyStack stack) {
        if (!this.shouldRender) {
            return;
        }
        this.setCurrentStack(stack);
        if (this.hostGUI.getSyncHost() == null) {
            return;
        }
        NetworkHandler.sendToServer(new PacketClientToServerFilter(this.hostGUI.getSyncHost(), stack.getEnergy(), this.id));
    }

    @Override
    public void drawWidget() {
        if (this.shouldRender) {
            GL11.glDisable((int)2896);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("appliedintegrations", "textures/gui/energy.io.bus.png"));
            this.func_73729_b(this.xPosition, this.yPosition, 79, 39, 18, 18);
            if (this.getCurrentStack() != null) {
                this.drawEnergy();
            }
            GL11.glEnable((int)2896);
        }
    }

    public IAEEnergyStack getAEStack() {
        if (this.getCurrentStack() != null && this.getCurrentStack().getEnergy() != null) {
            return AEEnergyStack.fromStack(this.getCurrentStack());
        }
        return null;
    }

    @Override
    public void setAEStack(IAEStack<?> iaeStack) {
        if (iaeStack == null) {
            this.setCurrentStack(new EnergyStack(null, 0L));
        } else {
            this.setCurrentStack(((IAEEnergyStack)iaeStack).getStack());
        }
    }

    @Override
    public String getStackTip() {
        IAEEnergyStack aeStack = this.getAEStack();
        if (aeStack != null && aeStack.getEnergy().getEnergyName() != null) {
            return aeStack.getEnergy().getEnergyName();
        }
        return "";
    }
}

