/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Gui.Part;

import AppliedIntegrations.Container.part.ContainerEnergyInterface;
import AppliedIntegrations.Gui.AIGui;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Gui.AIGuiHelper;
import AppliedIntegrations.Gui.Hosts.IPriorityHostExtended;
import AppliedIntegrations.Gui.Hosts.IWidgetHost;
import AppliedIntegrations.Gui.MultiController.FilterSlots.WidgetEnergySlot;
import AppliedIntegrations.Helpers.Energy.Utils;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PacketGuiShift;
import AppliedIntegrations.Parts.Energy.PartEnergyInterface;
import AppliedIntegrations.Utils.AILog;
import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import AppliedIntegrations.tile.TileEnergyInterface;
import appeng.api.util.AEPartLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.GL11;

public class GuiEnergyInterface
extends AIGui
implements IWidgetHost {
    private static ResourceLocation textureTile = new ResourceLocation("appliedintegrations", "textures/gui/energy.interface.tile.png");
    private static ResourceLocation texturePart = new ResourceLocation("appliedintegrations", "textures/gui/energy.interface.part.png");
    private ResourceLocation energybar = new ResourceLocation("appliedintegrations", "textures/gui/energy.rf.bar.png");
    protected final List<String> tooltip = new ArrayList<String>();
    private List<String> buttonTooltip = new ArrayList<String>();
    private IEnergyInterface energyInterface;
    private EntityPlayer player;

    public GuiEnergyInterface(ContainerEnergyInterface container, EntityPlayer player) {
        super(container, player);
        this.player = player;
        this.energyInterface = container.energyInterface;
        this.field_147003_i -= 51;
    }

    public ContainerEnergyInterface getContainer() {
        return (ContainerEnergyInterface)this.field_147002_h;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.energyInterface instanceof PartEnergyInterface) {
            this.getContainer().energySlotList.add(new WidgetEnergySlot(this, 0, 79, 111, true));
        } else if (this.energyInterface instanceof TileEnergyInterface) {
            this.getContainer().energySlotList.add(new WidgetEnergySlot(this, AEPartLocation.DOWN.ordinal(), 34, 111, true));
            this.getContainer().energySlotList.add(new WidgetEnergySlot(this, AEPartLocation.UP.ordinal(), 52, 111, true));
            this.getContainer().energySlotList.add(new WidgetEnergySlot(this, AEPartLocation.NORTH.ordinal(), 70, 111, true));
            this.getContainer().energySlotList.add(new WidgetEnergySlot(this, AEPartLocation.SOUTH.ordinal(), 88, 111, true));
            this.getContainer().energySlotList.add(new WidgetEnergySlot(this, AEPartLocation.WEST.ordinal(), 106, 111, true));
            this.getContainer().energySlotList.add(new WidgetEnergySlot(this, AEPartLocation.EAST.ordinal(), 124, 111, true));
        }
        this.addPriorityButton();
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.energyInterface instanceof PartEnergyInterface) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texturePart);
        } else if (this.energyInterface instanceof TileEnergyInterface) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(textureTile);
        }
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g + 75);
        this.func_73729_b(this.field_147003_i + 176, this.field_147009_r, 176, 0, 35, 35);
    }

    @Override
    public void onButtonClicked(GuiButton btn, int mouseButton) {
        if (!(this.energyInterface instanceof PartEnergyInterface)) {
            return;
        }
        if (btn == this.priorityButton) {
            NetworkHandler.sendToServer(new PacketGuiShift(AIGuiHandler.GuiEnum.GuiAIPriority, (IPriorityHostExtended)((Object)this.energyInterface)));
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float pOpacity) {
        this.tooltip.clear();
        super.func_73863_a(mouseX, mouseY, pOpacity);
        this.drawHoveringText(this.tooltip, mouseX, mouseY, this.field_146289_q);
        if (AIGuiHelper.INSTANCE.isPointInGuiRegion(this.field_147003_i - 18, this.field_147009_r + 8, 16, 16, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            this.drawHoveringText(this.buttonTooltip, mouseX, mouseY, this.field_146289_q);
        }
        for (WidgetEnergySlot slot : this.getContainer().energySlotList) {
            if (!slot.isMouseOverWidget(mouseX, mouseY)) continue;
            ArrayList<String> tip = new ArrayList<String>();
            if (slot.getCurrentStack() == null || slot.getStackTip().equals("")) continue;
            tip.add(slot.getStackTip());
            this.drawHoveringText(tip, mouseX, mouseY, this.field_146289_q);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.getContainer().linkedMetric == AIEnergy.RF || this.getContainer().linkedMetric == AIEnergy.J || this.getContainer().linkedMetric == AIEnergy.EU) {
            this.energybar = new ResourceLocation("appliedintegrations", "textures/gui/energy." + this.getContainer().linkedMetric.getTag() + ".bar.png");
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.energybar);
        this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"ME Energy Interface"), 9, 3, 0x404040);
        if (this.energyInterface instanceof TileEnergyInterface) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.energybar);
            this.drawPower(35, 14, mouseX - 10, mouseY - 10, 16, AEPartLocation.DOWN);
            this.drawPower(53, 14, mouseX - 10, mouseY - 10, 16, AEPartLocation.UP);
            this.drawPower(71, 14, mouseX - 10, mouseY - 10, 16, AEPartLocation.NORTH);
            this.drawPower(89, 14, mouseX - 10, mouseY - 10, 16, AEPartLocation.SOUTH);
            this.drawPower(107, 14, mouseX - 10, mouseY - 10, 16, AEPartLocation.WEST);
            this.drawPower(125, 14, mouseX - 10, mouseY - 10, 16, AEPartLocation.EAST);
        } else if (this.energyInterface instanceof PartEnergyInterface) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.energybar);
            if (this.getContainer().linkedMetric != AIEnergy.WA) {
                this.drawPower(80, 13, mouseX - 10, mouseY - 10, 16, null);
            }
        }
        for (int i = 0; i < this.getContainer().energySlotList.size(); ++i) {
            WidgetEnergySlot slot = this.getContainer().energySlotList.get(i);
            slot.drawWidget();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.getContainer().energySlotList.forEach(energySlot -> {
            if (energySlot.isMouseOverWidget(mouseX, mouseY)) {
                LiquidAIEnergy energyItem = Utils.getEnergyFromItemStack(this.player.field_71071_by.func_70445_o(), this.energyInterface.getHostWorld());
                try {
                    energySlot.onMouseClicked(new EnergyStack(energyItem, 1L));
                }
                catch (Exception e) {
                    AILog.debug(e + "", new Object[0]);
                }
            }
        });
    }

    private void drawPower(int pLeft, int pTop, int pMouseX, int pMouseY, int width, AEPartLocation side) {
        int height = this.getStorage(side) / (this.energyInterface.getMaxEnergyStored(side, this.getContainer().linkedMetric) / 83);
        int v = 0;
        boolean hover = this.drawPowerBar(pLeft, pTop, pMouseX, pMouseY, width, height, v, v);
        if (this.energyInterface != null) {
            if (this.energyInterface.getMaxEnergyStored(side, this.getContainer().linkedMetric) != 0) {
                if (hover) {
                    this.addBarTooltip(side);
                }
            } else {
                hover = AIGuiHelper.INSTANCE.isPointInGuiRegion(pTop - 9, pLeft - 10, 83, width, pMouseX, pMouseY, this.field_147003_i, this.field_147009_r);
                if (hover) {
                    String str = "Energy Stored: ? / ?";
                    this.drawMouseOver(str);
                }
            }
        }
    }

    private int getStorage(AEPartLocation side) {
        if (this.energyInterface instanceof PartEnergyInterface) {
            return this.getContainer().storage == null ? 0 : this.getContainer().storage.intValue();
        }
        return this.getContainer().sideStorageMap.get(side) == null ? 0 : this.getContainer().sideStorageMap.get(side).intValue();
    }

    private boolean drawPowerBar(int pLeft, int pTop, int pMouseX, int pMouseY, int width, int height, int v, int u) {
        this.func_73729_b(pLeft, pTop + (83 - height), v, u, width, height);
        return AIGuiHelper.INSTANCE.isPointInGuiRegion(pTop - 9, pLeft - 10, 83, width, pMouseX, pMouseY, this.field_147003_i, this.field_147009_r);
    }

    private void addBarTooltip(AEPartLocation side) {
        String str = null;
        if (this.energyInterface instanceof PartEnergyInterface) {
            str = String.format("%s: %,d %s/%,d %s", I18n.func_74838_a((String)"Energy Stored"), this.getStorage(side), this.getContainer().linkedMetric.getEnergyName(), this.energyInterface.getMaxEnergyStored(side, this.getContainer().linkedMetric), this.getContainer().linkedMetric.getEnergyName());
        } else if (this.energyInterface instanceof TileEnergyInterface) {
            str = String.format("%s\n%s: %,d %s/%,d %s", side.name(), I18n.func_74838_a((String)"Energy Stored"), this.getStorage(side), this.getContainer().linkedMetric.getEnergyName(), this.energyInterface.getMaxEnergyStored(side, this.getContainer().linkedMetric), this.getContainer().linkedMetric.getEnergyName());
        }
        this.drawMouseOver(str);
    }

    public void drawMouseOver(String tip) {
        if (tip != null) {
            this.tooltip.clear();
            this.tooltip.add(tip);
        }
    }

    @Override
    public ISyncHost getSyncHost() {
        return this.getContainer().getSyncHost();
    }

    @Override
    public void setSyncHost(ISyncHost host) {
        this.getContainer().setSyncHost(host);
    }
}

