/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Gui.Part.Interaction;

import AppliedIntegrations.Container.part.ContainerInteractionBus;
import AppliedIntegrations.Container.slot.SlotFilter;
import AppliedIntegrations.Gui.AIGui;
import AppliedIntegrations.Gui.Hosts.IWidgetHost;
import AppliedIntegrations.Gui.Part.Interaction.Buttons.GuiClickModeButton;
import AppliedIntegrations.Gui.Widgets.WidgetGuiTab;
import AppliedIntegrations.Items.ItemEnum;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PacketEnum;
import AppliedIntegrations.Parts.Interaction.PartInteraction;
import AppliedIntegrations.api.IEnumHost;
import AppliedIntegrations.api.ISyncHost;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.widgets.GuiImgButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.GL11;

public class GuiInteractionBus
extends AIGui {
    private static final ResourceLocation TEXTURE_INVENTORY = new ResourceLocation("appliedintegrations", "textures/gui/interaction.bus.inventory.png");
    private static final ResourceLocation TEXTURE_FILTER = new ResourceLocation("appliedintegrations", "textures/gui/interaction.bus.png");
    public PartInteraction.EnumInteractionPlaneTabs currentTab = PartInteraction.EnumInteractionPlaneTabs.PLANE_FAKE_PLAYER_FILTER;
    private List<WidgetGuiTab> tabs = new ArrayList<WidgetGuiTab>();

    public GuiInteractionBus(ContainerInteractionBus container, EntityPlayer player) {
        super(container, player);
    }

    public ContainerInteractionBus getContainer() {
        return (ContainerInteractionBus)this.field_147002_h;
    }

    private void drawFilterSlotsBackground() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_FILTER);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (SlotFilter filter : this.getContainer().filters) {
            int x = filter.field_75223_e - 1;
            int y = filter.field_75221_f - 1;
            if (!filter.func_111238_b()) continue;
            this.func_73729_b(x, y, 79, 39, 18, 18);
        }
    }

    private void playClickSound() {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @Override
    public void onButtonClicked(GuiButton btn, int mouseButton) {
        if (btn == this.getContainer().shiftClickButton && this.currentTab == PartInteraction.EnumInteractionPlaneTabs.PLANE_FAKE_PLAYER_FILTER) {
            this.getContainer().shiftClickButton.cycleMode();
        }
    }

    @Override
    public ISyncHost getSyncHost() {
        return this.getContainer().getSyncHost();
    }

    @Override
    public void setSyncHost(ISyncHost host) {
        this.getContainer().setSyncHost(host);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.add(new WidgetGuiTab((IWidgetHost)this, 0, -28, 4, true, (Enum)PartInteraction.EnumInteractionPlaneTabs.PLANE_FAKE_PLAYER_FILTER, "Interaction Bus Filters", ItemEnum.ITEMPARTINTERACTIONBUS.getItem(), this.field_146296_j, this.field_146289_q));
        this.tabs.add(new WidgetGuiTab((IWidgetHost)this, 29, -28, 1, false, (Enum)PartInteraction.EnumInteractionPlaneTabs.PLANE_FAKE_PLAYER_INVENTORY, "Interaction Bus Inventory", (Block)Blocks.field_150486_ae, this.field_146296_j, this.field_146289_q));
        this.getContainer().shiftClickButton = new GuiClickModeButton(this, 0, this.field_147003_i - 18, this.field_147009_r + 8, 16, 16, "");
        this.field_146292_n.add(this.getContainer().shiftClickButton);
        this.getContainer().redstoneControlButton = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 28, (Enum)Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getContainer().fuzzyModeButton = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 48, (Enum)Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getContainer().craftingModeButton = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 68, (Enum)Settings.CRAFT_ONLY, (Enum)YesNo.NO);
        this.getContainer().redstoneControlButton.setVisibility(false);
        this.getContainer().fuzzyModeButton.setVisibility(false);
        this.getContainer().craftingModeButton.setVisibility(false);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (WidgetGuiTab tab : this.tabs) {
            if (!tab.isMouseOverWidget(mouseX, mouseY)) continue;
            this.currentTab = (PartInteraction.EnumInteractionPlaneTabs)tab.tabEnum;
            this.playClickSound();
            tab.mouseClicked();
            for (WidgetGuiTab unselectedTab : this.tabs) {
                if (unselectedTab == tab) continue;
                unselectedTab.isTabSelected = false;
            }
        }
        if (this.getContainer().redstoneControlButton.func_146115_a()) {
            short ordinal = (short)this.getContainer().redstoneControlButton.getCurrentValue().ordinal();
            this.getContainer().redstoneControlButton.set((Enum)(ordinal == 3 ? RedstoneMode.IGNORE : RedstoneMode.values()[ordinal + 1]));
            NetworkHandler.sendToServer(new PacketEnum(this.getContainer().redstoneControlButton.getCurrentValue(), (IEnumHost)this.getContainer().getSyncHost()));
            this.playClickSound();
        }
        if (this.getContainer().fuzzyModeButton.func_146115_a()) {
            short ordinal = (short)this.getContainer().fuzzyModeButton.getCurrentValue().ordinal();
            this.getContainer().fuzzyModeButton.set((Enum)(ordinal == 4 ? FuzzyMode.IGNORE_ALL : FuzzyMode.values()[ordinal + 1]));
            NetworkHandler.sendToServer(new PacketEnum(this.getContainer().fuzzyModeButton.getCurrentValue(), (IEnumHost)this.getContainer().getSyncHost()));
            this.playClickSound();
        }
        if (this.getContainer().craftingModeButton.func_146115_a()) {
            this.getContainer().craftingModeButton.set((Enum)(this.getContainer().craftingModeButton.getCurrentValue() == YesNo.NO ? YesNo.YES : YesNo.NO));
            NetworkHandler.sendToServer(new PacketEnum(this.getContainer().craftingModeButton.getCurrentValue(), (IEnumHost)this.getContainer().getSyncHost()));
            this.playClickSound();
        }
    }

    protected boolean func_193983_c(int mouseX, int mouseY, int guiLeft, int guiTop) {
        for (WidgetGuiTab tab : this.tabs) {
            if (!tab.isMouseOverWidget(mouseX, mouseY)) continue;
            return false;
        }
        return mouseX < guiLeft || mouseY < guiTop || mouseX >= guiLeft + this.field_146999_f || mouseY >= guiTop + this.field_147000_g;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float pOpacity) {
        super.func_73863_a(mouseX, mouseY, pOpacity);
        for (WidgetGuiTab tab : this.tabs) {
            if (!tab.isMouseOverWidget(mouseX, mouseY)) continue;
            ArrayList<String> tip = new ArrayList<String>();
            tip.add(tab.getTabName());
            this.drawHoveringText(tip, mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currentTab == PartInteraction.EnumInteractionPlaneTabs.PLANE_FAKE_PLAYER_FILTER) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_FILTER);
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g + 75);
            this.func_73729_b(this.field_147003_i + 176, this.field_147009_r, 176, 0, 35, 86);
            this.getContainer().redstoneControlButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.getContainer().fuzzyModeButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.getContainer().craftingModeButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_INVENTORY);
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.currentTab == PartInteraction.EnumInteractionPlaneTabs.PLANE_FAKE_PLAYER_FILTER) {
            this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"ME Interaction Bus"), 9, 3, 0x404040);
            this.drawFilterSlotsBackground();
            if (this.getContainer().redstoneControlButton.func_146115_a()) {
                this.tooltip.addAll(Arrays.asList(this.getContainer().redstoneControlButton.getMessage().split("\n")));
            }
            if (this.getContainer().fuzzyModeButton.func_146115_a()) {
                this.tooltip.addAll(Arrays.asList(this.getContainer().fuzzyModeButton.getMessage().split("\n")));
            }
            if (this.getContainer().craftingModeButton.func_146115_a()) {
                this.tooltip.addAll(Arrays.asList(this.getContainer().craftingModeButton.getMessage().split("\n")));
            }
        }
        this.tabs.forEach(WidgetGuiTab::drawWidget);
    }
}

