/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Gui.Widgets;

import AppliedIntegrations.Gui.Hosts.IWidgetHost;
import AppliedIntegrations.Gui.Widgets.AIWidget;
import appeng.client.gui.widgets.IScrollSource;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class WidgetScrollbar
extends AIWidget {
    private double step;
    private int minScroll;
    private int maxScroll;

    public WidgetScrollbar(IWidgetHost hostGUI, int xPos, int yPos) {
        super(hostGUI, xPos, yPos);
        this.minScroll = yPos;
    }

    public double onWheel(double diff) {
        diff = Math.max(Math.min(-diff, this.step), -this.step);
        double oldPos = this.yPosition;
        this.yPosition = (int)Math.min(Math.max((double)this.yPosition + diff, (double)this.minScroll), (double)this.maxScroll);
        return oldPos != (double)this.yPosition ? diff : 0.0;
    }

    public WidgetScrollbar setMaxScroll(int maxScroll) {
        this.maxScroll = maxScroll;
        return this;
    }

    public WidgetScrollbar setScrollStep(double scrollStep) {
        this.step = scrollStep;
        return this;
    }

    @Override
    public void drawWidget() {
        GL11.glDisable((int)2896);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/gui/container/creative_inventory/tabs.png"));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.xPosition, this.yPosition, 244, 0, 12, 15);
        GL11.glEnable((int)2896);
    }

    @Override
    public void getTooltip(List<String> tooltip) {
    }

    public static class GuiScrollbar
    extends AIWidget
    implements IScrollSource {
        private static final int scrollHeight = 15;
        private static final int width = 12;
        private int pageSize = 1;
        private int maxScroll = 0;
        private int currentScroll = 0;
        private int scrollFieldHeight = 88;

        public GuiScrollbar(IWidgetHost hostGUI, int xPos, int yPos) {
            super(hostGUI, xPos, yPos);
        }

        @Override
        public void drawWidget() {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("minecraft", "textures/gui/container/creative_inventory/tabs.png"));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int offset = this.currentScroll * (this.scrollFieldHeight - 15) / this.maxScroll;
            this.func_73729_b(this.xPosition, offset + this.yPosition, 232, 0, 12, 15);
        }

        @Override
        public void getTooltip(List<String> tooltip) {
        }

        public void setRange(int max, int pageSize) {
            this.maxScroll = max;
            this.pageSize = pageSize;
            this.applyRange();
        }

        private void applyRange() {
            this.currentScroll = Math.max(Math.min(this.currentScroll, this.maxScroll), 0);
        }

        public int getCurrentScroll() {
            return this.currentScroll;
        }

        public void click(int x, int y) {
            if (x > this.xPosition && x <= this.xPosition + 12 && y > this.yPosition && y <= this.yPosition + this.scrollFieldHeight) {
                this.currentScroll = y - this.yPosition;
                this.currentScroll = this.currentScroll * 2 * this.maxScroll / this.scrollFieldHeight;
                this.currentScroll = this.currentScroll + 1 >> 1;
                this.applyRange();
            }
        }

        public int wheel(int delta) {
            int oldScroll = this.currentScroll;
            delta = Math.max(Math.min(-delta, 1), -1);
            this.currentScroll += delta * this.pageSize;
            this.applyRange();
            return this.currentScroll != oldScroll ? delta : 0;
        }
    }
}

