/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Helpers.Energy;

import AppliedIntegrations.Integration.IntegrationsHelper;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import appeng.api.config.Actionable;
import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import mekanism.api.energy.IEnergizedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux", striprefs=true), @Optional.Interface(iface="mekanism.api.energy.IEnergizedItem", modid="mekanism", striprefs=true), @Optional.Interface(iface="ic2.api.item.IElectricItem", modid="ic2", striprefs=true)})
public class StackCapabilityHelper {
    private ItemStack operatedStack;

    public StackCapabilityHelper(ItemStack stack) {
        this.operatedStack = stack;
    }

    public boolean hasCapability(LiquidAIEnergy energy) {
        Item item = this.operatedStack.func_77973_b();
        if (!IntegrationsHelper.instance.isLoaded(energy, true)) {
            return false;
        }
        if (energy == AIEnergy.RF && item instanceof IEnergyContainerItem) {
            return true;
        }
        if (energy == AIEnergy.EU && item instanceof IElectricItem) {
            return true;
        }
        return energy == AIEnergy.J && item instanceof IEnergyContainerItem;
    }

    public int getStored(LiquidAIEnergy energy) {
        Item item = this.operatedStack.func_77973_b();
        if (!IntegrationsHelper.instance.isLoaded(energy, true)) {
            return 0;
        }
        if (energy == AIEnergy.RF && item instanceof IEnergyContainerItem) {
            IEnergyContainerItem rfContainer = (IEnergyContainerItem)item;
            return rfContainer.getEnergyStored(this.operatedStack);
        }
        if (energy == AIEnergy.EU && item instanceof IElectricItem) {
            return (int)ElectricItem.manager.getCharge(this.operatedStack);
        }
        if (energy == AIEnergy.J && item instanceof IEnergizedItem) {
            IEnergizedItem jouleContainer = (IEnergizedItem)item;
            return (int)jouleContainer.getEnergy(this.operatedStack);
        }
        return 0;
    }

    public int extractEnergy(LiquidAIEnergy energy, int energyTransfer, Actionable action) {
        Item item = this.operatedStack.func_77973_b();
        if (!IntegrationsHelper.instance.isLoaded(energy, true)) {
            return 0;
        }
        if (energy == AIEnergy.RF && item instanceof IEnergyContainerItem) {
            IEnergyContainerItem rfContainer = (IEnergyContainerItem)item;
            return rfContainer.extractEnergy(this.operatedStack, energyTransfer, action == Actionable.SIMULATE);
        }
        if (energy == AIEnergy.EU && item instanceof IElectricItem) {
            return (int)ElectricItem.manager.discharge(this.operatedStack, (double)energyTransfer, 4, true, false, action == Actionable.SIMULATE);
        }
        if (energy == AIEnergy.J && item instanceof IEnergizedItem) {
            IEnergizedItem jouleContainer = (IEnergizedItem)item;
            int before = (int)jouleContainer.getEnergy(this.operatedStack);
            jouleContainer.setEnergy(this.operatedStack, jouleContainer.getEnergy(this.operatedStack) - (double)energyTransfer);
            int current = (int)jouleContainer.getEnergy(this.operatedStack);
            if (action == Actionable.SIMULATE) {
                jouleContainer.setEnergy(this.operatedStack, (double)before);
            }
            return before - current;
        }
        return 0;
    }

    public int injectEnergy(LiquidAIEnergy energy, int energyTransfer, Actionable action) {
        Item item = this.operatedStack.func_77973_b();
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.RF, true) && item instanceof IEnergyContainerItem && energy == AIEnergy.RF) {
            IEnergyContainerItem rfContainer = (IEnergyContainerItem)item;
            return rfContainer.receiveEnergy(this.operatedStack, energyTransfer, action == Actionable.SIMULATE);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, true) && item instanceof IElectricItem && energy == AIEnergy.EU) {
            return (int)ElectricItem.manager.charge(this.operatedStack, (double)energyTransfer, 4, true, action == Actionable.SIMULATE);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, true) && item instanceof IEnergizedItem && energy == AIEnergy.J) {
            IEnergizedItem jouleContainer = (IEnergizedItem)item;
            int before = (int)jouleContainer.getEnergy(this.operatedStack);
            jouleContainer.setEnergy(this.operatedStack, jouleContainer.getEnergy(this.operatedStack) - (double)energyTransfer);
            int current = (int)jouleContainer.getEnergy(this.operatedStack);
            if (action == Actionable.SIMULATE) {
                jouleContainer.setEnergy(this.operatedStack, (double)before);
            }
            return (int)jouleContainer.getEnergy(this.operatedStack) - current;
        }
        return 0;
    }
}

