/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Integration;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Items.ItemEnum;
import AppliedIntegrations.api.AIApi;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import teamroots.embers.RegistryManager;
import vazkii.botania.common.block.ModBlocks;

public class IntegrationsHelper {
    public static IntegrationsHelper instance = new IntegrationsHelper();

    public boolean isLoaded(LiquidAIEnergy energy, boolean trueRFCheck) {
        if (energy == AIEnergy.RF) {
            if (!trueRFCheck) {
                return true;
            }
            return Loader.isModLoaded((String)"redstoneflux");
        }
        if (energy == AIEnergy.EU) {
            return Loader.isModLoaded((String)"ic2");
        }
        if (energy == AIEnergy.J) {
            return Loader.isModLoaded((String)"mekanism");
        }
        if (energy == AIEnergy.TESLA) {
            return Loader.isModLoaded((String)"tesla");
        }
        return false;
    }

    public void registerTunnelTypes() {
        AIApi api = Objects.requireNonNull(AIApi.instance());
        if (Loader.isModLoaded((String)"botania") && AIConfig.enableManaFeatures) {
            api.addTunnelAsStack(Item.func_150898_a((Block)ModBlocks.dreamwood), ItemEnum.ITEMP2PMANA.getStack());
        }
        if (Loader.isModLoaded((String)"embers") && AIConfig.enableEmberFeatures) {
            api.addTunnelAsStack(RegistryManager.shard_ember, ItemEnum.ITEMP2PEMBER.getStack());
        }
        if (Loader.isModLoaded((String)"bloodmagic") && AIConfig.enableWillFeatures) {
            api.addTunnelAsStack(RegistrarBloodMagicItems.SOUL_GEM, ItemEnum.ITEMP2PWILL.getStack());
        }
        if (!Loader.isModLoaded((String)"astralsorcery") || AIConfig.enableStarlightFeatures) {
            // empty if block
        }
        if (!Loader.isModLoaded((String)"xnet") || AIConfig.enableXnetFeatures) {
            // empty if block
        }
    }
}

