/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Items;

import AppliedIntegrations.Items.AIItemRegistrable;
import AppliedIntegrations.Topology.GraphToolMode;
import AppliedIntegrations.Topology.TopologyUtils;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEPartLocation;
import appeng.helpers.IMouseWheelItem;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class GraphTool
extends AIItemRegistrable
implements IMouseWheelItem {
    private GraphToolMode mode = GraphToolMode.ALL;

    public GraphTool(String registry) {
        super(registry);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("appliedintegrations", "mode"), (stack, worldIn, entityIn) -> ((float)this.mode.ordinal() + 1.0f) / 4.0f);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        boolean success = false;
        if (player.func_70613_aW()) {
            IGridHost host;
            RayTraceResult mop = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos);
            TileEntity te = world.func_175625_s(pos);
            IGridNode node = null;
            if (te instanceof IPartHost) {
                SelectedPart part = ((IPartHost)te).selectPart(mop.field_72307_f);
                if (part != null && part.part != null && part.part.getGridNode() != null) {
                    node = part.part.getGridNode();
                }
            } else if (te instanceof IGridHost && (host = (IGridHost)te).getGridNode(AEPartLocation.INTERNAL) != null) {
                node = host.getGridNode(AEPartLocation.INTERNAL);
            }
            if (node != null) {
                IGrid grid = node.getGrid();
                TopologyUtils.createWebUI(grid, player, this.mode, node.getMachine());
                player.func_145747_a(new TextComponentString("Created grid network graph at: ").func_150257_a((ITextComponent)TopologyUtils.createLink()));
                success = true;
            }
        }
        if (!success) {
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.SUCCESS;
    }

    public void onWheel(ItemStack is, boolean up) {
        this.cycleMode(up);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Switching mode to: " + this.mode.name()));
    }

    private void cycleMode(boolean up) {
        try {
            this.mode = up ? (this.mode == GraphToolMode.P2P_LINKS ? GraphToolMode.values()[0] : GraphToolMode.values()[this.mode.ordinal() + 1]) : (this.mode == GraphToolMode.values()[0] ? GraphToolMode.P2P_LINKS : GraphToolMode.values()[this.mode.ordinal() - 1]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

