/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Items.StorageCells;

import AppliedIntegrations.Items.AIItemRegistrable;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IItemList;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;

public class EnergyStorageCell
extends AIItemRegistrable
implements IStorageCell<IAEEnergyStack> {
    private int maxBytes;

    public EnergyStorageCell(String registry, int maxBytes) {
        super(registry);
        this.maxBytes = maxBytes;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        ICellInventoryHandler inventoryHandler = AEApi.instance().registries().cell().getCellInventory(stack, null, this.getChannel());
        AEApi.instance().client().addCellInformation(inventoryHandler, lines);
        if (inventoryHandler == null) {
            return;
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            IItemList cellEnergies = inventoryHandler.getAvailableItems(this.getChannel().createList());
            for (IAEEnergyStack currentStack : cellEnergies) {
                String energyName = currentStack.getStack().getEnergyName();
                if (energyName.equals("null")) continue;
                String energyInfo = TextFormatting.RED.toString() + energyName + " x " + currentStack.getStackSize();
                lines.add(energyInfo.toUpperCase());
            }
        } else {
            lines.add(TextFormatting.WHITE.toString() + "Hold" + TextFormatting.DARK_RED.toString() + " Shift " + TextFormatting.WHITE.toString() + "for");
        }
    }

    public int getBytes(@Nonnull ItemStack itemStack) {
        return this.maxBytes;
    }

    public int getBytesPerType(@Nonnull ItemStack itemStack) {
        return 1;
    }

    public int getTotalTypes(@Nonnull ItemStack itemStack) {
        return 1;
    }

    public boolean isBlackListed(@Nonnull ItemStack itemStack, @Nonnull IAEEnergyStack iaeEnergyStack) {
        return false;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(@Nonnull ItemStack itemStack) {
        return true;
    }

    public double getIdleDrain() {
        return 1.0;
    }

    @Nonnull
    public IStorageChannel<IAEEnergyStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class);
    }

    public boolean isEditable(ItemStack itemStack) {
        return true;
    }

    public IItemHandler getUpgradesInventory(ItemStack itemStack) {
        return new CellUpgrades(itemStack, 2);
    }

    public IItemHandler getConfigInventory(ItemStack itemStack) {
        return new CellConfig(itemStack);
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
    }
}

