/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Network.Packets;

import AppliedIntegrations.Gui.Hosts.IPriorityHostExtended;
import AppliedIntegrations.Network.Packets.AIPacket;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class PacketPriorityChange
extends AIPacket {
    public IPriorityHostExtended host;
    public String text;

    public PacketPriorityChange() {
    }

    public PacketPriorityChange(String text, IPriorityHostExtended host) {
        this.text = text;
        this.host = host;
    }

    public void fromBytes(ByteBuf buf) {
        this.host = (IPriorityHostExtended)this.readSyncHost(buf);
        byte[] bytes = new byte[buf.readInt()];
        buf.readBytes(bytes);
        this.text = new String(bytes, StandardCharsets.UTF_8);
    }

    public void toBytes(ByteBuf buf) {
        this.writeSyncHost(this.host, buf, true);
        byte[] bytes = this.text.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }
}

