/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Network.Packets.PartGUI;

import AppliedIntegrations.Inventory.Manager.UpgradeInventoryManager;
import AppliedIntegrations.Network.ClientPacketHelper;
import AppliedIntegrations.Network.Packets.AIPacket;
import AppliedIntegrations.api.ISyncHost;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.YesNo;
import io.netty.buffer.ByteBuf;

public class PacketFullSync
extends AIPacket {
    public ISyncHost part;
    public byte filterSize;
    public boolean redstoneControl;
    public boolean autoCrafting;
    public boolean compareFuzzy;
    public FuzzyMode fuzzyMode;
    public YesNo craftOnly;
    public RedstoneMode redstoneMode;

    public PacketFullSync() {
    }

    public PacketFullSync(UpgradeInventoryManager upgradeInventoryManager, ISyncHost interaction) {
        this.filterSize = upgradeInventoryManager.filterSize;
        this.redstoneControl = upgradeInventoryManager.redstoneControlled;
        this.autoCrafting = upgradeInventoryManager.autoCrafting;
        this.redstoneMode = upgradeInventoryManager.redstoneMode;
        this.compareFuzzy = upgradeInventoryManager.fuzzyCompare;
        this.fuzzyMode = upgradeInventoryManager.fuzzyMode;
        this.craftOnly = upgradeInventoryManager.craftOnly;
        this.part = interaction;
    }

    public void fromBytes(ByteBuf buf) {
        this.part = ClientPacketHelper.readSyncHostClient(buf);
        this.filterSize = buf.readByte();
        this.redstoneControl = buf.readBoolean();
        this.compareFuzzy = buf.readBoolean();
        this.autoCrafting = buf.readBoolean();
        this.redstoneMode = (RedstoneMode)this.readEnum(buf);
        this.fuzzyMode = (FuzzyMode)this.readEnum(buf);
        this.craftOnly = (YesNo)this.readEnum(buf);
    }

    public void toBytes(ByteBuf buf) {
        this.writeSyncHost(this.part, buf, false);
        buf.writeByte((int)this.filterSize);
        buf.writeBoolean(this.redstoneControl);
        buf.writeBoolean(this.compareFuzzy);
        buf.writeBoolean(this.autoCrafting);
        this.writeEnum((Enum)this.redstoneMode, buf);
        this.writeEnum((Enum)this.fuzzyMode, buf);
        this.writeEnum((Enum)this.craftOnly, buf);
    }
}

