/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.Energy;

import AppliedIntegrations.Helpers.Energy.CapabilityHelper;
import AppliedIntegrations.Parts.AIOPart;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.Parts.PartModelEnum;
import AppliedIntegrations.Utils.IterableHelpers;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PartEnergyImport
extends AIOPart {
    public PartEnergyImport() {
        super(PartEnum.EnergyImportBus);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, BlockPos pos, Random r) {
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public TickRateModulation doWork(int valuedTransfer, IGridNode node) {
        CapabilityHelper helper = new CapabilityHelper(this.adjacentEnergyStorage, this.getHostSide().getOpposite());
        for (LiquidAIEnergy energy : LiquidAIEnergy.energies.values()) {
            if (!IterableHelpers.containsOnlyNulls(this.filteredEnergies) && !this.filteredEnergies.contains((Object)energy) || !helper.operatesEnergy(energy)) continue;
            int injected = this.injectEnergy(new EnergyStack(energy, valuedTransfer), Actionable.SIMULATE);
            int extracted = helper.extractEnergy(injected, false, energy);
            this.injectEnergy(new EnergyStack(energy, extracted), Actionable.MODULATE);
            if (injected <= 0) continue;
            return TickRateModulation.FASTER;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public void onEntityCollision(Entity entity) {
    }

    @Override
    public float getCableConnectionLength(AECableType aeCableType) {
        return 0.0f;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return PartModelEnum.IMPORT_HAS_CHANNEL;
            }
            return PartModelEnum.IMPORT_ON;
        }
        return PartModelEnum.IMPORT_OFF;
    }
}

