/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.Interaction;

import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Gui.Part.Interaction.Buttons.ClickMode;
import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.Inventory.Manager.UpgradeInventoryManager;
import AppliedIntegrations.Parts.AIPart;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.Parts.PartModelEnum;
import AppliedIntegrations.api.IEnumHost;
import AppliedIntegrations.api.IInventoryHost;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.RedstoneMode;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.tuple.Pair;

public class PartInteraction
extends AIPart
implements IGridTickable,
IInventoryHost,
IEnumHost,
ICraftingRequester {
    private static final int MAX_FILTER_SIZE = 9;
    private static final int FAKE_PLAYER_INVENTORY_SIZE = 36;
    private static final int FAKE_PLAYER_ARMOR_INVENTORY_SIZE = 4;
    private static final int ROUNDS_COUNT = 4;
    private static final String KEY_FILTER_INVENTORY = "#FILTER_INVENTORY_KEY";
    private static final String KEY_MAIN_INVENTORY = "#MAIN_INVENTORY_KEY";
    private static final String KEY_ARMOR_INVENTORY = "#ARMOR_INVENTORY_KEY";
    private static final String KEY_OFFHAND_INVENTORY = "#OFFHAND_INVENTORY_KEY";
    private static final String KEY_UPGRADE_INVENTORY = "#UPGRADE_INVENTORY_KEY";
    private static final String KEY_SNEAKING = "#SNEAKING";
    public FakePlayer fakePlayer;
    public AIGridNodeInventory filterInventory = new AIGridNodeInventory("Interaction Bus Filter", 9, 1);
    public AIGridNodeInventory mainInventory = new AIGridNodeInventory("Interaction Bus Inventory", 36, 64, this);
    public AIGridNodeInventory armorInventory = new AIGridNodeInventory("Interaction Bus Armor Inventory", 4, 64, this);
    public AIGridNodeInventory offhandInventory = new AIGridNodeInventory("Interaction Bus Offhand Inventory", 1, 64, this);
    public UpgradeInventoryManager upgradeInventoryManager = new UpgradeInventoryManager(this, "Interaction Bus Upgrade Inventory", 4);
    private ArrayList<Future<ICraftingJob>> jobs = new ArrayList();
    private ArrayList<ICraftingLink> links = new ArrayList();
    private HashMap<ICraftingLink, BiConsumer<FakePlayer, BlockPos>> jobMethodMap = new HashMap();
    private List<Pair<BiConsumer<FakePlayer, BlockPos>, IAEItemStack>> clickModulationQueue = new ArrayList<Pair<BiConsumer<FakePlayer, BlockPos>, IAEItemStack>>();
    private UUID uniIdentifier;
    private boolean lastRedstone;
    private boolean sneaking;

    public PartInteraction() {
        super(PartEnum.InteractionPlane);
        for (int i = 0; i < 36; ++i) {
            this.jobs.add(null);
            this.links.add(null);
        }
    }

    private void createFakePlayer() {
        if (this.fakePlayer != null) {
            return;
        }
        World hostWorld = this.getHostWorld();
        this.getProxy().getNode().updateState();
        if (hostWorld instanceof WorldServer) {
            if (this.uniIdentifier == null) {
                this.uniIdentifier = UUID.randomUUID();
                IBlockState state = hostWorld.func_180495_p(this.getHostPos());
                hostWorld.func_184138_a(this.getHostPos(), state, state, 3);
            }
            GameProfile fakeProfile = new GameProfile(this.uniIdentifier, "appliedintegrationsfake_player_interaction_bus");
            try {
                this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)hostWorld), (GameProfile)fakeProfile);
            }
            catch (Exception e) {
                this.fakePlayer = null;
                return;
            }
            if (this.fakePlayer == null) {
                return;
            }
            this.fakePlayer.func_70095_a(this.sneaking);
            this.fakePlayer.field_70122_E = true;
            this.fakePlayer.field_71135_a = new NetHandlerPlayServer(FMLCommonHandler.instance().getMinecraftServerInstance(), new NetworkManager(EnumPacketDirection.SERVERBOUND), (EntityPlayerMP)this.fakePlayer){

                public void func_147359_a(@Nonnull Packet packetIn) {
                }
            };
            this.fakePlayer.func_174810_b(true);
            this.fakePlayer.field_70165_t = this.getHostPos().func_177958_n();
            this.fakePlayer.field_70163_u = this.getHostPos().func_177956_o();
            this.fakePlayer.field_70161_v = this.getHostPos().func_177952_p();
            this.fakePlayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111128_a(1.0);
            this.fakePlayer.eyeHeight = 0.0f;
            if (this.getHostSide() == AEPartLocation.WEST) {
                this.fakePlayer.field_70177_z = 90.0f;
            } else if (this.getHostSide() == AEPartLocation.NORTH) {
                this.fakePlayer.field_70177_z = 180.0f;
            } else if (this.getHostSide() == AEPartLocation.EAST) {
                this.fakePlayer.field_70177_z = 270.0f;
            } else if (this.getHostSide() == AEPartLocation.DOWN) {
                this.fakePlayer.field_70125_A = 90.0f;
            } else if (this.getHostSide() == AEPartLocation.UP) {
                this.fakePlayer.field_70125_A = -90.0f;
            }
            this.onInventoryChanged();
        }
    }

    private void startJob(int craftingIndex, IAEItemStack input, ICraftingGrid craftingGrid, MachineSource src) throws GridAccessException {
        this.jobs.set(craftingIndex, craftingGrid.beginCraftingJob(this.getHostWorld(), this.getProxy().getGrid(), (IActionSource)src, input, null));
    }

    private void submitJob(int craftingIndex, BiConsumer<FakePlayer, BlockPos> method, ICraftingGrid craftingGrid, Future<ICraftingJob> futureJob) throws InterruptedException, ExecutionException {
        ICraftingJob job;
        ICraftingJob iCraftingJob = job = futureJob.isDone() ? futureJob.get() : null;
        if (job != null) {
            ICraftingLink link = craftingGrid.submitJob(job, (ICraftingRequester)this, null, false, (IActionSource)new MachineSource((IActionHost)this));
            if (link == null) {
                return;
            }
            this.links.set(craftingIndex, link);
            this.jobs.set(craftingIndex, null);
            this.jobMethodMap.put(link, method);
        }
    }

    private void interactBlock(FakePlayer player, BlockPos facingPos) {
        ItemStack itemStack = player.func_184614_ca();
        player.field_71134_c.func_187251_a((EntityPlayer)player, this.getHostWorld(), itemStack, EnumHand.MAIN_HAND, facingPos, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
    }

    private void interactEntity(FakePlayer player, BlockPos facingPos) {
        List ents = this.getHostWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)facingPos.func_177958_n() - 0.5, (double)facingPos.func_177956_o() - 0.5, (double)facingPos.func_177952_p() - 0.5, (double)facingPos.func_177958_n() + 0.5, (double)facingPos.func_177956_o() + 0.5, (double)facingPos.func_177952_p() + 0.5));
        for (EntityLivingBase ent : ents) {
            player.func_190775_a((Entity)ent, EnumHand.MAIN_HAND);
        }
    }

    private void onItemUse(FakePlayer player, BlockPos facingPos) {
        ActionResult result = player.func_184614_ca().func_77973_b().func_77659_a(this.getHostWorld(), (EntityPlayer)player, EnumHand.MAIN_HAND);
        player.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)result.func_188398_b());
    }

    private void onItemRightClick(FakePlayer player, BlockPos facingPos) {
        RayTraceResult traceResult = this.getTraceResult(player);
        if (traceResult == null) {
            return;
        }
        player.func_184614_ca().func_77973_b().func_180614_a((EntityPlayer)player, this.getHostWorld(), traceResult.func_178782_a(), EnumHand.MAIN_HAND, traceResult.field_178784_b, (float)traceResult.field_72307_f.field_72450_a, (float)traceResult.field_72307_f.field_72448_b, (float)traceResult.field_72307_f.field_72449_c);
    }

    private RayTraceResult getTraceResult(FakePlayer player) {
        Vec3d position = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)) * f4;
        float f7 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)) * f4;
        double range = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d direction = position.func_72441_c((double)f6 * range, (double)f5 * range, (double)f7 * range);
        return this.getHostWorld().func_147447_a(position, direction, true, false, false);
    }

    private void click(int craftingIndex, ItemStack stack, FakePlayer player, BlockPos facingPos, BiConsumer<FakePlayer, BlockPos> method) {
        try {
            boolean hasJob;
            player.func_184611_a(EnumHand.MAIN_HAND, stack.func_77946_l());
            ICraftingGrid craftingGrid = this.getProxy().getCrafting();
            Future<ICraftingJob> futureJob = this.jobs.get(craftingIndex);
            boolean bl = hasJob = futureJob != null;
            if (hasJob) {
                this.submitJob(craftingIndex, method, craftingGrid, futureJob);
            }
            IMEMonitor<IAEItemStack> inventory = this.getMEInventory();
            IAEItemStack input = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)player.func_184614_ca());
            boolean beginJob = false;
            if (!this.upgradeInventoryManager.autoCrafting || this.upgradeInventoryManager.craftOnly == YesNo.NO) {
                IAEItemStack extractedInput = (IAEItemStack)inventory.extractItems((IAEStack)input, Actionable.SIMULATE, (IActionSource)new MachineSource((IActionHost)this));
                if (extractedInput != null) {
                    this.modulateClick(facingPos, method, inventory, extractedInput);
                } else if (this.upgradeInventoryManager.autoCrafting) {
                    beginJob = true;
                }
            } else if (this.upgradeInventoryManager.craftOnly == YesNo.YES) {
                beginJob = true;
            }
            if (beginJob && !hasJob) {
                this.startJob(craftingIndex, input, craftingGrid, new MachineSource((IActionHost)this));
            }
        }
        catch (GridAccessException | InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void modulateClick(BlockPos facingPos, BiConsumer<FakePlayer, BlockPos> method, IMEMonitor<IAEItemStack> inventory, IAEItemStack extracted) throws GridAccessException {
        inventory.extractItems((IAEStack)extracted, Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
        method.accept(this.fakePlayer, facingPos);
        this.injectStack(this.fakePlayer.func_184614_ca(), inventory);
    }

    @Nonnull
    private List<ItemStack> getFuzzyComparedItemList(ItemStack[] slots) throws GridAccessException {
        IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : slots) {
            for (IAEItemStack fuzzyStack : inv.getStorageList().findFuzzy(((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack), this.upgradeInventoryManager.fuzzyMode)) {
                ret.add(fuzzyStack.getDefinition());
            }
        }
        return ret;
    }

    private void injectStack(ItemStack stack, IMEMonitor<IAEItemStack> inventory) throws GridAccessException {
        IAEItemStack aeStack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack);
        if (aeStack == null || aeStack.getDefinition().func_190926_b()) {
            return;
        }
        IAEItemStack notInjected = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getProxy().getEnergy(), inventory, (IAEStack)aeStack, (IActionSource)new MachineSource((IActionHost)this));
        if (notInjected != null) {
            this.getHostWorld().func_72838_d((Entity)new EntityItem(this.getHostWorld(), 0.5 + (double)this.getHostPos().func_177958_n(), 0.5 + (double)this.getHostPos().func_177956_o(), 0.2 + (double)this.getHostPos().func_177952_p(), notInjected.getDefinition().func_77946_l()));
        }
    }

    private void processTick() throws GridAccessException {
        BlockPos facingPos = this.getHostPos().func_177972_a(this.getHostSide().getFacing());
        this.fakePlayer.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        List<ItemStack> list = this.upgradeInventoryManager.fuzzyCompare ? this.getFuzzyComparedItemList(this.filterInventory.slots) : Arrays.asList(this.filterInventory.slots);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = list.get(i);
            if (stack.func_190926_b()) continue;
            this.click(i, stack, this.fakePlayer, facingPos, this::onItemRightClick);
            this.click(i * 2, stack, this.fakePlayer, facingPos, this::interactEntity);
            this.click(i * 2 + i, stack, this.fakePlayer, facingPos, this::interactBlock);
            this.click(i * 3 + i, stack, this.fakePlayer, facingPos, this::onItemUse);
        }
    }

    private IMEMonitor<IAEItemStack> getMEInventory() throws GridAccessException {
        return this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        drops.addAll(Arrays.asList(this.mainInventory.slots));
        drops.addAll(Arrays.asList(this.armorInventory.slots));
        drops.addAll(Arrays.asList(this.offhandInventory.slots));
        drops.addAll(Arrays.asList(this.upgradeInventoryManager.upgradeInventory.slots));
    }

    @Override
    public void onInventoryChanged() {
        int idx;
        if (this.getHostWorld().field_72995_K) {
            return;
        }
        InventoryPlayer inventoryPlayer = this.fakePlayer.field_71071_by;
        for (idx = 1; idx < this.mainInventory.func_70302_i_(); ++idx) {
            inventoryPlayer.field_70462_a.set(idx, (Object)this.mainInventory.func_70301_a(idx));
        }
        for (idx = 0; idx < this.armorInventory.func_70302_i_(); ++idx) {
            inventoryPlayer.field_70460_b.set(idx, (Object)this.armorInventory.func_70301_a(idx));
        }
        for (idx = 0; idx < this.offhandInventory.func_70302_i_(); ++idx) {
            inventoryPlayer.field_184439_c.set(idx, (Object)this.offhandInventory.func_70301_a(idx));
        }
    }

    @Override
    public void onNeighborChanged(IBlockAccess iBlockAccess, BlockPos blockPos, BlockPos posChanged) {
        IGridNode node = this.getProxy().getNode();
        try {
            if (this.upgradeInventoryManager.redstoneMode == RedstoneMode.SIGNAL_PULSE && this.isReceivingRedstonePower() != this.lastRedstone) {
                this.lastRedstone = this.isReceivingRedstonePower();
                if (node == null || this.fakePlayer == null || !this.lastRedstone) {
                    return;
                }
                this.processTick();
            }
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.filterInventory.readFromNBT(data.func_150295_c(KEY_FILTER_INVENTORY, 10));
        this.upgradeInventoryManager.upgradeInventory.readFromNBT(data.func_150295_c(KEY_UPGRADE_INVENTORY, 10));
        this.mainInventory.readFromNBT(data.func_150295_c(KEY_MAIN_INVENTORY, 10));
        this.armorInventory.readFromNBT(data.func_150295_c(KEY_ARMOR_INVENTORY, 10));
        this.offhandInventory.readFromNBT(data.func_150295_c(KEY_OFFHAND_INVENTORY, 10));
        this.sneaking = data.func_74767_n(KEY_SNEAKING);
        this.upgradeInventoryManager.readFromNBT(data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        data.func_74782_a(KEY_FILTER_INVENTORY, (NBTBase)this.filterInventory.writeToNBT());
        data.func_74782_a(KEY_UPGRADE_INVENTORY, (NBTBase)this.upgradeInventoryManager.upgradeInventory.writeToNBT());
        data.func_74782_a(KEY_MAIN_INVENTORY, (NBTBase)this.mainInventory.writeToNBT());
        data.func_74782_a(KEY_ARMOR_INVENTORY, (NBTBase)this.armorInventory.writeToNBT());
        data.func_74782_a(KEY_OFFHAND_INVENTORY, (NBTBase)this.offhandInventory.writeToNBT());
        data.func_74757_a(KEY_SNEAKING, this.fakePlayer.func_70093_af());
        this.upgradeInventoryManager.writeToNBT(data);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d vec3d) {
        if (Platform.isServer() && !player.func_70093_af()) {
            AIGuiHandler.open(AIGuiHandler.GuiEnum.GuiInteraction, player, this.getHostSide(), this.getHostTile().func_174877_v());
        }
        return true;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return PartModelEnum.INTERACTION_HAS_CHANNEL;
            }
            return PartModelEnum.INTERACTION_ON;
        }
        return PartModelEnum.INTERACTION_OFF;
    }

    @Override
    protected AIGridNodeInventory getUpgradeInventory() {
        return this.upgradeInventoryManager.upgradeInventory;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 15.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    public void onEntityCollision(Entity entity) {
    }

    public float getCableConnectionLength(AECableType cable) {
        return 2.0f;
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        this.createFakePlayer();
        try {
            if (this.canDoWork(this.upgradeInventoryManager.redstoneMode)) {
                this.processTick();
            }
            for (Pair<BiConsumer<FakePlayer, BlockPos>, IAEItemStack> pair : this.clickModulationQueue) {
                this.injectStack(((IAEItemStack)pair.getRight()).getDefinition(), this.getMEInventory());
                this.modulateClick(this.getHostPos().func_177972_a(this.getHostSide().getFacing()), (BiConsumer)pair.getLeft(), this.getMEInventory(), (IAEItemStack)pair.getRight());
            }
            this.clickModulationQueue.clear();
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
        return TickRateModulation.SAME;
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(10, 10, false, false);
    }

    @Override
    public void setEnumVal(Enum val) {
        if (val instanceof ClickMode) {
            this.fakePlayer.func_70095_a(val == ClickMode.SHIFT_CLICK);
        } else {
            this.upgradeInventoryManager.acceptVal(val);
        }
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        ArrayList<ICraftingLink> nonnullLinks = new ArrayList<ICraftingLink>(this.links);
        nonnullLinks.removeAll(Collections.singletonList(null));
        return ImmutableSet.copyOf(nonnullLinks);
    }

    public void jobStateChange(ICraftingLink link) {
        for (int i = 0; i < this.links.size(); ++i) {
            if (this.links.get(i) != link) continue;
            this.links.set(i, null);
        }
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        BiConsumer<FakePlayer, BlockPos> method = this.jobMethodMap.get(link);
        if (method == null) {
            return null;
        }
        this.clickModulationQueue.add((Pair<BiConsumer<FakePlayer, BlockPos>, IAEItemStack>)Pair.of(method, (Object)items));
        this.jobMethodMap.remove(link);
        return null;
    }

    public static enum EnumInteractionPlaneTabs {
        PLANE_FAKE_PLAYER_FILTER,
        PLANE_FAKE_PLAYER_INVENTORY;

    }
}

