/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.P2P;

import AppliedIntegrations.Parts.P2P.AIP2PModels;
import AppliedIntegrations.Parts.P2P.AIPartP2PTunnel;
import AppliedIntegrations.Parts.PartModelEnum;
import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.me.GridAccessException;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;

public class PartEmberP2PTunnel
extends AIPartP2PTunnel<PartEmberP2PTunnel> {
    private static final AIP2PModels MODELS = new AIP2PModels(PartModelEnum.P2P_EMBER.getFirstModel());
    private static final IEmberCapability NULL_HANDLER = new NullEmberHandler();
    private OutputEmberHandler outputHandler = new OutputEmberHandler();
    private InputEmberHandler inputHandler = new InputEmberHandler();

    public PartEmberP2PTunnel(ItemStack is) {
        super(is);
    }

    @Nonnull
    private IEmberCapability getAdjacentEmberStorage() {
        TileEntity self;
        TileEntity te;
        if (this.isActive() && (te = (self = this.getTile()).func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()))) != null && te.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, this.getSide().getOpposite().getFacing())) {
            return (IEmberCapability)te.getCapability(EmbersCapabilities.EMBER_CAPABILITY, this.getSide().getOpposite().getFacing());
        }
        return NULL_HANDLER;
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public boolean hasCapability(Capability<?> capability) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability);
    }

    public <T> T getCapability(Capability<T> capability) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            if (this.isOutput()) {
                return (T)this.outputHandler;
            }
            return (T)this.inputHandler;
        }
        return (T)super.getCapability(capability);
    }

    private class InputEmberHandler
    implements IEmberCapability {
        private InputEmberHandler() {
        }

        public double getEmber() {
            int total = 0;
            try {
                for (PartEmberP2PTunnel t : PartEmberP2PTunnel.this.getOutputs()) {
                    total = (int)((double)total + t.getAdjacentEmberStorage().getEmber());
                }
            }
            catch (GridAccessException e) {
                return 0.0;
            }
            return total;
        }

        public double getEmberCapacity() {
            int total = 0;
            try {
                for (PartEmberP2PTunnel t : PartEmberP2PTunnel.this.getOutputs()) {
                    total = (int)((double)total + t.getAdjacentEmberStorage().getEmberCapacity());
                }
            }
            catch (GridAccessException e) {
                return 0.0;
            }
            return total;
        }

        public void setEmber(double v) {
        }

        public void setEmberCapacity(double v) {
        }

        public double addAmount(double amount, boolean simulate) {
            int totalReceived = 0;
            try {
                int outputTunnels = PartEmberP2PTunnel.this.getOutputs().size();
                if (outputTunnels == 0 | amount == 0.0) {
                    return 0.0;
                }
                double amountPerOutput = amount / (double)outputTunnels;
                double overflow = amountPerOutput == 0.0 ? amount : amount % amountPerOutput;
                for (PartEmberP2PTunnel target : PartEmberP2PTunnel.this.getOutputs()) {
                    IEmberCapability output = target.getAdjacentEmberStorage();
                    double toSend = amountPerOutput + overflow;
                    double received = output.addAmount(toSend, simulate);
                    overflow = toSend - received;
                    totalReceived = (int)((double)totalReceived + received);
                }
                if (!simulate) {
                    PartEmberP2PTunnel.this.queueTunnelDrain(PowerUnits.RF, totalReceived);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return totalReceived;
        }

        public double removeAmount(double v, boolean b) {
            return 0.0;
        }

        public void writeToNBT(NBTTagCompound nbtTagCompound) {
        }

        public void readFromNBT(NBTTagCompound nbtTagCompound) {
        }

        public void onContentsChanged() {
        }
    }

    private class OutputEmberHandler
    implements IEmberCapability {
        private OutputEmberHandler() {
        }

        public double getEmber() {
            return PartEmberP2PTunnel.this.getAdjacentEmberStorage().getEmber();
        }

        public double getEmberCapacity() {
            return PartEmberP2PTunnel.this.getAdjacentEmberStorage().getEmberCapacity();
        }

        public void setEmber(double v) {
        }

        public void setEmberCapacity(double v) {
        }

        public double addAmount(double v, boolean b) {
            return 0.0;
        }

        public double removeAmount(double amount, boolean simulate) {
            double total = PartEmberP2PTunnel.this.getAdjacentEmberStorage().removeAmount(amount, simulate);
            if (!simulate) {
                PartEmberP2PTunnel.this.queueTunnelDrain(PowerUnits.RF, total);
            }
            return total;
        }

        public void writeToNBT(NBTTagCompound nbtTagCompound) {
        }

        public void readFromNBT(NBTTagCompound nbtTagCompound) {
        }

        public void onContentsChanged() {
        }
    }

    private static class NullEmberHandler
    implements IEmberCapability {
        private NullEmberHandler() {
        }

        public double getEmber() {
            return 0.0;
        }

        public double getEmberCapacity() {
            return 0.0;
        }

        public void setEmber(double v) {
        }

        public void setEmberCapacity(double v) {
        }

        public double addAmount(double v, boolean b) {
            return 0.0;
        }

        public double removeAmount(double v, boolean b) {
            return 0.0;
        }

        public void writeToNBT(NBTTagCompound nbtTagCompound) {
        }

        public void readFromNBT(NBTTagCompound nbtTagCompound) {
        }

        public void onContentsChanged() {
        }
    }
}

