/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Utils;

import AppliedIntegrations.AppliedIntegrations;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AILog {
    public static final Logger log = LogManager.getLogger((String)"Applied Integrations");

    public static void debug(String format, Object ... data) {
        log.debug(String.format(format, data));
    }

    public static void error(Throwable e, String format, Object ... data) {
        log.error(String.format(format, data), e);
    }

    public static void chatLog(String message, EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    public static void debugThread(boolean useChatLog) {
        if (useChatLog) {
            AILog.chatLog(Thread.currentThread().getName());
            AILog.chatLog(AppliedIntegrations.getLogicalSide().name());
        } else {
            AILog.info(Thread.currentThread().getName(), new Object[0]);
            AILog.info(AppliedIntegrations.getLogicalSide().name(), new Object[0]);
        }
    }

    public static void chatLog(String message) {
        Minecraft.func_71410_x().field_71439_g.func_71165_d(message);
    }

    public static void info(String message, Object ... params) {
        log.info(message, params);
    }

    public static void debugObject(Object obj, boolean useChatLog) {
        for (Field f : obj.getClass().getFields()) {
            try {
                if (useChatLog) {
                    AILog.chatLog(f.get(obj).toString());
                    continue;
                }
                AILog.info(f.get(obj).toString(), new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void debugObjects(boolean useChatLog, Object ... objects) {
        for (Object obj : objects) {
            try {
                if (!useChatLog) {
                    AILog.info(obj.toString(), new Object[0]);
                    continue;
                }
                AILog.chatLog(obj.toString());
            }
            catch (NullPointerException nullPtr) {
                AILog.info("null", new Object[0]);
            }
        }
    }

    public static void serverMessage(String s) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(s));
    }
}

