/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.api;

import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.IInterfaceStorageDuality;
import AppliedIntegrations.api.INBTStorage;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import appeng.api.config.Actionable;
import appeng.api.util.AEPartLocation;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyInterfaceStorage
extends EnergyStorage
implements IInterfaceStorageDuality<Integer>,
INBTStorage {
    private final IEnergyInterface owner;
    private final AEPartLocation side;
    private final LiquidAIEnergy energyType;

    public EnergyInterfaceStorage(IEnergyInterface iEnergyInterface, AEPartLocation side, LiquidAIEnergy energy, int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
        this.owner = iEnergyInterface;
        this.side = side;
        this.energyType = energy;
    }

    @Override
    public void modifyEnergyStored(int energy) {
        this.owner.setLastInjectedEnergy(this.side, this.energyType);
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    @Override
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    @Override
    public Integer getStored() {
        return this.getEnergyStored();
    }

    @Override
    public Integer getMaxStored() {
        return this.getMaxEnergyStored();
    }

    @Override
    public Integer receive(Integer value, Actionable action) {
        this.owner.setLastInjectedEnergy(this.side, this.energyType);
        return this.receiveEnergy(value, action == Actionable.SIMULATE);
    }

    @Override
    public Integer extract(Integer value, Actionable action) {
        return this.extractEnergy(value, action == Actionable.SIMULATE);
    }

    @Override
    public Integer toNativeValue(Number val) {
        return val.intValue();
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.setEnergyStored(tag.func_74762_e("#ENERGY_TAG"));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("#ENERGY_TAG", this.getEnergyStored());
    }

    public void setEnergyStored(int energy) {
        this.owner.setLastInjectedEnergy(this.side, this.energyType);
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }
}

