/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.api.Multiblocks;

import AppliedIntegrations.api.Multiblocks.BlockType;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class BlockData {
    public byte x;
    public byte y;
    public byte z;
    public int meta;
    public BlockType type;
    public List<Block> options;

    public BlockData(int x, int y, int z, Block b, BlockType type) {
        this(x, y, z, type, b);
    }

    public BlockData(int x, int y, int z, BlockType type, Block ... blockOptions) {
        this(x, y, z, Arrays.asList(blockOptions));
        this.type = type;
    }

    public BlockData(int x, int y, int z, Block b) {
        this(x, y, z, b, b);
    }

    public BlockData(int x, int y, int z, Block ... blockOptions) {
        this(x, y, z, Arrays.asList(blockOptions));
    }

    public BlockData(int x, int y, int z, List<Block> options) {
        this.options = options;
        this.x = (byte)x;
        this.y = (byte)y;
        this.z = (byte)z;
    }

    public BlockData(BlockPos size, Block ... options) {
        this(size.func_177958_n(), size.func_177956_o(), size.func_177952_p(), options);
    }

    public BlockPos getPos() {
        return new BlockPos((int)this.x, (int)this.y, (int)this.z);
    }

    public BlockData offset(EnumFacing facing) {
        this.x = (byte)(this.x + facing.func_82601_c());
        this.y = (byte)(this.y + facing.func_96559_d());
        this.z = (byte)(this.z + facing.func_82599_e());
        return this;
    }

    public BlockData offset(EnumFacing facing, Integer length) {
        for (int i = 0; i < length; ++i) {
            this.offset(facing);
        }
        return this;
    }

    public BlockData inverse() {
        return new BlockData(this.x * -1, this.y * -1, this.z * -1, this.options);
    }
}

