/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.api.Storage;

import AppliedIntegrations.api.Storage.IEnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyStack
implements IEnergyStack {
    public long amount;
    private LiquidAIEnergy energy;

    public EnergyStack(LiquidAIEnergy energy, long amount) {
        this.energy = energy;
        this.amount = amount;
    }

    private EnergyStack(EnergyStack old) {
        this.energy = old.getEnergy();
        this.amount = old.getAmount();
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public EnergyStack() {
    }

    public static EnergyStack readFromNBT(NBTTagCompound tag) {
        if (tag != null && !tag.func_82582_d()) {
            EnergyStack stack = new EnergyStack();
            stack.read(tag);
            return stack.getEnergy() != null && stack.getAmount() > 0L ? stack : null;
        }
        return null;
    }

    public void read(NBTTagCompound tag) {
        this.energy = LiquidAIEnergy.getEnergy(tag.func_74779_i("Energy"));
        this.amount = tag.func_74763_f("Amount");
    }

    @Override
    public EnergyStack copy() {
        return new EnergyStack(this);
    }

    @Override
    public LiquidAIEnergy getEnergy() {
        return this.energy;
    }

    @Override
    public void setEnergy(@Nullable LiquidAIEnergy energy) {
        this.energy = energy;
    }

    @Override
    public String getEnergyName() {
        if (this.energy != null) {
            return this.energy.getEnergyName();
        }
        return "";
    }

    @Override
    public long getStackSize() {
        return this.amount;
    }

    @Override
    public void setStackSize(long size) {
        this.amount = size;
    }

    @Override
    public boolean isEmpty() {
        return this.amount == 0L || this.energy == null;
    }

    @Override
    public void setAll(@Nullable IEnergyStack stack) {
        if (stack == null) {
            this.energy = null;
            this.amount = 0L;
            return;
        }
        this.energy = stack.getEnergy();
        this.amount = stack.getStackSize();
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound data) {
        return this.write(data);
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        tag.func_74778_a("Energy", this.getEnergyTag());
        tag.func_74772_a("Amount", this.getAmount());
        return tag;
    }

    public String getEnergyTag() {
        if (this.energy != null) {
            return this.energy.getTag();
        }
        return "";
    }
}

