/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.HoleStorageSystem;

import AppliedIntegrations.Blocks.BlocksEnum;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.HoleStorage.PacketVectorSync;
import AppliedIntegrations.Utils.VectorUtils;
import AppliedIntegrations.tile.HoleStorageSystem.AITileStorageCell;
import AppliedIntegrations.tile.HoleStorageSystem.TimeHandler;
import AppliedIntegrations.tile.entities.EntitySingularity;
import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class TileMETurretFoundation
extends AITileStorageCell
implements ICellContainer {
    private static final int HOLES_TRAJECTORY_ANGLE = 20;
    AEPartLocation e;
    private static final String KEY_STORED_AMMO_SIZE = "#STORED_AMMO_SIZE";
    private static final String KEY_DIRECTION_X = "#DIRECTION_X";
    private static final String KEY_DIRECTION_Y = "#DIRECTION_Y";
    private static final String KEY_DIRECTION_Z = "#DIRECTION_Z";
    private static final String KEY_AMMO_TYPE = "#AMMO_TYPE";
    private static final double ANGLE_COS = Math.cos(45.0);
    private static final Vec3d[] BLACK_HOLE_VECTORS = new Vec3d[]{new Vec3d(ANGLE_COS, -1.0, 0.0), new Vec3d(ANGLE_COS, 1.0, 0.0), new Vec3d(ANGLE_COS, 0.0, -1.0), new Vec3d(ANGLE_COS, 0.0, 1.0), new Vec3d(-1.0, 0.0, ANGLE_COS), new Vec3d(1.0, 0.0, ANGLE_COS), new Vec3d(0.0, 0.0, 0.0)};
    private static final Vec3d[] WHITE_HOLE_VECTORS = new Vec3d[]{new Vec3d(-ANGLE_COS, -1.0, 0.0), new Vec3d(-ANGLE_COS, 1.0, 0.0), new Vec3d(-ANGLE_COS, 0.0, -1.0), new Vec3d(-ANGLE_COS, 0.0, 1.0), new Vec3d(-1.0, 0.0, -ANGLE_COS), new Vec3d(1.0, 0.0, -ANGLE_COS), new Vec3d(0.0, 0.0, 0.0)};
    public Vec3d direction = VectorUtils.getFractionalVector((Vec3i)this.getHostPos());
    public Vec3d blackHolePos = Vec3d.field_186680_a;
    public Vec3d whiteHolePos = Vec3d.field_186680_a;
    public Ammo ammo = Ammo.MatterBall;
    private ItemList storedAmmo = new ItemList();
    private boolean notifyClientAboutVectoryChange;

    public TileMETurretFoundation() {
        this.getProxy().setValidSides(EnumSet.of(EnumFacing.DOWN));
    }

    public boolean activate(EnumHand hand, EntityPlayer p) {
        if (hand == EnumHand.MAIN_HAND && Platform.isServer()) {
            this.setDirection(new Vec3d(p.field_70165_t, p.field_70163_u, p.field_70161_v), p.func_70093_af());
            return true;
        }
        return false;
    }

    private void setDirection(Vec3d pos, boolean inverse) {
        this.direction = VectorUtils.getUnitVector(pos.func_178788_d(VectorUtils.getFractionalVector((Vec3i)this.getHostPos())));
        AEPartLocation facing = VectorUtils.getVectorFacing(this.direction);
        int id = facing.ordinal();
        this.blackHolePos = inverse ? BLACK_HOLE_VECTORS[id] : WHITE_HOLE_VECTORS[id];
        this.whiteHolePos = inverse ? WHITE_HOLE_VECTORS[id] : BLACK_HOLE_VECTORS[id];
        this.notifyClientAboutVectoryChange = true;
    }

    private IAEItemStack getStoredAmmo(Ammo ammo) {
        return this.storedAmmo.findPrecise((IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)ammo.stack));
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < compound.func_74762_e(KEY_STORED_AMMO_SIZE); ++i) {
            this.storedAmmo.add(AEItemStack.fromNBT((NBTTagCompound)compound.func_74775_l("#SUB_TAG" + i)));
        }
        this.setDirection(new Vec3d(compound.func_74769_h(KEY_DIRECTION_X), compound.func_74769_h(KEY_DIRECTION_Y), compound.func_74769_h(KEY_DIRECTION_Z)), false);
        this.ammo = Ammo.values()[compound.func_74762_e(KEY_AMMO_TYPE)];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int amount = 0;
        Iterator iterator = this.storedAmmo.iterator();
        for (int i = 0; i < this.storedAmmo.size() && iterator.hasNext(); ++i) {
            IAEItemStack stack = (IAEItemStack)iterator.next();
            NBTTagCompound stackCompound = new NBTTagCompound();
            stack.writeToNBT(stackCompound);
            compound.func_74782_a("#SUB_TAG" + i, (NBTBase)stackCompound);
            ++amount;
        }
        compound.func_74768_a(KEY_STORED_AMMO_SIZE, amount);
        compound.func_74768_a(KEY_AMMO_TYPE, this.ammo.ordinal());
        compound.func_74780_a(KEY_DIRECTION_X, this.direction.field_72450_a);
        compound.func_74780_a(KEY_DIRECTION_Y, this.direction.field_72448_b);
        compound.func_74780_a(KEY_DIRECTION_Z, this.direction.field_72449_c);
        return super.func_189515_b(compound);
    }

    @Override
    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        TickRateModulation superTickRate = super.tickingRequest(node, ticksSinceLastCall);
        if (!this.ammo.hasCooldownPassed(this.field_145850_b)) {
            return superTickRate;
        }
        IAEItemStack storageEntry = this.getStoredAmmo(this.ammo);
        if (storageEntry == null) {
            return superTickRate;
        }
        if (this.notifyClientAboutVectoryChange && Platform.isServer()) {
            NetworkHandler.sendToAllInRange(new PacketVectorSync(this.direction, this.blackHolePos, this.whiteHolePos, this.ammo, this.func_174877_v()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
            this.notifyClientAboutVectoryChange = false;
        }
        World hostWorld = this.getHostWorld();
        if (this.ammo == Ammo.Singularity) {
            if (hostWorld.func_175640_z(this.getHostPos()) && storageEntry.getStackSize() >= 2L) {
                EntitySingularity blackSingularity = new EntitySingularity(hostWorld, this.getHostPos().func_177971_a(VectorUtils.toIntegerVector(this.blackHolePos)).func_177982_a(0, 1, 0), BlocksEnum.BlackHole);
                EntitySingularity whiteSingularity = new EntitySingularity(hostWorld, this.getHostPos().func_177971_a(VectorUtils.toIntegerVector(this.whiteHolePos)).func_177982_a(0, 1, 0), BlocksEnum.WhiteHole);
                blackSingularity.func_70024_g(this.blackHolePos.field_72450_a, this.blackHolePos.field_72448_b, this.blackHolePos.field_72449_c);
                whiteSingularity.func_70024_g(this.whiteHolePos.field_72450_a, this.whiteHolePos.field_72448_b, this.whiteHolePos.field_72449_c);
                blackSingularity.setLinked(whiteSingularity);
                whiteSingularity.setLinked(blackSingularity);
                hostWorld.func_72838_d((Entity)blackSingularity);
                hostWorld.func_72838_d((Entity)whiteSingularity);
                storageEntry.setStackSize(storageEntry.getStackSize() - 2L);
            }
        } else {
            List ents = hostWorld.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-10, -10, -10), this.field_174879_c.func_177982_a(10, 10, 10)));
            for (EntityLivingBase ent : ents) {
                if (ent instanceof EntityPlayer) continue;
                this.setDirection(new Vec3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v), false);
                ent.func_70097_a(DamageSource.field_76377_j, 1.0f);
                storageEntry.setStackSize(storageEntry.getStackSize() - 1L);
                return superTickRate;
            }
        }
        return superTickRate;
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> iStorageChannel) {
        if (!this.getGridNode().isActive()) {
            return new ArrayList<IMEInventoryHandler>();
        }
        if (iStorageChannel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            return Collections.singletonList(new IMEInventoryHandler<IAEItemStack>(){

                public IAEItemStack injectItems(IAEItemStack input, Actionable actionable, IActionSource iActionSource) {
                    if (input == null) {
                        return null;
                    }
                    if (input.getStackSize() == 0L) {
                        return null;
                    }
                    if (!this.canAccept(input)) {
                        return input;
                    }
                    if (actionable == Actionable.MODULATE) {
                        TileMETurretFoundation.this.ammo = Ammo.fromStack(input);
                        TileMETurretFoundation.this.storedAmmo.add(input);
                    }
                    return null;
                }

                public IAEItemStack extractItems(IAEItemStack iaeItemStack, Actionable actionable, IActionSource iActionSource) {
                    return null;
                }

                public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> iItemList) {
                    return TileMETurretFoundation.this.storedAmmo;
                }

                public IStorageChannel<IAEItemStack> getChannel() {
                    return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
                }

                public AccessRestriction getAccess() {
                    return AccessRestriction.READ_WRITE;
                }

                public boolean isPrioritized(IAEItemStack iaeItemStack) {
                    return false;
                }

                public boolean canAccept(IAEItemStack iaeItemStack) {
                    Item item = iaeItemStack.getItem();
                    Optional optionalMatterBall = AEApi.instance().definitions().materials().matterBall().maybeItem();
                    Optional optionalBlackHoleBall = AEApi.instance().definitions().materials().singularity().maybeItem();
                    return optionalBlackHoleBall.isPresent() && item == optionalBlackHoleBall.get() || optionalMatterBall.isPresent() && item == optionalMatterBall.get();
                }

                public int getPriority() {
                    return 0;
                }

                public int getSlot() {
                    return 0;
                }

                public boolean validForPass(int i) {
                    return true;
                }
            });
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    public static enum Ammo {
        MatterBall(1, (ItemStack)AEApi.instance().definitions().materials().matterBall().maybeStack(1).get()),
        Singularity(25, (ItemStack)AEApi.instance().definitions().materials().singularity().maybeStack(1).get());

        final TimeHandler cooldownHandler = new TimeHandler();
        int cooldown;
        ItemStack stack;

        private Ammo(int cooldown, ItemStack stack) {
            this.cooldown = cooldown;
            this.stack = stack;
        }

        public static Ammo fromStack(IAEItemStack input) {
            for (Ammo ammo : Ammo.values()) {
                ItemStack stack = ammo.getStack();
                ItemStack definition = input.getDefinition();
                if (!stack.func_77973_b().equals(definition.func_77973_b()) || stack.func_77960_j() != definition.func_77960_j()) continue;
                return ammo;
            }
            return null;
        }

        private ItemStack getStack() {
            return this.stack;
        }

        public boolean hasCooldownPassed(World w) {
            return this.cooldownHandler.hasTimePassed(w, this.cooldown);
        }
    }
}

