/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.HoleStorageSystem.singularities;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.HoleStorage.PacketSingularitiesEntangle;
import AppliedIntegrations.Utils.AILog;
import AppliedIntegrations.api.BlackHoleSystem.IPylon;
import AppliedIntegrations.api.BlackHoleSystem.ISingularity;
import AppliedIntegrations.api.Botania.IManaStorageChannel;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.tile.HoleStorageSystem.singularities.TileBlackHole;
import AppliedIntegrations.tile.entities.EntitySingularity;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileWhiteHole
extends TileEntity
implements ISingularity,
ITickable {
    public long mass;
    public TileBlackHole entangledHole;
    private EntitySingularity entangledHoleEntity = null;
    private List<IPylon> listeners = new ArrayList<IPylon>();
    public boolean notifyClientAboutSingularitiesEntangle;

    public TileWhiteHole() {
        this.mass = (long)(Math.random() * 2048.0);
    }

    public double getHoleRadius() {
        double lightSpeed = 3.0;
        return Math.max(Math.cbrt(Math.cbrt(13.4 * (double)this.mass / Math.pow(lightSpeed, 2.0))), 0.3);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer p, EnumHand hand) {
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (IPylon pylon : this.listeners) {
            pylon.setSingularity(null);
        }
    }

    public void func_73660_a() {
        if (Platform.isClient()) {
            return;
        }
        if (this.notifyClientAboutSingularitiesEntangle) {
            NetworkHandler.sendToAll(new PacketSingularitiesEntangle(this.entangledHole, this));
            this.notifyClientAboutSingularitiesEntangle = false;
        }
        if (this.entangledHoleEntity != null && this.entangledHoleEntity.field_70128_L && this.entangledHoleEntity.getBornSingularity() != null && this.entangledHole == null) {
            this.entangledHole = (TileBlackHole)this.entangledHoleEntity.getBornSingularity();
            this.entangledHoleEntity = null;
            this.notifyClientAboutSingularitiesEntangle = true;
        }
    }

    @Override
    public void addMass(long l) {
        this.mass -= l;
    }

    @Override
    public IAEStack<?> addStack(IAEStack<?> stack, Actionable actionable) {
        if (stack == null) {
            return null;
        }
        if (this.entangledHole == null) {
            return null;
        }
        if (stack.getStackSize() <= 0L) {
            return null;
        }
        if (stack instanceof IAEItemStack) {
            IAEItemStack pStack = this.entangledHole.storedItems.findPrecise((IAEItemStack)stack);
            IAEItemStack addStackReturn = pStack.copy();
            long size = pStack.getStackSize();
            if (size <= 0L) {
                return null;
            }
            if (pStack.getStackSize() <= size) {
                addStackReturn.setStackSize(pStack.getStackSize());
                if (actionable == Actionable.MODULATE) {
                    pStack.setStackSize(0L);
                }
            } else {
                addStackReturn.setStackSize(size);
                if (actionable == Actionable.MODULATE) {
                    pStack.setStackSize(pStack.getStackSize() - size);
                }
            }
            for (IPylon pylon : this.listeners) {
                pylon.postCellInventoryEvent();
            }
            return addStackReturn;
        }
        return null;
    }

    @Override
    public IItemList<?> getList(IStorageChannel chan) {
        if (chan == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            return !this.isEntangled() ? new IItemList() : this.entangledHole.getList(chan);
        }
        if (chan == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            return !this.isEntangled() ? new IItemList() : this.entangledHole.getList(chan);
        }
        if (AIConfig.enableEnergyFeatures && chan == AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class)) {
            return !this.isEntangled() ? new IItemList() : this.entangledHole.getList(chan);
        }
        if (AIConfig.enableManaFeatures && Loader.isModLoaded((String)"botania") && chan == AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class)) {
            return !this.isEntangled() ? new IItemList() : this.entangledHole.getList(chan);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setMassFromServer(long mass) {
        this.mass = mass;
    }

    @Override
    public long getMass() {
        return this.mass;
    }

    @Override
    public boolean isEntangled() {
        return this.entangledHole != null;
    }

    @Override
    public void setEntangledHoleEntity(EntitySingularity singularity) {
        AILog.chatLog("Setting entangled singularity to " + singularity.toString());
        this.entangledHoleEntity = singularity;
        for (IPylon pylon : this.listeners) {
            pylon.postCellInventoryEvent();
        }
    }

    @Override
    public void addListener(IPylon pylon) {
        this.listeners.add(pylon);
    }

    @Override
    public BlockPos getHostPos() {
        return this.field_174879_c;
    }

    @Override
    public World getHostWorld() {
        return this.field_145850_b;
    }

    @Override
    public AEPartLocation getHostSide() {
        return AEPartLocation.INTERNAL;
    }
}

