/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.HoleStorageSystem.storage;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Blocks.Additions.BlockBlackHole;
import AppliedIntegrations.Blocks.Additions.BlockMEPylon;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.HoleStorage.PacketPylonSingularitySync;
import AppliedIntegrations.Utils.AILog;
import AppliedIntegrations.api.AIApi;
import AppliedIntegrations.api.BlackHoleSystem.IPylon;
import AppliedIntegrations.api.BlackHoleSystem.ISingularity;
import AppliedIntegrations.api.Botania.IManaStorageChannel;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.api.Storage.helpers.BlackHoleSingularityInventoryHandler;
import AppliedIntegrations.api.Storage.helpers.WhiteHoleSingularityInventoryHandler;
import AppliedIntegrations.tile.HoleStorageSystem.AITileStorageCell;
import AppliedIntegrations.tile.HoleStorageSystem.TimeHandler;
import AppliedIntegrations.tile.HoleStorageSystem.singularities.TileBlackHole;
import AppliedIntegrations.tile.HoleStorageSystem.storage.helpers.impl.BlackHoleEnergyHandler;
import AppliedIntegrations.tile.HoleStorageSystem.storage.helpers.impl.BlackHoleFluidHandler;
import AppliedIntegrations.tile.HoleStorageSystem.storage.helpers.impl.BlackHoleItemHandler;
import AppliedIntegrations.tile.HoleStorageSystem.storage.helpers.impl.BlackHoleManaHandler;
import AppliedIntegrations.tile.HoleStorageSystem.storage.helpers.impl.WhiteHoleEnergyHandler;
import AppliedIntegrations.tile.HoleStorageSystem.storage.helpers.impl.WhiteHoleFluidHandler;
import AppliedIntegrations.tile.HoleStorageSystem.storage.helpers.impl.WhiteHoleItemHandler;
import AppliedIntegrations.tile.HoleStorageSystem.storage.helpers.impl.WhiteHoleManaHandler;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockAir;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.Loader;

public class TileMEPylon
extends AITileStorageCell
implements ICellContainer,
IGridTickable,
IPylon {
    public static final int DRAIN_LASTS_SECONDS = 3;
    private static LinkedHashMap<IStorageChannel, Class<? extends BlackHoleSingularityInventoryHandler<?>>> passiveBlackHoleHandlers = new LinkedHashMap();
    private static LinkedHashMap<IStorageChannel, Class<? extends WhiteHoleSingularityInventoryHandler<?>>> passiveWhiteHoleHandlers = new LinkedHashMap();
    public ISingularity operatedTile;
    public float beamDrain = 0.0f;
    public boolean shouldDrain = false;
    public TimeHandler drainHandler = new TimeHandler();
    private LinkedHashMap<IStorageChannel, BlackHoleSingularityInventoryHandler<?>> activeBlackHoleHandlers = new LinkedHashMap();
    private LinkedHashMap<IStorageChannel, WhiteHoleSingularityInventoryHandler<?>> activeWhiteHoleHandlers = new LinkedHashMap();
    private boolean activeHandlersLoaded = false;
    private boolean configured = false;

    public static void addBlackHoleHandler(Class<? extends BlackHoleSingularityInventoryHandler<?>> handlerClassA, IStorageChannel chan) {
        passiveBlackHoleHandlers.put(chan, handlerClassA);
    }

    public static void addWhiteHoleHandler(Class<? extends WhiteHoleSingularityInventoryHandler<?>> handlerClassB, IStorageChannel chan) {
        passiveWhiteHoleHandlers.put(chan, handlerClassB);
    }

    private void notifyClient() {
        NetworkHandler.sendToAll(new PacketPylonSingularitySync(this.operatedTile, this.getBeamState(), this.shouldDrain, this.func_174877_v()));
    }

    @Override
    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        TickRateModulation superTickRate = super.tickingRequest(node, ticksSinceLastCall);
        if (Platform.isServer()) {
            if (!this.configured) {
                this.getProxy().setValidSides(EnumSet.of(this.getFw().func_176734_d()));
                this.configured = true;
            }
            if (!this.activeHandlersLoaded) {
                this.initHandlers();
            }
            if (node.isActive()) {
                if (!this.hasSingularity()) {
                    this.tryToGetSingularity();
                } else if (this.shouldDrain) {
                    if (!this.drainHandler.hasTimePassed(this.field_145850_b, 3)) {
                        IEnergyGrid energyGrid = (IEnergyGrid)node.getGrid().getCache(IEnergyGrid.class);
                        double drain = energyGrid.extractAEPower((double)this.beamDrain, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                        energyGrid.extractAEPower(drain, Actionable.MODULATE, PowerMultiplier.CONFIG);
                        this.notifyClient();
                    } else {
                        this.shouldDrain = false;
                        this.notifyClient();
                    }
                }
            }
        }
        return superTickRate;
    }

    private void tryToGetSingularity() {
        if (this.hasSingularity()) {
            return;
        }
        for (int i = 1; i < AIConfig.maxPylonDistance + 1; ++i) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(this.getFw(), i));
            if (state.func_177230_c() instanceof BlockBlackHole) {
                this.setSingularity((ISingularity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(this.getFw(), i)));
                this.beamDrain = (float)Math.min((double)i * AIConfig.pylonDrain, 10000.0);
                this.notifyClient();
                break;
            }
            if (!(state.func_177230_c() instanceof BlockAir)) break;
        }
    }

    @Override
    public void setSingularity(ISingularity singularity) {
        this.operatedTile = singularity;
        this.notifyClient();
        if (this.operatedTile != null) {
            this.operatedTile.addListener(this);
        }
        this.postCellInventoryEvent();
    }

    @Override
    public void setDrain(boolean newValue) {
        this.shouldDrain = newValue;
        this.drainHandler.updateData(this.func_145831_w());
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> iStorageChannel) {
        if (!this.activeHandlersLoaded) {
            this.initHandlers();
            return new ArrayList<IMEInventoryHandler>();
        }
        if (!this.hasSingularity() || !this.getGridNode().isActive()) {
            return new ArrayList<IMEInventoryHandler>();
        }
        if (this.operatedTile instanceof TileBlackHole) {
            return Collections.singletonList(this.activeBlackHoleHandlers.get(iStorageChannel));
        }
        return Collections.singletonList(this.activeWhiteHoleHandlers.get(iStorageChannel));
    }

    public void initHandlers() {
        if (this.activeHandlersLoaded) {
            return;
        }
        if (!this.hasSingularity()) {
            return;
        }
        AIApi.instance().addHandlersForMEPylon(BlackHoleItemHandler.class, WhiteHoleItemHandler.class, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
        AIApi.instance().addHandlersForMEPylon(BlackHoleFluidHandler.class, WhiteHoleFluidHandler.class, AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
        AIApi.instance().addHandlersForMEPylon(BlackHoleEnergyHandler.class, WhiteHoleEnergyHandler.class, AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class));
        if (Loader.isModLoaded((String)"botania") && AIConfig.enableManaFeatures) {
            AIApi.instance().addHandlersForMEPylon(BlackHoleManaHandler.class, WhiteHoleManaHandler.class, AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class));
        }
        this.activeWhiteHoleHandlers = new LinkedHashMap();
        this.activeBlackHoleHandlers = new LinkedHashMap();
        for (IStorageChannel chan : AEApi.instance().storage().storageChannels()) {
            try {
                WhiteHoleSingularityInventoryHandler<?> invWhiteHole = passiveWhiteHoleHandlers.get(chan).newInstance();
                BlackHoleSingularityInventoryHandler<?> invBlackHole = passiveBlackHoleHandlers.get(chan).newInstance();
                invWhiteHole.setSingularity(this.operatedTile);
                invBlackHole.setSingularity(this.operatedTile);
                this.activeBlackHoleHandlers.put(chan, invBlackHole);
                this.activeWhiteHoleHandlers.put(chan, invWhiteHole);
            }
            catch (Exception e) {
                AILog.info(e.getMessage(), new Object[0]);
            }
        }
        this.activeHandlersLoaded = true;
    }

    public boolean hasSingularity() {
        return this.operatedTile != null;
    }

    public boolean activate(EnumHand hand, EntityPlayer p) {
        return false;
    }

    public float getBeamState() {
        return this.beamDrain;
    }

    public boolean drainsEnergy() {
        return this.shouldDrain;
    }

    private EnumFacing getFw() {
        return ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMEPylon.FACING)).func_176746_e();
    }
}

