/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.LogicBus;

import AppliedIntegrations.Utils.MultiBlockUtils;
import AppliedIntegrations.api.Multiblocks.BlockType;
import AppliedIntegrations.tile.AITile;
import AppliedIntegrations.tile.IAIMultiBlock;
import AppliedIntegrations.tile.IMaster;
import AppliedIntegrations.tile.LogicBus.TileLogicBusPort;
import AppliedIntegrations.tile.LogicBus.TileLogicBusRib;
import AppliedIntegrations.tile.LogicBus.TileLogicBusSlave;
import AppliedIntegrations.tile.Patterns.AIPatterns;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;

public class TileLogicBusCore
extends AITile
implements IMaster,
IAIMultiBlock {
    private boolean isFormed = false;
    private TileLogicBusPort mainNetworkPort;
    private Vector<TileLogicBusPort> subNetworkPorts = new Vector();
    private Vector<TileLogicBusSlave> slaves = new Vector();

    public TileLogicBusCore() {
        this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.isFormed && Platform.isServer()) {
            this.destroyMultiBlock();
        }
    }

    public void destroyMultiBlock() {
        for (TileLogicBusSlave slave : this.slaves) {
            slave.setMaster(null);
            slave.notifyBlock();
            slave.destroyProxyNode();
            slave.getGridNode().updateState();
            this.slaves.remove(slave);
        }
        for (TileLogicBusPort port : this.subNetworkPorts) {
            port.isSubPort = false;
        }
        this.subNetworkPorts = new Vector();
        this.mainNetworkPort = null;
    }

    @Override
    @Nonnull
    public IGridNode getActionableNode() {
        return this.getProxy().getNode();
    }

    @Override
    public void func_73660_a() {
        IMEInventory<IAEItemStack> inventory;
        super.func_73660_a();
        if (this.slaves.size() > 0 && (inventory = this.getOuterGridInventory()) != null) {
            inventory.injectItems(((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)new ItemStack(Items.field_151137_ax)), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
        }
    }

    private IMEInventory<IAEItemStack> getOuterGridInventory() {
        for (TileLogicBusSlave slave : this.slaves) {
            if (!(slave instanceof TileLogicBusRib)) continue;
            return ((TileLogicBusRib)slave).getOuterGridInventory();
        }
        return null;
    }

    @Override
    public void notifyBlock() {
    }

    @Override
    public void tryConstruct(EntityPlayer p) {
        if (!this.isFormed() && Platform.isServer()) {
            Vector slaveCandidates = new Vector();
            Vector corners = new Vector();
            AtomicInteger count = new AtomicInteger();
            MultiBlockUtils.fillListWithPattern(AIPatterns.ME_LOGIC_BUS.getPatternData(), this, data -> {
                count.getAndIncrement();
                slaveCandidates.add((TileLogicBusSlave)this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)data.getPos())));
                if (data.type == BlockType.Corner) {
                    corners.add((TileLogicBusRib)this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)data.getPos())));
                }
            });
            if (count.get() == AIPatterns.ME_LOGIC_BUS.getPatternData().size()) {
                int ribCounter = 0;
                int portCounter = 0;
                TileLogicBusPort mainNetworkCandidatePort = null;
                Vector<TileLogicBusPort> subNetworkPortsCandidates = new Vector<TileLogicBusPort>();
                boolean lineFormed = false;
                for (EnumFacing side : EnumFacing.field_176754_o) {
                    TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
                    if (tile instanceof TileLogicBusPort) {
                        ++portCounter;
                        TileEntity edgeTileRight = this.field_145850_b.func_175625_s(tile.func_174877_v().func_177972_a(side.func_176746_e()));
                        TileEntity edgeTileLeft = this.field_145850_b.func_175625_s(tile.func_174877_v().func_177972_a(side.func_176746_e().func_176734_d()));
                        if (!lineFormed && edgeTileRight instanceof TileLogicBusPort && edgeTileLeft instanceof TileLogicBusPort) {
                            subNetworkPortsCandidates.add((TileLogicBusPort)tile);
                            subNetworkPortsCandidates.add((TileLogicBusPort)edgeTileRight);
                            subNetworkPortsCandidates.add((TileLogicBusPort)edgeTileLeft);
                            lineFormed = true;
                            slaveCandidates.addAll(subNetworkPortsCandidates);
                            portCounter += 2;
                            EnumFacing opposite = side.func_176734_d();
                            TileEntity mayBeRibA = this.field_145850_b.func_175625_s(edgeTileRight.func_174877_v().func_177972_a(opposite).func_177972_a(opposite));
                            TileEntity mayBeRibB = this.field_145850_b.func_175625_s(edgeTileLeft.func_174877_v().func_177972_a(opposite).func_177972_a(opposite));
                            if (!(mayBeRibA instanceof TileLogicBusRib) || !(mayBeRibB instanceof TileLogicBusRib)) continue;
                            ribCounter += 2;
                            slaveCandidates.add((TileLogicBusRib)mayBeRibA);
                            slaveCandidates.add((TileLogicBusRib)mayBeRibB);
                            continue;
                        }
                        mainNetworkCandidatePort = (TileLogicBusPort)tile;
                        slaveCandidates.add(mainNetworkCandidatePort);
                        continue;
                    }
                    if (!(tile instanceof TileLogicBusRib)) continue;
                    ++ribCounter;
                    slaveCandidates.add((TileLogicBusRib)tile);
                }
                if (ribCounter == 4 && ribCounter == portCounter && mainNetworkCandidatePort != null) {
                    this.subNetworkPorts = subNetworkPortsCandidates;
                    this.mainNetworkPort = mainNetworkCandidatePort;
                    for (TileLogicBusRib corner : corners) {
                        corner.isCorner = true;
                    }
                    for (TileLogicBusSlave slave : slaveCandidates) {
                        slave.setMaster(this);
                        slave.notifyBlock();
                        slave.createProxyNode();
                        this.slaves.add(slave);
                        slave.func_70296_d();
                    }
                    for (TileLogicBusPort port : this.subNetworkPorts) {
                        port.isSubPort = true;
                    }
                    this.isFormed = true;
                }
            }
        }
    }

    public boolean isFormed() {
        return this.isFormed;
    }

    @Override
    public boolean hasMaster() {
        return true;
    }

    @Override
    public IMaster getMaster() {
        return this;
    }

    @Override
    public void setMaster(IMaster tileServerCore) {
    }

    @Override
    public Iterator<IGridNode> getMultiblockNodes() {
        if (this.slaves.size() > 0) {
            ArrayList<IGridNode> list = new ArrayList<IGridNode>();
            for (TileLogicBusSlave slave : this.slaves) {
                IGridNode node = slave.getGridNode();
                list.add(node);
            }
            list.add(this.getGridNode());
            return list.iterator();
        }
        ArrayList<IGridNode> list = new ArrayList<IGridNode>();
        list.add(this.getGridNode());
        return list.iterator();
    }
}

