/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.MultiController;

import AppliedIntegrations.tile.MultiController.AIMultiControllerTile;
import AppliedIntegrations.tile.MultiController.TileMultiControllerCore;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.util.EnumFacing;

public class TileMultiControllerPort
extends AIMultiControllerTile
implements ICellContainer,
ICraftingProvider {
    private AEPartLocation side = AEPartLocation.INTERNAL;
    private int portID = -1;

    public void setSideVector(AEPartLocation side) {
        this.side = side;
        this.getProxy().setValidSides(this.getValidSides());
        this.getProxy().getNode().updateState();
    }

    public AEPartLocation getSideVector() {
        return this.side;
    }

    public int getPortID() {
        return this.portID;
    }

    public void setPortID(int portID) {
        this.portID = portID;
    }

    public IGrid requestNetwork() throws GridAccessException {
        return this.getProxy().getGrid();
    }

    @Override
    protected EnumSet<EnumFacing> getValidSides() {
        if (this.hasMaster() && this.getSideVector() != AEPartLocation.INTERNAL) {
            return EnumSet.of(this.getSideVector().getFacing());
        }
        return EnumSet.noneOf(EnumFacing.class);
    }

    public void onNeighborChange() throws GridAccessException {
        if (this.hasMaster()) {
            TileMultiControllerCore core = (TileMultiControllerCore)this.getMaster();
            core.postNetworkCellEvents();
        }
    }

    public void blinkCell(int slot) {
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        if (this.getMaster() == null) {
            return new ArrayList<IMEInventoryHandler>();
        }
        return ((TileMultiControllerCore)this.getMaster()).getPortCellArray(this.side, this.portID, channel);
    }

    public int getPriority() {
        return 0;
    }

    public void saveChanges(@Nullable ICellInventory<?> cellInventory) {
        if (this.getMaster() == null) {
            return;
        }
        ((TileMultiControllerCore)this.getMaster()).savePortChanges(cellInventory, this.side, this.portID);
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.getMaster() == null) {
            return;
        }
        ((TileMultiControllerCore)this.getMaster()).providePortCrafting(craftingTracker, this.side, this.portID);
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.getMaster() == null) {
            return false;
        }
        return ((TileMultiControllerCore)this.getMaster()).pushPortPattern(patternDetails, table, this.side, this.portID);
    }

    public boolean isBusy() {
        if (this.getMaster() == null) {
            return false;
        }
        return ((TileMultiControllerCore)this.getMaster()).isPortBusy(this.side, this.portID);
    }
}

