/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.MultiController.helpers.Matter;

import AppliedIntegrations.tile.MultiController.MultiControllerPortHandler;
import AppliedIntegrations.tile.MultiController.TileMultiControllerCore;
import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public abstract class FilteredMultiControllerPortHandler<T extends IAEStack<T>>
extends MultiControllerPortHandler<T>
implements IMEInventoryHandler<T> {
    public FilteredMultiControllerPortHandler(LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, List<IAEStack<? extends IAEStack>>>> filteredMatter, LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IncludeExclude>> filterMode, TileMultiControllerCore host) {
        super(filteredMatter, filterMode, host);
    }

    public T injectItems(T input, Actionable type, IActionSource src) {
        if (!this.canAccept(input)) {
            return input;
        }
        if (this.getOuterInventory() == null) {
            return input;
        }
        if (!this.getChannel().equals(this.getOuterInventory().getChannel())) {
            return input;
        }
        return (T)this.getOuterInventory().injectItems(input, type, src);
    }

    private IMEInventory<T> getOuterInventory() {
        return this.host.getMainNetworkInventory(this.getChannel());
    }

    public T extractItems(T request, Actionable mode, IActionSource src) {
        if (!this.canExtract(request)) {
            return null;
        }
        if (this.getOuterInventory() == null) {
            return null;
        }
        if (!this.getChannel().equals(this.getOuterInventory().getChannel())) {
            return null;
        }
        return (T)this.getOuterInventory().extractItems(request, mode, src);
    }

    private boolean canExtract(T input) {
        return this.canInteract(input, SecurityPermissions.EXTRACT);
    }

    public IItemList<T> getAvailableItems(IItemList<T> out) {
        if (this.getAccess() == AccessRestriction.READ || this.getAccess() == AccessRestriction.READ_WRITE) {
            return out;
        }
        if (this.getOuterInventory() == null) {
            return out;
        }
        if (!this.getChannel().equals(this.getOuterInventory().getChannel())) {
            return out;
        }
        this.getOuterInventory().getAvailableItems(this.getChannel().createList()).forEach(stack -> {
            if (this.canAccept(stack) || this.canExtract(stack)) {
                out.add(stack);
            }
        });
        return out;
    }

    public AccessRestriction getAccess() {
        AtomicReference<AccessRestriction> rule = new AtomicReference<AccessRestriction>();
        rule.set(AccessRestriction.NO_ACCESS);
        this.forStackInList((stack, permissions) -> {
            if (stack != null && stack.getStackSize() == 0L) {
                if (permissions == SecurityPermissions.INJECT) {
                    if (rule.get() == AccessRestriction.NO_ACCESS) {
                        rule.set(AccessRestriction.WRITE);
                    } else if (rule.get() == AccessRestriction.READ) {
                        rule.set(AccessRestriction.READ_WRITE);
                    }
                } else if (permissions == SecurityPermissions.EXTRACT) {
                    if (rule.get() == AccessRestriction.NO_ACCESS) {
                        rule.set(AccessRestriction.READ);
                    } else if (rule.get() == AccessRestriction.WRITE) {
                        rule.set(AccessRestriction.READ_WRITE);
                    }
                }
            }
        });
        return (AccessRestriction)rule.get();
    }

    protected void forStackInList(BiConsumer<IAEStack<? extends IAEStack>, SecurityPermissions> consumer) {
        for (SecurityPermissions securityPermissions : new SecurityPermissions[]{SecurityPermissions.INJECT, SecurityPermissions.EXTRACT}) {
            AEApi.instance().storage().storageChannels().forEach(channel -> {
                if (this.filteredMatter.get(securityPermissions) != null && ((LinkedHashMap)this.filteredMatter.get(securityPermissions)).get(channel) != null) {
                    ((List)((LinkedHashMap)this.filteredMatter.get(securityPermissions)).get(channel)).forEach(iaeStack -> consumer.accept((IAEStack<? extends IAEStack>)iaeStack, securityPermissions));
                }
            });
        }
    }

    public boolean isPrioritized(T input) {
        return false;
    }

    public boolean canAccept(T input) {
        return this.canInteract(input, SecurityPermissions.INJECT);
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }
}

