/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.api.item;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.util.IConfigManager;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import baubles.api.BaubleType;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTBaublesAccess;
import p455w0rd.ae2wtlib.api.WTNetworkHandler;
import p455w0rd.ae2wtlib.api.client.IBaubleRender;
import p455w0rd.ae2wtlib.api.client.ItemStackSizeRenderer;
import p455w0rd.ae2wtlib.api.client.render.WTItemRenderer;
import p455w0rd.ae2wtlib.client.render.RenderLayerWT;
import p455w0rd.ae2wtlib.init.LibConfig;
import p455w0rd.ae2wtlib.init.LibCreativeTab;
import p455w0rdslib.api.client.ICustomItemRenderer;
import p455w0rdslib.api.client.ItemLayerWrapper;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles|API", striprefs=true)})
public abstract class ItemWT
extends AEBasePoweredItem
implements ICustomWirelessTerminalItem {
    private EntityPlayer holder;
    @SideOnly(value=Side.CLIENT)
    ItemLayerWrapper wrappedModel;
    static final Set<String> validEnchantNames = Sets.newHashSet((Object[])new String[]{"soulbound", "soul_bound"});

    protected ItemWT(ResourceLocation registryName) {
        super((double)LibConfig.WT_MAX_POWER);
        this.setRegistryName(registryName);
        this.func_77655_b(registryName.toString());
        this.func_77625_d(1);
        this.func_77637_a(LibCreativeTab.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack is, World world, List<String> list, ITooltipFlag advancedTooltips) {
        if (this.hasValidGuiObject(is)) {
            this.addTooltipSeparator(list);
            this.addTooltipEnergyInfo(is, list);
            this.addTooltipLinkInfo(is, list);
            this.addTooltipInfinityInfo(is, list);
        }
    }

    public void getCheckedSubItems(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        if (!this.isCreative()) {
            ItemStack emptyStack = new ItemStack((Item)this);
            ItemStack fullStack = new ItemStack((Item)this);
            ((AEBasePoweredItem)fullStack.func_77973_b()).injectAEPower(fullStack, (double)LibConfig.WT_MAX_POWER, Actionable.MODULATE);
            WTApi.instance().setInfinityEnergy(emptyStack, 0);
            WTApi.instance().setInfinityEnergy(fullStack, Integer.MAX_VALUE);
            stacks.addAll((Collection)Lists.newArrayList((Object[])new ItemStack[]{emptyStack, fullStack}));
        } else {
            stacks.add((Object)new ItemStack((Item)this));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (world.field_72995_K && hand == EnumHand.MAIN_HAND && !item.func_190926_b() && this.getAECurrentPower(item) > 0.0) {
            this.openGui(player, false, player.field_71071_by.field_70461_c);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
        }
        if (!world.field_72995_K) {
            if (this.getAECurrentPower(item) <= 0.0) {
                player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
                return new ActionResult(EnumActionResult.FAIL, (Object)item);
            }
            if (!WTApi.instance().isTerminalLinked(item)) {
                player.func_145747_a(PlayerMessages.DeviceNotLinked.get());
                return new ActionResult(EnumActionResult.FAIL, (Object)item);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.holder;
    }

    @Override
    public void setPlayer(EntityPlayer player) {
        this.holder = player;
    }

    @Override
    public int getColor() {
        return -7399980;
    }

    protected int getSlotFor(InventoryPlayer inv, ItemStack stack) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || !this.stackEqualExact(stack, inv.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    @SideOnly(value=Side.CLIENT)
    protected void addTooltipInfinityInfo(ItemStack wirelessTerminal, List<String> tooltip) {
        if (WTApi.instance().getConfig().isInfinityBoosterCardEnabled()) {
            if (WTApi.instance().getConfig().isOldInfinityMechanicEnabled()) {
                tooltip.add(I18n.func_135052_a((String)"item.ae2wtlib:infinity_booster_card.name", (Object[])new Object[0]) + ": " + (this.hasInfiniteRange(wirelessTerminal) ? TextFormatting.GREEN + "" : TextFormatting.RED + "" + I18n.func_135052_a((String)"tooltip.not.desc", (Object[])new Object[0])) + " " + I18n.func_135052_a((String)"tooltip.installed.desc", (Object[])new Object[0]));
            } else {
                boolean outsideOfWAPRange;
                int infinityEnergyAmount = WTApi.instance().getInfinityEnergy(wirelessTerminal);
                String amountColor = infinityEnergyAmount < WTApi.instance().getConfig().getLowInfinityEnergyWarningAmount() ? TextFormatting.RED.toString() : TextFormatting.GREEN.toString();
                String reasonString = "";
                boolean bl = outsideOfWAPRange = !WTApi.instance().isInRange(wirelessTerminal);
                if (!outsideOfWAPRange && GuiScreen.func_146272_n()) {
                    reasonString = I18n.func_135052_a((String)"tooltip.in_wap_range.desc", (Object[])new Object[0]);
                } else if (infinityEnergyAmount <= 0 && GuiScreen.func_146272_n()) {
                    reasonString = "(" + I18n.func_135052_a((String)"tooltip.out_of.desc", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"tooltip.infinity_energy.desc", (Object[])new Object[0]) + ")";
                }
                String activeString = infinityEnergyAmount > 0 && outsideOfWAPRange ? TextFormatting.GREEN + "" + I18n.func_135052_a((String)"tooltip.active.desc", (Object[])new Object[0]) : TextFormatting.GRAY + "" + I18n.func_135052_a((String)"tooltip.inactive.desc", (Object[])new Object[0]) + " " + reasonString;
                tooltip.add(I18n.func_135052_a((String)"tooltip.infinite_range.desc", (Object[])new Object[0]) + ": " + activeString);
                String infinityEnergyString = WTApi.instance().isWTCreative(wirelessTerminal) ? I18n.func_135052_a((String)"tooltip.infinite.desc", (Object[])new Object[0]) : (ItemWT.isShiftKeyDown() ? "" + infinityEnergyAmount + "" + TextFormatting.GRAY + " " + I18n.func_135052_a((String)"tooltip.units.desc", (Object[])new Object[0]) : ItemStackSizeRenderer.getInstance().getConverter().toSlimReadableForm(infinityEnergyAmount));
                tooltip.add(I18n.func_135052_a((String)"tooltip.infinity_energy.desc", (Object[])new Object[0]) + ": " + amountColor + "" + infinityEnergyString);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void addTooltipEnergyInfo(ItemStack wirelessTerminal, List<String> tooltip) {
        String pctTxtColor = TextFormatting.WHITE + "";
        double aeCurrPower = this.getAECurrentPower(wirelessTerminal);
        double aeCurrPowerPct = (double)((int)Math.floor(aeCurrPower / this.getAEMaxPower(wirelessTerminal) * 10000.0)) / 100.0;
        if ((int)aeCurrPowerPct >= 75) {
            pctTxtColor = TextFormatting.GREEN + "";
        }
        if ((int)aeCurrPowerPct <= 5) {
            pctTxtColor = TextFormatting.RED + "";
        }
        if (WTApi.instance().isWTCreative(wirelessTerminal)) {
            tooltip.add(GuiText.StoredEnergy.getLocal() + ": " + TextFormatting.GREEN + "" + I18n.func_135052_a((String)"tooltip.infinite.desc", (Object[])new Object[0]));
        } else {
            tooltip.add(GuiText.StoredEnergy.getLocal() + ": " + pctTxtColor + (int)aeCurrPower + " AE - " + aeCurrPowerPct + "%");
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void addTooltipLinkInfo(ItemStack wirelessTerminal, List<String> tooltip) {
        String encKey = this.getEncryptionKey(wirelessTerminal);
        String linked = TextFormatting.RED + GuiText.Unlinked.getLocal();
        if (encKey != null && !encKey.isEmpty()) {
            linked = TextFormatting.BLUE + GuiText.Linked.getLocal();
        }
        tooltip.add(I18n.func_135052_a((String)"tooltip.link_status", (Object[])new Object[0]) + ": " + linked);
    }

    @SideOnly(value=Side.CLIENT)
    protected void addTooltipSeparator(List<String> tooltip) {
        tooltip.add(TextFormatting.AQUA + "==============================");
    }

    protected boolean hasValidGuiObject(ItemStack wirelessTerminal) {
        return this.getPlayer() != null && WTApi.instance().getGUIObject(wirelessTerminal, this.getPlayer()) != null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        bookEnchants = EnchantmentHelper.func_82781_a((ItemStack)book);
        itemEnchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (bookEnchants.size() != 1) ** GOTO lbl-1000
        if (bookEnchants.keySet().stream().map((Function<Enchantment, ResourceLocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRegistryName(), (Lnet/minecraft/enchantment/Enchantment;)Lnet/minecraft/util/ResourceLocation;)()).map((Function<ResourceLocation, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, func_110623_a(), (Lnet/minecraft/util/ResourceLocation;)Ljava/lang/String;)()).allMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(ItemWT.validEnchantNames))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = isBookValid = false;
        }
        if (itemEnchants.size() == 0) ** GOTO lbl-1000
        if (!itemEnchants.keySet().stream().map((Function<Enchantment, ResourceLocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRegistryName(), (Lnet/minecraft/enchantment/Enchantment;)Lnet/minecraft/util/ResourceLocation;)()).map((Function<ResourceLocation, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, func_110623_a(), (Lnet/minecraft/util/ResourceLocation;)Ljava/lang/String;)()).allMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(ItemWT.validEnchantNames))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        isItemValid = v1;
        return isBookValid != false && isItemValid != false;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack is) {
        double aeCurrPower = this.getAECurrentPower(is);
        double aeMaxPower = this.getAEMaxPower(is);
        double tenPct = aeMaxPower * 0.1;
        if (aeCurrPower != 0.0 && (double)((int)aeCurrPower) >= (double)((int)aeMaxPower) - tenPct) {
            return false;
        }
        return !WTApi.instance().isWTCreative(is);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)this.getModelResource((Item)this));
    }

    @SideOnly(value=Side.CLIENT)
    public ItemLayerWrapper getWrappedModel() {
        return this.wrappedModel;
    }

    @SideOnly(value=Side.CLIENT)
    public void setWrappedModel(ItemLayerWrapper wrappedModel) {
        this.wrappedModel = wrappedModel;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldUseInternalTEISR() {
        return true;
    }

    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount, Actionable.MODULATE) >= amount - 0.5;
    }

    public boolean hasPower(EntityPlayer player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    public IConfigManager getConfigManager(ItemStack target) {
        return new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData((ItemStack)target);
            manager.writeToNBT(data);
        });
    }

    public String getEncryptionKey(ItemStack item) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)item);
        return tag.func_74779_i(WTApi.instance().getConstants().getNBTTagNames().encryptionKey());
    }

    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)item);
        tag.func_74778_a(WTApi.instance().getConstants().getNBTTagNames().encryptionKey(), encKey);
        tag.func_74778_a("name", name);
    }

    public boolean canHandle(ItemStack is) {
        return is.func_77973_b() == this;
    }

    private double injectPower(PowerUnits inputUnit, ItemStack is, double amount, boolean simulate) {
        if (simulate) {
            int requiredExt = (int)PowerUnits.AE.convertTo(inputUnit, this.getAEMaxPower(is) - this.getAECurrentPower(is));
            if (amount < (double)requiredExt) {
                return 0.0;
            }
            return amount - (double)requiredExt;
        }
        double powerRemainder = this.injectAEPower(is, inputUnit.convertTo(PowerUnits.AE, amount), simulate ? Actionable.SIMULATE : Actionable.MODULATE);
        return PowerUnits.AE.convertTo(inputUnit, powerRemainder);
    }

    public double injectAEPower(ItemStack is, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(is);
        double currentStorage = this.getAECurrentPower(is);
        double required = maxStorage - currentStorage;
        double overflow = Math.min(amount * 2.0 - required, amount - required);
        if (mode == Actionable.MODULATE) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            double toAdd = Math.min(amount * 2.0, required);
            data.func_74780_a(WTApi.instance().getConstants().getNBTTagNames().internalCurrentPower(), currentStorage + toAdd);
        }
        return Math.max(0.0, overflow);
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack is, int maxReceive, boolean simulate) {
        return maxReceive - (int)this.injectPower(PowerUnits.RF, is, maxReceive, simulate);
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack is) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(is));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack is) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(is));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack is) {
        if (WTApi.instance().isWTCreative(is)) {
            return true;
        }
        if (LibConfig.USE_OLD_INFINTY_MECHANIC) {
            return this.hasInfiniteRange(is);
        }
        return this.getAECurrentPower(is) > AEConfig.instance().getWirelessTerminalDrainMultiplier() && this.getEncryptionKey(is) != null && !this.getEncryptionKey(is).isEmpty() && (WTApi.instance().hasInfiniteRange(is) || WTApi.instance().isInRange(is));
    }

    public void func_77663_a(ItemStack wirelessTerminal, World w, Entity e, int slot, boolean isSelected) {
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)e;
        if (this.getPlayer() == null || !this.getPlayer().func_110124_au().equals(p.func_110124_au())) {
            this.setPlayer(p);
        }
        if (wirelessTerminal == null || !(wirelessTerminal.func_77973_b() instanceof ICustomWirelessTerminalItem)) {
            return;
        }
        if (p instanceof EntityPlayerMP) {
            this.rangeCheck(wirelessTerminal, (EntityPlayerMP)p, slot, false);
        }
        WTApi.instance().isBoosterInstalled(wirelessTerminal);
    }

    private void rangeCheck(ItemStack wirelessTerm, EntityPlayerMP player, int wtSlot, boolean isBauble) {
        boolean currentRangeValue;
        boolean inRange = WTApi.instance().isInRangeOfWAP(wirelessTerm, (EntityPlayer)player);
        if (inRange != (currentRangeValue = WTApi.instance().isInRange(wirelessTerm))) {
            WTApi.instance().setInRange(wirelessTerm, inRange);
            WTNetworkHandler n = WTApi.instance().getNetHandler();
            n.sendTo(n.createSetInRangePacket(inRange, isBauble, wtSlot), player);
        }
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    @Override
    public IBaubleRender getRender() {
        return RenderLayerWT.getInstance();
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return false;
    }

    public void onWornTick(ItemStack wirelessTerminal, EntityLivingBase playerIn) {
        EntityPlayerMP player;
        Pair<Boolean, Integer> p;
        if (playerIn instanceof EntityPlayerMP && (Integer)(p = this.getSlotInfo(wirelessTerminal, (EntityPlayer)(player = (EntityPlayerMP)playerIn))).getRight() >= 0) {
            this.rangeCheck(wirelessTerminal, player, (Integer)p.getRight(), (Boolean)p.getLeft());
        }
    }

    private Pair<Boolean, Integer> getSlotInfo(ItemStack wirelessTerminal, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) != wirelessTerminal) continue;
            return Pair.of((Object)false, (Object)i);
        }
        WTBaublesAccess b = WTApi.instance().getBaublesUtility();
        for (int i = 0; i < 7; ++i) {
            ItemStack s = b.getWTBySlot(player, i, ICustomWirelessTerminalItem.class);
            if (s.func_190926_b() || s != wirelessTerminal) continue;
            return Pair.of((Object)true, (Object)i);
        }
        return Pair.of((Object)false, (Object)-1);
    }

    public ICustomItemRenderer getRenderer() {
        return WTItemRenderer.getRendererForItem((Item)this);
    }
}

