/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.init;

import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.container.slot.AppEngSlot;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.ae2wtlib.AE2WTLib;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTBaublesAccess;
import p455w0rd.ae2wtlib.api.WTConfig;
import p455w0rd.ae2wtlib.api.WTGlobals;
import p455w0rd.ae2wtlib.api.WTGuiObject;
import p455w0rd.ae2wtlib.api.WTNetworkHandler;
import p455w0rd.ae2wtlib.api.WTRegistry;
import p455w0rd.ae2wtlib.api.WUTUtility;
import p455w0rd.ae2wtlib.api.client.IWTGuiScrollbar;
import p455w0rd.ae2wtlib.api.client.gui.widgets.GuiScrollbar;
import p455w0rd.ae2wtlib.api.container.ContainerWT;
import p455w0rd.ae2wtlib.api.container.slot.NullSlot;
import p455w0rd.ae2wtlib.api.container.slot.SlotArmor;
import p455w0rd.ae2wtlib.api.container.slot.SlotBooster;
import p455w0rd.ae2wtlib.api.container.slot.SlotBoosterEnergy;
import p455w0rd.ae2wtlib.api.container.slot.SlotTrash;
import p455w0rd.ae2wtlib.api.inventory.WTInventoryBooster;
import p455w0rd.ae2wtlib.helpers.IWirelessUniversalItem;
import p455w0rd.ae2wtlib.helpers.WTGuiObjectImpl;
import p455w0rd.ae2wtlib.init.LibConfig;
import p455w0rd.ae2wtlib.init.LibGlobals;
import p455w0rd.ae2wtlib.init.LibItems;
import p455w0rd.ae2wtlib.init.LibLogger;
import p455w0rd.ae2wtlib.init.LibNetworking;
import p455w0rd.ae2wtlib.init.LibWTRegistry;
import p455w0rd.ae2wtlib.integration.Baubles;
import p455w0rd.ae2wtlib.items.ItemInfinityBooster;
import p455w0rd.ae2wtlib.items.ItemWUT;
import p455w0rd.ae2wtlib.sync.packets.PacketSyncInfinityEnergy;
import p455w0rdslib.LibGlobals;

public class LibApiImpl
extends WTApi {
    private static LibApiImpl INSTANCE = null;
    private static WTConfigImpl CONFIG = null;
    private static LibWTRegistry REGISTRY = null;
    private static WTBaublesAccess BAUBLES = null;
    private static WTGlobals CONSTANTS = null;
    private static WUTUtility WUT_UTILITY = null;

    public static LibApiImpl instance() {
        if (INSTANCE == null) {
            if (!LibApiImpl.hasFinishedPreInit()) {
                return null;
            }
            INSTANCE = new LibApiImpl();
        }
        return INSTANCE;
    }

    protected static boolean hasFinishedPreInit() {
        if (AE2WTLib.PROXY.getLoaderState() == LoaderState.NOINIT) {
            LibLogger.warn("API is not available until AE2 Wireless Terminal Library (AE2WTLib) starts the PreInit phase.");
            return false;
        }
        return true;
    }

    @Override
    public WUTUtility getWUTUtility() {
        if (WUT_UTILITY == null) {
            if (!LibApiImpl.hasFinishedPreInit()) {
                return null;
            }
            WUT_UTILITY = WUTUtilityImpl.getInstance();
        }
        return WUT_UTILITY;
    }

    @Override
    public WTConfig getConfig() {
        if (CONFIG == null) {
            if (!LibApiImpl.hasFinishedPreInit()) {
                return null;
            }
            CONFIG = new WTConfigImpl();
        }
        return CONFIG;
    }

    @Override
    public WTRegistry getWirelessTerminalRegistry() {
        if (REGISTRY == null) {
            if (!LibApiImpl.hasFinishedPreInit()) {
                return null;
            }
            REGISTRY = new LibWTRegistry();
        }
        return REGISTRY;
    }

    @Override
    public WTBaublesAccess getBaublesUtility() {
        if (BAUBLES == null) {
            if (!LibApiImpl.hasFinishedPreInit()) {
                return null;
            }
            BAUBLES = new Baubles();
        }
        return BAUBLES;
    }

    @Override
    public WTNetworkHandler getNetHandler() {
        return LibNetworking.instance();
    }

    @Override
    public WTGlobals getConstants() {
        if (CONSTANTS == null) {
            if (!LibApiImpl.hasFinishedPreInit()) {
                return null;
            }
            CONSTANTS = new LibGlobals();
        }
        return CONSTANTS;
    }

    @Override
    public ItemInfinityBooster getBoosterCard() {
        return LibItems.BOOSTER_CARD;
    }

    @Override
    public Set<Pair<Integer, ItemStack>> getWirelessTerminals(EntityPlayer player) {
        return this.getWirelessTerminals(player, false);
    }

    @Override
    public Set<Pair<Integer, ItemStack>> getWirelessTerminals(EntityPlayer player, boolean isBauble) {
        Set<Pair<Integer, ItemStack>> wtBaubles;
        if (isBauble) {
            return this.getBaublesUtility().getAllWTBaubles(player);
        }
        HashSet terminalList = Sets.newHashSet();
        NonNullList playerInventory = player.field_71071_by.field_70462_a;
        for (int i = 0; i < playerInventory.size(); ++i) {
            ItemStack wirelessTerm = (ItemStack)playerInventory.get(i);
            if (!this.isAnyWT(wirelessTerm)) continue;
            terminalList.add(Pair.of((Object)i, (Object)wirelessTerm));
        }
        if (LibGlobals.Mods.BAUBLES.isLoaded() && !(wtBaubles = this.getBaublesUtility().getAllWTBaubles(player)).isEmpty()) {
            terminalList.addAll(wtBaubles);
        }
        return terminalList;
    }

    @Override
    public Set<Pair<Boolean, Pair<Integer, ItemStack>>> getAllWirelessTerminals(EntityPlayer player) {
        Set<Pair<Integer, ItemStack>> wctBaubles;
        HashSet terminalList = Sets.newHashSet();
        NonNullList playerInventory = player.field_71071_by.field_70462_a;
        for (int i = 0; i < playerInventory.size(); ++i) {
            ItemStack wirelessTerm = (ItemStack)playerInventory.get(i);
            if (!this.isAnyWT(wirelessTerm)) continue;
            terminalList.add(Pair.of((Object)false, (Object)Pair.of((Object)i, (Object)wirelessTerm)));
        }
        if (LibGlobals.Mods.BAUBLES.isLoaded() && !(wctBaubles = this.getBaublesUtility().getAllWTBaubles(player)).isEmpty()) {
            for (Pair<Integer, ItemStack> currentPair : wctBaubles) {
                ItemStack wctBauble = (ItemStack)currentPair.getRight();
                if (!this.isAnyWT(wctBauble)) continue;
                terminalList.add(Pair.of((Object)true, (Object)Pair.of((Object)currentPair.getLeft(), (Object)wctBauble)));
            }
        }
        return terminalList;
    }

    @Override
    public Set<Pair<Boolean, Pair<Integer, ItemStack>>> getAllWirelessTerminalsByType(EntityPlayer player, Class<? extends ICustomWirelessTerminalItem> type) {
        HashSet typeTerminals = Sets.newHashSet();
        Set<Pair<Boolean, Pair<Integer, ItemStack>>> terminals = this.getAllWirelessTerminals(player);
        for (Pair<Boolean, Pair<Integer, ItemStack>> terminal : terminals) {
            ItemStack currentTerminalStack = (ItemStack)((Pair)terminal.getRight()).getRight();
            Class<?> clazz = currentTerminalStack.func_77973_b().getClass();
            HashSet applicableInterfaces = Sets.newHashSet((Iterable)ClassUtils.getAllInterfaces(clazz));
            if ((currentTerminalStack.func_190926_b() || !applicableInterfaces.contains(type)) && !this.getWUTUtility().doesWUTSupportType(currentTerminalStack, type)) continue;
            typeTerminals.add(terminal);
        }
        return typeTerminals;
    }

    @Override
    public boolean containsCreativeTerminal(ICustomWirelessTerminalItem ... wirelessTerminals) {
        for (ICustomWirelessTerminalItem terminal : wirelessTerminals) {
            if (!terminal.isCreative()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getWTBySlot(EntityPlayer player, int slot, Class<? extends ICustomWirelessTerminalItem> type) {
        return this.getWTBySlot(player, false, slot, type);
    }

    @Override
    public ItemStack getWTBySlot(EntityPlayer player, boolean isBauble, int slot, Class<? extends ICustomWirelessTerminalItem> type) {
        if (isBauble) {
            return this.getBaublesUtility().getWTBySlot(player, slot, type);
        }
        ItemStack wirelessTerminal = player.field_71071_by.func_70301_a(slot);
        if (!wirelessTerminal.func_190926_b()) {
            List applicableInterfaces = ClassUtils.getAllInterfaces(wirelessTerminal.func_77973_b().getClass());
            if (this.getWUTUtility().isWUT(wirelessTerminal)) {
                for (Pair<ICustomWirelessTerminalItem, Integer> currentPair : this.getWUTUtility().getStoredTerminalHandlers(wirelessTerminal)) {
                    List storedInterfaces = ClassUtils.getAllInterfaces(((ICustomWirelessTerminalItem)currentPair.getLeft()).getClass());
                    for (Class currentInterface : storedInterfaces) {
                        if (applicableInterfaces.contains(currentInterface)) continue;
                        applicableInterfaces.add(currentInterface);
                    }
                }
            }
            if (!wirelessTerminal.func_190926_b() && (applicableInterfaces.contains(type) || this.getWUTUtility().doesWUTSupportType(wirelessTerminal, type))) {
                return wirelessTerminal;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getWTBySlot(EntityPlayer player, int slot) {
        return this.getWTBySlot(player, false, slot);
    }

    @Override
    public ItemStack getWTBySlot(EntityPlayer player, boolean isBauble, int slot) {
        if (isBauble) {
            return this.getBaublesUtility().getWTBySlot(player, slot, ICustomWirelessTerminalItem.class);
        }
        ItemStack wirelessTerminal = player.field_71071_by.func_70301_a(slot);
        if (!wirelessTerminal.func_190926_b() && wirelessTerminal.func_77973_b() instanceof ICustomWirelessTerminalItem) {
            return wirelessTerminal;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getFirstWirelessTerminal(EntityPlayer player) {
        Set<Pair<Integer, ItemStack>> wirelessTerms = this.getWirelessTerminals(player);
        if (!wirelessTerms.isEmpty()) {
            return (ItemStack)((Pair)wirelessTerms.stream().findFirst().get()).getRight();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean shouldConsumeBoosters(ItemStack wirelessTerminal) {
        if (!LibConfig.USE_OLD_INFINTY_MECHANIC && wirelessTerminal.func_77942_o() && wirelessTerminal.func_77978_p().func_74764_b(WTApi.instance().getConstants().getNBTTagNames().autoConsumeBooster())) {
            boolean shouldConsume = wirelessTerminal.func_77978_p().func_74767_n(WTApi.instance().getConstants().getNBTTagNames().autoConsumeBooster());
            int currentCardCount = this.getInfinityEnergy(wirelessTerminal) / LibConfig.INFINITY_ENERGY_PER_BOOSTER_CARD;
            int maxCardCount = Integer.MAX_VALUE / LibConfig.INFINITY_ENERGY_PER_BOOSTER_CARD;
            return shouldConsume && maxCardCount > currentCardCount;
        }
        return false;
    }

    @Override
    public boolean isBoosterInstalled(ItemStack wirelessTerminal) {
        ItemStack boosterCard;
        NBTTagCompound boosterTagCompound;
        NBTTagList boosterNBTList;
        NBTTagCompound boosterNBT;
        if (wirelessTerminal.func_77942_o() && (boosterNBT = wirelessTerminal.func_179543_a(WTApi.instance().getConstants().getNBTTagNames().boosterSlot())) != null && (boosterNBTList = boosterNBT.func_150295_c("Items", 10)) != null && (boosterTagCompound = boosterNBTList.func_150305_b(0)) != null && (boosterCard = new ItemStack(boosterTagCompound)) != null && !boosterCard.func_190926_b()) {
            return boosterCard.func_77973_b() instanceof ItemInfinityBooster && LibConfig.WT_BOOSTER_ENABLED;
        }
        return false;
    }

    @Override
    public void setInRange(ItemStack wirelessTerm, boolean value) {
        NBTTagCompound nbt = this.ensureTag(wirelessTerm);
        nbt.func_74757_a(WTApi.instance().getConstants().getNBTTagNames().inRange(), value);
        wirelessTerm.func_77982_d(nbt);
    }

    @Override
    public boolean isInRange(ItemStack wirelessTerm) {
        NBTTagCompound nbt = this.ensureTag(wirelessTerm);
        return nbt.func_74764_b(WTApi.instance().getConstants().getNBTTagNames().inRange()) && nbt.func_74767_n(WTApi.instance().getConstants().getNBTTagNames().inRange()) || this.isWTCreative(wirelessTerm);
    }

    @Override
    public ItemStack addInfinityBoosters(@Nonnull ItemStack wirelessTerm, ItemStack boosterCardStack) {
        int maxCardCount;
        int currentCardCount = this.getInfinityEnergy(wirelessTerm) / LibConfig.INFINITY_ENERGY_PER_BOOSTER_CARD;
        if (currentCardCount < (maxCardCount = Integer.MAX_VALUE / LibConfig.INFINITY_ENERGY_PER_BOOSTER_CARD)) {
            int cardsTryingToAdd;
            int spaceAvailable = maxCardCount - currentCardCount;
            int numberOfCardsTryingToAdd = boosterCardStack.func_190916_E();
            if (spaceAvailable > 0 && numberOfCardsTryingToAdd > 0 && (cardsTryingToAdd = numberOfCardsTryingToAdd) <= spaceAvailable) {
                this.setInfinityEnergy(wirelessTerm, cardsTryingToAdd * LibConfig.INFINITY_ENERGY_PER_BOOSTER_CARD + this.getInfinityEnergy(wirelessTerm));
                if (cardsTryingToAdd == spaceAvailable) {
                    boosterCardStack = ItemStack.field_190927_a;
                } else {
                    boosterCardStack.func_190920_e(cardsTryingToAdd - spaceAvailable);
                }
            }
        }
        return boosterCardStack;
    }

    @Override
    public boolean hasInfiniteRange(@Nonnull ItemStack wirelessTerm) {
        if (LibConfig.USE_OLD_INFINTY_MECHANIC) {
            return this.isBoosterInstalled(wirelessTerm) || this.isWTCreative(wirelessTerm);
        }
        return this.hasInfinityEnergy(wirelessTerm);
    }

    @Override
    public boolean hasInfinityEnergy(@Nonnull ItemStack wirelessTerm) {
        if (this.ensureTag(wirelessTerm).func_74764_b(WTApi.instance().getConstants().getNBTTagNames().infinityEnergy())) {
            return this.getInfinityEnergy(wirelessTerm) > 0 && LibConfig.WT_BOOSTER_ENABLED;
        }
        return this.isWTCreative(wirelessTerm);
    }

    @Override
    public boolean isAnyWT(@Nonnull ItemStack wirelessTerm) {
        return wirelessTerm.func_77973_b() instanceof ICustomWirelessTerminalItem;
    }

    @Override
    public boolean isInRangeOfWAP(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        return this.getDistanceToWAP(wirelessTerm, player) <= this.getWAPRange(wirelessTerm, player) && this.getWAPRange(wirelessTerm, player) != Double.MAX_VALUE;
    }

    @Override
    public double getDistanceToWAP(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        IWirelessAccessPoint wap = this.getClosestWAPToPlayer(wirelessTerm, player);
        if (wap != null && player.func_130014_f_().field_73011_w.getDimension() == wap.getLocation().getWorld().field_73011_w.getDimension()) {
            BlockPos wapPos = wap.getLocation().getPos();
            BlockPos playerPos = player.func_180425_c();
            double distanceToWap = Math.sqrt(playerPos.func_177951_i((Vec3i)wapPos));
            return distanceToWap;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public double getWAPRange(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        IWirelessAccessPoint wap = this.getClosestWAPToPlayer(wirelessTerm, player);
        if (wap != null) {
            return wap.getRange();
        }
        return Double.MAX_VALUE;
    }

    @Override
    public IWirelessAccessPoint getClosestWAPToPlayer(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        Set<IWirelessAccessPoint> wapList = this.getWAPs(wirelessTerm, player);
        double closestDistance = -1.0;
        IWirelessAccessPoint closestWAP = null;
        for (IWirelessAccessPoint wap : wapList) {
            BlockPos wapPos = wap.getLocation().getPos();
            BlockPos playerPos = player.func_180425_c();
            double thisWAPDistance = Math.sqrt(playerPos.func_177951_i((Vec3i)wapPos));
            if (closestDistance == -1.0) {
                closestDistance = thisWAPDistance;
                closestWAP = wap;
                continue;
            }
            if (!(thisWAPDistance < closestDistance)) continue;
            closestDistance = thisWAPDistance;
            closestWAP = wap;
        }
        return closestDistance == -1.0 ? null : closestWAP;
    }

    @Override
    public Set<IWirelessAccessPoint> getWAPs(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        WTGuiObject<?> object;
        if (this.isAnyWT(wirelessTerm) && (object = this.getGUIObject(wirelessTerm, player)) != null) {
            return Sets.newHashSet(object.getWAPs());
        }
        return new HashSet<IWirelessAccessPoint>();
    }

    @Override
    public WTGuiObject<?> getGUIObject(EntityPlayer player) {
        return this.getGUIObject(null, player);
    }

    @Override
    public WTGuiObject<?> getGUIObject(@Nullable ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        if (wirelessTerm == null) {
            ContainerWT c;
            if (player.field_71070_bA instanceof ContainerWT && (c = (ContainerWT)player.field_71070_bA).getGuiObject() != null) {
                return c.getGuiObject();
            }
        } else if (wirelessTerm.func_77973_b() instanceof ICustomWirelessTerminalItem && player != null && player.func_130014_f_() != null) {
            ICustomWirelessTerminalItem wth = (ICustomWirelessTerminalItem)wirelessTerm.func_77973_b();
            return this.getGUIObject(wth, wirelessTerm, player);
        }
        return null;
    }

    @Override
    public WTGuiObject<?> getGUIObject(ICustomWirelessTerminalItem wth, @Nonnull ItemStack wirelessTerm, EntityPlayer player) {
        return new WTGuiObjectImpl(wth, wirelessTerm, player, player.func_130014_f_(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
    }

    @Override
    public void setInfinityEnergy(@Nonnull ItemStack wirelessTerm, int amount) {
        if (!this.isWTCreative(wirelessTerm)) {
            NBTTagCompound nbt = this.ensureTag(wirelessTerm);
            nbt.func_74768_a(WTApi.instance().getConstants().getNBTTagNames().infinityEnergy(), amount);
            wirelessTerm.func_77982_d(nbt);
        }
    }

    @Override
    public int getInfinityEnergy(@Nonnull ItemStack wirelessTerm) {
        NBTTagCompound nbt = this.ensureTag(wirelessTerm);
        if (!nbt.func_74764_b(WTApi.instance().getConstants().getNBTTagNames().infinityEnergy()) && !this.isWTCreative(wirelessTerm)) {
            nbt.func_74768_a(WTApi.instance().getConstants().getNBTTagNames().infinityEnergy(), 0);
        }
        return this.isWTCreative(wirelessTerm) ? Integer.MAX_VALUE : nbt.func_74762_e(WTApi.instance().getConstants().getNBTTagNames().infinityEnergy());
    }

    @Override
    public void drainInfinityEnergy(@Nonnull ItemStack wirelessTerm, EntityPlayer player, boolean isBauble, int slot) {
        if (player instanceof EntityPlayerMP && !LibConfig.USE_OLD_INFINTY_MECHANIC && !this.isWTCreative(wirelessTerm)) {
            int current = this.getInfinityEnergy(wirelessTerm);
            if (!this.isInRangeOfWAP(wirelessTerm, player)) {
                int reducedAmount = current - LibConfig.INFINITY_ENERGY_DRAIN;
                if (reducedAmount < 0) {
                    reducedAmount = 0;
                }
                this.setInfinityEnergy(wirelessTerm, reducedAmount);
                LibNetworking.instance().sendTo(new PacketSyncInfinityEnergy(this.getInfinityEnergy(wirelessTerm), player.func_110124_au(), isBauble, slot), (EntityPlayerMP)player);
            }
        }
    }

    @Override
    public boolean isWTCreative(ItemStack wirelessTerm) {
        return !wirelessTerm.func_190926_b() && wirelessTerm.func_77973_b() instanceof ICustomWirelessTerminalItem && ((ICustomWirelessTerminalItem)wirelessTerm.func_77973_b()).isCreative();
    }

    @Override
    public NBTTagCompound ensureTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    @Override
    public boolean isTerminalLinked(ItemStack wirelessTerminal) {
        String sourceKey = "";
        if (wirelessTerminal.func_77973_b() instanceof ICustomWirelessTerminalItem && wirelessTerminal.func_77942_o()) {
            sourceKey = ((ICustomWirelessTerminalItem)wirelessTerminal.func_77973_b()).getEncryptionKey(wirelessTerminal);
            return sourceKey != null && !sourceKey.isEmpty();
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String color(String color) {
        switch (color) {
            case "white": {
                return TextFormatting.WHITE.toString();
            }
            case "black": {
                return TextFormatting.BLACK.toString();
            }
            case "green": {
                return TextFormatting.GREEN.toString();
            }
            case "red": {
                return TextFormatting.RED.toString();
            }
            case "yellow": {
                return TextFormatting.YELLOW.toString();
            }
            case "aqua": {
                return TextFormatting.AQUA.toString();
            }
            case "blue": {
                return TextFormatting.BLUE.toString();
            }
            case "italics": {
                return TextFormatting.ITALIC.toString();
            }
            case "bold": {
                return TextFormatting.BOLD.toString();
            }
        }
        return TextFormatting.GRAY.toString();
    }

    @Override
    public AppEngSlot createOldBoosterSlot(IItemHandler inventory, int xPos, int yPos) {
        return new SlotBooster(inventory, xPos, yPos);
    }

    @Override
    public AppEngInternalInventory createBoosterInventory(IAEAppEngInventory inventory) {
        return new WTInventoryBooster(inventory);
    }

    @Override
    public AppEngSlot createInfinityBoosterSlot(int posX, int posY) {
        return new SlotBoosterEnergy(posX, posY);
    }

    @Override
    public AppEngSlot createNullSlot() {
        return new NullSlot();
    }

    @Override
    public AppEngSlot createArmorSlot(EntityPlayer player, IItemHandler inventory, int slot, int posX, int posY, EntityEquipmentSlot armorSlot) {
        return new SlotArmor(player, inventory, slot, posX, posY, armorSlot);
    }

    @Override
    public AppEngSlot createTrashSlot(IItemHandler inventory, int posX, int posY) {
        return new SlotTrash(inventory, posX, posY);
    }

    @Override
    public IWTGuiScrollbar createScrollbar() {
        return new GuiScrollbar();
    }

    public static class WUTUtilityImpl
    extends WUTUtility {
        private static WUTUtilityImpl INSTANCE = new WUTUtilityImpl();

        private WUTUtilityImpl() {
        }

        public static WUTUtility getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean doesWUTSupportType(ItemStack wut, Class<?> type) {
            return ItemWUT.isTypeInstalled(wut, type);
        }

        @Override
        public Pair<ItemStack, Integer> getSelectedTerminal(ItemStack wut) {
            return ItemWUT.getSelectedTerminalStack(wut);
        }

        @Override
        public boolean isWUT(ItemStack stack) {
            return stack.func_77973_b() instanceof IWirelessUniversalItem;
        }

        @Override
        public ResourceLocation[] getMenuIcons(ItemStack wut) {
            return ItemWUT.getMenuIcons(wut);
        }

        @Override
        public List<Pair<ItemStack, Integer>> getStoredTerminals(ItemStack wut) {
            return ItemWUT.getStoredTerminalStacks(wut);
        }

        @Override
        public List<Pair<ICustomWirelessTerminalItem, Integer>> getStoredTerminalHandlers(ItemStack wut) {
            return ItemWUT.getStoredTerminalHandlers(wut);
        }
    }

    public static class WTConfigImpl
    extends WTConfig {
        @Override
        public boolean isInfinityBoosterCardEnabled() {
            return LibConfig.WT_BOOSTER_ENABLED;
        }

        @Override
        public boolean isOldInfinityMechanicEnabled() {
            return LibConfig.USE_OLD_INFINTY_MECHANIC;
        }

        @Override
        public int getLowInfinityEnergyWarningAmount() {
            return LibConfig.INFINTY_ENERGY_LOW_WARNING_AMOUNT;
        }

        @Override
        public boolean shiftClickBaublesEnabled() {
            return LibConfig.SHIFT_CLICK_BAUBLES;
        }

        @Override
        public int getWTMaxPower() {
            return LibConfig.WT_MAX_POWER;
        }

        @Override
        public String getConfigFile() {
            return "config/AE2WirelessTerminals.cfg";
        }
    }
}

