/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectSteal;
import com.rwtema.careerbees.helpers.NameHelper;
import com.rwtema.careerbees.items.DelayedInsertionHelper;
import com.rwtema.careerbees.items.ItemIngredients;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class EffectStealMob
extends EffectSteal<EntityLiving> {
    public static final EffectSteal MOB = new EffectStealMob();
    final DamageSource bee = new DamageSource("careerbees.damage.police");
    @Nullable
    Pair<EntityLiving, IBeeHousing> housingInventoryPair = null;
    final DamageSource bee_player = new DamageSource("careerbees.damage.police"){

        @Nullable
        public Entity func_76346_g() {
            World worldObj;
            Pair<EntityLiving, IBeeHousing> housingInventoryPair = EffectStealMob.this.housingInventoryPair;
            if (housingInventoryPair != null && (worldObj = ((IBeeHousing)housingInventoryPair.getRight()).getWorldObj()) instanceof WorldServer) {
                return FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)worldObj));
            }
            return null;
        }
    };

    @Override
    public float getCooldown(@Nonnull IBeeGenome genome, Random random) {
        return 200.0f;
    }

    public EffectStealMob() {
        super("steal.mob", 10);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void getDrops(@Nonnull LivingDropsEvent event) {
        Pair<EntityLiving, IBeeHousing> housingInventoryPair = this.housingInventoryPair;
        if (housingInventoryPair == null || event.getEntityLiving() != housingInventoryPair.getLeft()) {
            return;
        }
        EntityLiving entityLiving = (EntityLiving)event.getEntityLiving();
        ArrayList<ItemStack> grabbed_stacks = new ArrayList<ItemStack>();
        IBeeHousing housing = (IBeeHousing)housingInventoryPair.getRight();
        IBeeHousingInventory housingInv = housing.getBeeInventory();
        event.getDrops().removeIf(item -> this.addStacks((List<ItemStack>)grabbed_stacks, housing, (EntityItem)item));
        this.addAdditionalProducts(entityLiving, grabbed_stacks, housing, housingInv);
    }

    protected void addAdditionalProducts(@Nonnull EntityLiving entityLiving, @Nonnull List<ItemStack> grabbed_stacks, IBeeHousing housing, @Nonnull IBeeHousingInventory housingInv) {
        NBTTagCompound tag = new NBTTagCompound();
        if (entityLiving.func_145818_k_()) {
            tag.func_74778_a("custom_name", entityLiving.func_95999_t());
        } else {
            String s = EntityList.func_75621_b((Entity)entityLiving);
            if (s == null) {
                s = "generic";
            }
            tag.func_74778_a("name", "entity." + s + ".name");
        }
        NBTTagList list = new NBTTagList();
        for (ItemStack grabbed_stack : grabbed_stacks) {
            NBTTagCompound nbt = grabbed_stack.func_77955_b(new NBTTagCompound());
            nbt.func_74768_a("Count", grabbed_stack.func_190916_E());
            list.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a("drops", (NBTBase)list);
        tag.func_74772_a("world_time", entityLiving.field_70170_p.func_82737_E());
        tag.func_74768_a("world_dim", entityLiving.field_70170_p.field_73011_w.getDimension());
        tag.func_74777_a("officer_name", NameHelper.getQueenNameSeed(housing));
        ItemStack product = ItemIngredients.IngredientType.REPORT.get();
        product.func_77982_d(tag);
        housingInv.addProduct(product, true);
    }

    private boolean addStacks(@Nonnull List<ItemStack> grabbed_stacks, @Nonnull IBeeHousing housing, @Nonnull EntityItem item) {
        ItemStack stack = item.func_92059_d().func_77946_l();
        ItemStack newItemStack = DelayedInsertionHelper.addEntityStack(stack, housing, (Entity)item);
        if (newItemStack == stack || newItemStack.func_190916_E() == stack.func_190916_E()) {
            return false;
        }
        if (newItemStack.func_190926_b()) {
            item.func_70106_y();
            item.func_92058_a(ItemStack.field_190927_a);
            EffectStealMob.mergeStackIntoList(grabbed_stacks, stack);
            return true;
        }
        item.func_92058_a(newItemStack);
        ItemStack addedStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - newItemStack.func_190916_E()));
        EffectStealMob.mergeStackIntoList(grabbed_stacks, addedStack);
        return false;
    }

    @Override
    public boolean canHandle(EntityLiving livingBase) {
        return livingBase instanceof IMob && livingBase.func_70089_S();
    }

    @Override
    @Nonnull
    protected Class<EntityLiving> getEntityClazz() {
        return EntityLiving.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean steal(@Nonnull EntityLiving livingBase, IBeeHousing housing, EffectSteal effect) {
        if (livingBase.func_70097_a(this.bee, Math.min(2.0f, livingBase.func_110143_aJ() - 0.005f))) {
            if (livingBase.func_110143_aJ() < 0.01f) {
                try {
                    this.housingInventoryPair = Pair.of((Object)livingBase, (Object)housing);
                    if (!livingBase.func_70097_a(this.bee_player, 20.0f)) {
                        livingBase.func_70097_a(this.bee_player, 40.0f);
                    }
                }
                finally {
                    this.housingInventoryPair = null;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void processingTick(Entity livingBase, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        int count;
        EntityLiving t;
        if (livingBase instanceof EntityLiving && this.canHandle(t = (EntityLiving)livingBase) && (count = BeeManager.armorApiaristHelper.wearsItems((EntityLivingBase)this.getEntityClazz().cast(livingBase), this.getUID(), true)) == 0) {
            this.steal(t, housing, (EffectSteal)this);
        }
    }

    @Override
    public boolean handleEntityLiving(@Nonnull Entity livingBase, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        return super.handleEntityLiving(livingBase, genome, housing);
    }
}

