/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.gui;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiHandler
implements IGuiHandler {
    private static final TIntObjectHashMap<ElementCreator<? extends Container>> serverGuiContainer = new TIntObjectHashMap();
    private static final TIntObjectHashMap<ElementCreator<? extends IGuiWrapper>> clientGuiContainer = new TIntObjectHashMap();

    public static void register(int ID, ElementCreator<? extends Container> server, ElementCreator<? extends IGuiWrapper> client) {
        if (serverGuiContainer.put(ID, server) != null || clientGuiContainer.put(ID, client) != null) {
            throw new RuntimeException(ID + " is already in use");
        }
    }

    public static <T> void registerTE(int ID, final @Nonnull Predicate<TileEntity> isTile, final @Nonnull BiFunction<T, EntityPlayer, ? extends Container> serverContainer, final @Nonnull BiFunction<T, EntityPlayer, ?> clientGuiContainer) {
        GuiHandler.register(ID, new fromTE<Container, T>(){

            @Override
            protected boolean isValid(TileEntity tileEntity) {
                return isTile.test(tileEntity);
            }

            @Override
            @Nullable
            public Container createObject(T tile, EntityPlayer player) {
                return (Container)serverContainer.apply(tile, player);
            }
        }, new fromTE<IGuiWrapper, T>(){

            @Override
            protected boolean isValid(TileEntity tileEntity) {
                return isTile.test(tileEntity);
            }

            @Override
            @Nullable
            public IGuiWrapper createObject(final T tile, final EntityPlayer player) {
                return new IGuiWrapper(){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public Object getGui() {
                        return clientGuiContainer.apply(tile, player);
                    }
                };
            }
        });
    }

    @Nullable
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ElementCreator creator = (ElementCreator)serverGuiContainer.get(ID);
        if (creator != null) {
            return creator.getElement(ID, player, world, x, y, z);
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ElementCreator creator = (ElementCreator)clientGuiContainer.get(ID);
        if (creator != null) {
            IGuiWrapper wrapper = (IGuiWrapper)creator.getElement(ID, player, world, x, y, z);
            return wrapper != null ? wrapper.getGui() : null;
        }
        return null;
    }

    static {
        GuiHandler.register(0, (ElementCreator<? extends Container>)new ElementCreator<Container>(){

            @Override
            @Nullable
            public Container getElement(int ID, @Nonnull EntityPlayer player, World world, int x, int y, int z) {
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(x);
                Item item = stackInSlot.func_77973_b();
                if (item instanceof ItemStackGuiContainer) {
                    return ((ItemStackGuiContainer)item).getContainer(player, stackInSlot, x);
                }
                return null;
            }
        }, (ElementCreator<? extends IGuiWrapper>)new ElementCreator<IGuiWrapper>(){

            @Override
            @Nullable
            public IGuiWrapper getElement(int ID, final @Nonnull EntityPlayer player, World world, final int x, int y, int z) {
                final ItemStack stackInSlot = player.field_71071_by.func_70301_a(x);
                final Item item = stackInSlot.func_77973_b();
                if (item instanceof ItemStackGuiContainer) {
                    return new IGuiWrapper(){

                        @Override
                        @SideOnly(value=Side.CLIENT)
                        public Object getGui() {
                            return ((ItemStackGuiContainer)item).getGui(player, stackInSlot, x);
                        }
                    };
                }
                return null;
            }
        });
        GuiHandler.registerTE(1, tile -> tile instanceof ITileGui, ITileGui::createContainer, ITileGui::createGui);
    }

    public static abstract class fromTE<E, T>
    implements ElementCreator<E> {
        @Override
        public E getElement(int ID, EntityPlayer player, @Nonnull World world, int x, int y, int z) {
            TileEntity tile;
            TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
            if (!this.isValid(tileEntity)) {
                return null;
            }
            try {
                tile = tileEntity;
            }
            catch (ClassCastException ignore) {
                return null;
            }
            if (tile != null) {
                return this.createObject(tile, player);
            }
            return null;
        }

        protected abstract boolean isValid(TileEntity var1);

        @Nullable
        public abstract E createObject(T var1, EntityPlayer var2);
    }

    public static interface IGuiWrapper {
        public Object getGui();
    }

    public static interface ElementCreator<E> {
        @Nullable
        public E getElement(int var1, EntityPlayer var2, World var3, int var4, int var5, int var6);
    }

    public static interface ItemStackGuiContainer {
        public Container getContainer(EntityPlayer var1, ItemStack var2, int var3);

        @SideOnly(value=Side.CLIENT)
        public Object getGui(EntityPlayer var1, ItemStack var2, int var3);
    }

    public static interface ITileGui {
        public Container createContainer(EntityPlayer var1);

        public Object createGui(EntityPlayer var1);
    }
}

