/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.helpers;

import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;

public class ColorHelper {
    public static int getA(int col) {
        return (col & 0xFF000000) >>> 24;
    }

    public static int getR(int col) {
        return (col & 0xFF0000) >> 16;
    }

    public static int getG(int col) {
        return (col & 0xFF00) >> 8;
    }

    public static int getB(int col) {
        return col & 0xFF;
    }

    public static float getRF(int col) {
        return (float)ColorHelper.getR(col) / 255.0f;
    }

    public static float getGF(int col) {
        return (float)ColorHelper.getG(col) / 255.0f;
    }

    public static float getBF(int col) {
        return (float)ColorHelper.getB(col) / 255.0f;
    }

    public static float getAF(int col) {
        return (float)ColorHelper.getA(col) / 255.0f;
    }

    public static int makeAlphaWhite(int alpha) {
        if (alpha <= 0) {
            return 0;
        }
        if (alpha >= 255) {
            return -1;
        }
        return (alpha & 0xFF) << 24 | 0xFFFFFF;
    }

    public static int color(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    @Nonnull
    public static float[] colToFloat(int rgb) {
        return new float[]{(float)ColorHelper.getA(rgb) / 255.0f, (float)ColorHelper.getR(rgb) / 255.0f, (float)ColorHelper.getG(rgb) / 255.0f, (float)ColorHelper.getB(rgb) / 255.0f};
    }

    public static int floatsToCol(float[] rgb) {
        return ColorHelper.color((int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f), (int)(rgb[3] * 255.0f), (int)(rgb[0] * 255.0f));
    }

    public static int brightness(int col) {
        return ColorHelper.brightness(ColorHelper.getR(col), ColorHelper.getG(col), ColorHelper.getB(col));
    }

    public static int brightness(int r, int g, int b) {
        return r * 109 + g * 366 + b * 37 >> 9;
    }

    public static int makeGray(int b) {
        return ColorHelper.color(b, b, b, 255);
    }

    public static int colorClamp(float r, float g, float b, float a) {
        return ColorHelper.color(ColorHelper.clamp(r), ColorHelper.clamp(g), ColorHelper.clamp(b), ColorHelper.clamp(a));
    }

    public static int clamp(float f) {
        return MathHelper.func_76125_a((int)((int)(f * 255.0f)), (int)0, (int)255);
    }

    public static int multShade(int input, float perc) {
        if (perc >= 1.0f || input == 0) {
            return input;
        }
        if (perc <= 0.0f) {
            return input & 0xFF000000;
        }
        return ColorHelper.color(Math.round((float)ColorHelper.getR(input) * perc), Math.round((float)ColorHelper.getG(input) * perc), Math.round((float)ColorHelper.getB(input) * perc), ColorHelper.getA(input));
    }

    public static int alpha(int color, float alpha) {
        if (alpha == 0.0f) {
            return 0;
        }
        float af = ColorHelper.getAF(color);
        if (af == 0.0f) {
            return 0;
        }
        return ColorHelper.colorClamp(ColorHelper.getRF(color), ColorHelper.getGF(color), ColorHelper.getBF(color), af * alpha);
    }
}

