/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.api;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public interface IDynamicPatternDetailsRS {
    public static final Map<String, Function<NBTTagCompound, IDynamicPatternDetailsRS>> FACTORIES = new HashMap<String, Function<NBTTagCompound, IDynamicPatternDetailsRS>>();
    public static final WeakHashMap<NBTTagCompound, IDynamicPatternDetailsRS> CACHE = new WeakHashMap();
    public static final String ID_TAG = "_id";

    public static IDynamicPatternDetailsRS load(NBTTagCompound tag) {
        return CACHE.computeIfAbsent(tag, t -> {
            String id = t.func_74779_i(ID_TAG);
            Function<NBTTagCompound, IDynamicPatternDetailsRS> fac = FACTORIES.get(id);
            return fac.apply((NBTTagCompound)t);
        });
    }

    public static NBTTagCompound save(IDynamicPatternDetailsRS det) {
        String id = det.getId();
        NBTTagCompound tag = new NBTTagCompound();
        det.storeToNBT(tag);
        tag.func_74778_a(ID_TAG, id);
        return tag;
    }

    default public String getId() {
        throw new AbstractMethodError("Missing impl: " + this.getClass());
    }

    default public void storeToNBT(NBTTagCompound tag) {
        throw new AbstractMethodError("Missing impl: " + this.getClass());
    }

    public NonNullList<ItemStack> getInputs(ItemStack var1, NonNullList<ItemStack> var2);

    public NonNullList<ItemStack> getOutputs(ItemStack var1, NonNullList<ItemStack> var2);

    public static class TileEntityWrapper
    implements IDynamicPatternDetailsRS {
        private int dim;
        private BlockPos pos;
        private IDynamicPatternDetailsRS tile;

        public TileEntityWrapper(int dim, BlockPos pos) {
            this.dim = dim;
            this.pos = pos;
        }

        public TileEntityWrapper(World world, BlockPos pos) {
            this(world.field_73011_w.getDimension(), pos);
        }

        public TileEntityWrapper(TileEntity te) {
            this(te.func_145831_w(), te.func_174877_v());
            this.tile = (IDynamicPatternDetailsRS)te;
        }

        @Override
        public String getId() {
            return "te";
        }

        @Override
        public void storeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("dim", this.dim);
            tag.func_74768_a("x", this.pos.func_177958_n());
            tag.func_74768_a("y", this.pos.func_177956_o());
            tag.func_74768_a("z", this.pos.func_177952_p());
        }

        public static TileEntityWrapper create(NBTTagCompound tag) {
            return new TileEntityWrapper(tag.func_74762_e("dim"), new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")));
        }

        public void load() {
            TileEntity te;
            WorldServer w;
            if (this.tile == null && (w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim)) != null && (te = w.func_175625_s(this.pos)) instanceof IDynamicPatternDetailsRS) {
                this.tile = (IDynamicPatternDetailsRS)te;
            }
        }

        @Override
        public NonNullList<ItemStack> getInputs(ItemStack res, NonNullList<ItemStack> def) {
            this.load();
            return this.tile != null ? this.tile.getInputs(res, def) : def;
        }

        @Override
        public NonNullList<ItemStack> getOutputs(ItemStack res, NonNullList<ItemStack> def) {
            this.load();
            return this.tile != null ? this.tile.getOutputs(res, def) : def;
        }
    }
}

