/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.item;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.item.AEItemStack;
import com.tom.logisticsbridge.AE2Plugin;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.api.IDynamicPatternDetailsAE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class VirtualPatternAE
extends Item
implements ICraftingPatternItem {
    private static final WeakHashMap<Integer, ICraftingPatternDetails> CACHE = new WeakHashMap();

    public VirtualPatternAE() {
        this.func_77655_b("lb.virtPattern");
    }

    public ICraftingPatternDetails getPatternForItem(ItemStack is, World w) {
        return VirtualPatternAE.getPatternForItem(is);
    }

    private static ICraftingPatternDetails getPatternForItem(ItemStack is) {
        try {
            return new VirtualPatternHandler(is);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static ICraftingPatternDetails create(ItemStack input, ItemStack output) {
        return new VirtualPatternHandler(input, output);
    }

    public static ICraftingPatternDetails create(IAEItemStack output, IDynamicPatternDetailsAE handler) {
        int prime = 31;
        int result = 1;
        result = 31 * result + output.hashCode();
        result = 31 * result + handler.hashCode();
        return CACHE.computeIfAbsent(result, h -> new VirtualPatternHandler(output.asItemStackRepresentation(), handler));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.logisticsbridge.techItem", (Object[])new Object[0]));
    }

    static {
        IDynamicPatternDetailsAE.FACTORIES.put("te", IDynamicPatternDetailsAE.TileEntityWrapper::create);
    }

    public static class VirtualPatternHandler
    implements ICraftingPatternDetails,
    Comparable<VirtualPatternHandler> {
        private final ItemStack patternItem;
        private final ItemStack result;
        private final IAEItemStack[] condensedInputs;
        private final IAEItemStack[] condensedOutputs;
        private final IAEItemStack[] inputs;
        private final IAEItemStack[] outputs;
        private final IAEItemStack pattern;
        private final IDynamicPatternDetailsAE dynamic;
        private int priority = 0;

        public VirtualPatternHandler(ItemStack output, IDynamicPatternDetailsAE handler) {
            this.result = output;
            ItemStack is = new ItemStack((Item)AE2Plugin.virtualPattern);
            ItemStack input = new ItemStack(LogisticsBridge.logisticsFakeItem);
            is.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = is.func_77978_p();
            NBTTagList l = new NBTTagList();
            tag.func_74782_a("in", (NBTBase)l);
            NBTTagCompound t = new NBTTagCompound();
            input.func_77955_b(t);
            l.func_74742_a((NBTBase)t);
            l = new NBTTagList();
            tag.func_74782_a("out", (NBTBase)l);
            t = new NBTTagCompound();
            output.func_77955_b(t);
            l.func_74742_a((NBTBase)t);
            tag.func_74782_a("dynamic", (NBTBase)IDynamicPatternDetailsAE.save(handler));
            this.patternItem = is;
            this.pattern = AEItemStack.fromItemStack((ItemStack)is);
            this.outputs = new IAEItemStack[]{AEItemStack.fromItemStack((ItemStack)output)};
            this.condensedOutputs = this.outputs;
            this.inputs = new IAEItemStack[]{AEItemStack.fromItemStack((ItemStack)input)};
            this.condensedInputs = this.inputs;
            this.dynamic = handler;
        }

        public VirtualPatternHandler(ItemStack input, ItemStack output) {
            this.result = output;
            ItemStack is = new ItemStack((Item)AE2Plugin.virtualPattern);
            is.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = is.func_77978_p();
            NBTTagList l = new NBTTagList();
            tag.func_74782_a("in", (NBTBase)l);
            NBTTagCompound t = new NBTTagCompound();
            input.func_77955_b(t);
            l.func_74742_a((NBTBase)t);
            l = new NBTTagList();
            tag.func_74782_a("out", (NBTBase)l);
            t = new NBTTagCompound();
            output.func_77955_b(t);
            l.func_74742_a((NBTBase)t);
            this.patternItem = is;
            this.pattern = AEItemStack.fromItemStack((ItemStack)is);
            this.outputs = new IAEItemStack[]{AEItemStack.fromItemStack((ItemStack)output)};
            this.condensedOutputs = this.outputs;
            this.inputs = new IAEItemStack[]{AEItemStack.fromItemStack((ItemStack)input)};
            this.condensedInputs = this.inputs;
            this.dynamic = null;
        }

        public VirtualPatternHandler(ItemStack is) {
            NBTTagCompound tag = is.func_77978_p();
            if (tag == null) {
                throw new IllegalArgumentException("No pattern here!");
            }
            this.patternItem = is;
            this.pattern = AEItemStack.fromItemStack((ItemStack)is);
            ArrayList<IAEStack> in = new ArrayList<IAEStack>();
            ArrayList<IAEStack> out = new ArrayList<IAEStack>();
            IItemStorageChannel ITEMS = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
            NBTTagList inTag = tag.func_150295_c("in", 10);
            if (tag.func_150297_b("out", 10)) {
                this.result = new ItemStack(tag.func_74775_l("out"));
                out.add(ITEMS.createStack((Object)this.result));
            } else {
                NBTTagList outTag = tag.func_150295_c("out", 10);
                for (int x = 0; x < outTag.func_74745_c(); ++x) {
                    NBTTagCompound resultItemTag = outTag.func_150305_b(x);
                    ItemStack gs = new ItemStack(resultItemTag);
                    if (!resultItemTag.func_82582_d() && gs.func_190926_b()) {
                        throw new IllegalArgumentException("No pattern here!");
                    }
                    if (gs.func_190926_b()) continue;
                    out.add(ITEMS.createStack((Object)gs));
                }
                this.result = ((IAEItemStack)out.get(0)).asItemStackRepresentation();
            }
            for (int x = 0; x < inTag.func_74745_c(); ++x) {
                NBTTagCompound ingredient = inTag.func_150305_b(x);
                ItemStack gs = new ItemStack(ingredient);
                if (!ingredient.func_82582_d() && gs.func_190926_b()) {
                    throw new IllegalArgumentException("No pattern here!");
                }
                in.add(ITEMS.createStack((Object)gs));
            }
            this.outputs = out.toArray(new IAEItemStack[out.size()]);
            this.inputs = in.toArray(new IAEItemStack[in.size()]);
            HashMap<IAEItemStack, IAEItemStack> tmpOutputs = new HashMap<IAEItemStack, IAEItemStack>();
            for (IAEItemStack io : this.outputs) {
                if (io == null) continue;
                IAEItemStack g = (IAEItemStack)tmpOutputs.get(io);
                if (g == null) {
                    tmpOutputs.put(io, io.copy());
                    continue;
                }
                g.add(io);
            }
            HashMap<IAEItemStack, IAEItemStack> tmpInputs = new HashMap<IAEItemStack, IAEItemStack>();
            for (IAEItemStack io : this.inputs) {
                if (io == null) continue;
                IAEItemStack g = (IAEItemStack)tmpInputs.get(io);
                if (g == null) {
                    tmpInputs.put(io, io.copy());
                    continue;
                }
                g.add(io);
            }
            if (tmpOutputs.isEmpty()) {
                throw new IllegalStateException("No pattern here!");
            }
            this.condensedInputs = new IAEItemStack[tmpInputs.size()];
            int offset = 0;
            Iterator iterator = tmpInputs.values().iterator();
            while (iterator.hasNext()) {
                IAEItemStack io;
                this.condensedInputs[offset] = io = (IAEItemStack)iterator.next();
                ++offset;
            }
            offset = 0;
            this.condensedOutputs = new IAEItemStack[tmpOutputs.size()];
            iterator = tmpOutputs.values().iterator();
            while (iterator.hasNext()) {
                IAEItemStack io;
                this.condensedOutputs[offset] = io = (IAEItemStack)iterator.next();
                ++offset;
            }
            if (tag.func_150297_b("dynamic", 10)) {
                this.dynamic = IDynamicPatternDetailsAE.load(tag.func_74775_l("dynamic"));
                this.dynamic.getOutputs(this.result, null, false);
            } else {
                this.dynamic = null;
            }
        }

        public ItemStack getPattern() {
            return this.patternItem;
        }

        public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }

        public boolean isCraftable() {
            return false;
        }

        public IAEItemStack[] getInputs() {
            return this.dynamic != null ? this.dynamic.getInputs(this.result, this.inputs, false) : this.inputs;
        }

        public IAEItemStack[] getCondensedInputs() {
            return this.dynamic != null ? this.dynamic.getInputs(this.result, this.condensedInputs, true) : this.condensedInputs;
        }

        public IAEItemStack[] getCondensedOutputs() {
            return this.dynamic != null ? this.dynamic.getOutputs(this.result, this.condensedOutputs, true) : this.condensedOutputs;
        }

        public IAEItemStack[] getOutputs() {
            return this.dynamic != null ? this.dynamic.getOutputs(this.result, this.outputs, true) : this.outputs;
        }

        public boolean canSubstitute() {
            return false;
        }

        public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualPatternHandler other = (VirtualPatternHandler)obj;
            if (this.pattern != null && other.pattern != null) {
                return this.pattern.equals(other.pattern);
            }
            return false;
        }

        @Override
        public int compareTo(VirtualPatternHandler o) {
            return Integer.compare(o.priority, this.priority);
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }
    }
}

