/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.item;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.RSPlugin;
import com.tom.logisticsbridge.api.IDynamicPatternDetailsRS;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class VirtualPatternRS
extends Item
implements ICraftingPatternProvider {
    private static final WeakHashMap<NBTTagCompound, ICraftingPattern> CACHE = new WeakHashMap();
    private static final String DYNAMIC_PATTERN_ID = "__dyPatternDetails";

    public VirtualPatternRS() {
        this.func_77655_b("lb.virtPatternRS");
    }

    public ICraftingPattern create(World world, ItemStack stack, ICraftingPatternContainer container) {
        return VirtualPatternRS.getPatternForItem(stack, container);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.logisticsbridge.techItem", (Object[])new Object[0]));
    }

    private static ICraftingPattern getPatternForItem(ItemStack is, ICraftingPatternContainer container) {
        try {
            return new VirtualPatternHandler(is, container);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static ICraftingPattern create(ItemStack output, ICraftingPatternContainer container) {
        NBTTagCompound ot = output.func_77955_b(new NBTTagCompound());
        return CACHE.computeIfAbsent(ot, n -> VirtualPatternRS.create(n, container));
    }

    public static ICraftingPattern create(ItemStack input, ItemStack output, ICraftingPatternContainer container) {
        NBTTagCompound ot = new NBTTagCompound();
        ot.func_74782_a("in", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        ot.func_74782_a("out", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        ot.func_74757_a("_writing", true);
        return CACHE.computeIfAbsent(ot, n -> VirtualPatternRS.create(n, container));
    }

    public static ICraftingPattern create(ItemStack output, IDynamicPatternDetailsRS handler, ICraftingPatternContainer container) {
        NBTTagCompound ot = output.func_77955_b(new NBTTagCompound());
        ot.func_74782_a(DYNAMIC_PATTERN_ID, (NBTBase)IDynamicPatternDetailsRS.save(handler));
        return CACHE.computeIfAbsent(ot, n -> VirtualPatternRS.create(n, container));
    }

    private static ICraftingPattern create(NBTTagCompound ot, ICraftingPatternContainer container) {
        ItemStack is = new ItemStack((Item)RSPlugin.virtualPattern);
        NBTTagCompound dyTag = ot.func_74775_l(DYNAMIC_PATTERN_ID);
        ot.func_82580_o(DYNAMIC_PATTERN_ID);
        NBTTagCompound in = ot.func_74775_l("in");
        NBTTagCompound out = ot.func_74775_l("out");
        NBTTagCompound oldOt = ot;
        if (!out.func_82582_d()) {
            ot = out;
        }
        is.func_77982_d(new NBTTagCompound());
        NBTTagCompound tag = is.func_77978_p();
        tag.func_74782_a("out", (NBTBase)ot);
        NBTTagList list = new NBTTagList();
        tag.func_74782_a("in", (NBTBase)list);
        if (oldOt.func_74767_n("_writing")) {
            tag.func_74757_a("writer", true);
        }
        if (in.func_82582_d()) {
            list.func_74742_a((NBTBase)LogisticsBridge.fakeStack(ot, 1).func_77955_b(new NBTTagCompound()));
        } else {
            list.func_74742_a((NBTBase)in);
        }
        if (!dyTag.func_82582_d()) {
            tag.func_74782_a("dynamic", (NBTBase)dyTag);
        }
        return VirtualPatternRS.getPatternForItem(is, container);
    }

    static {
        IDynamicPatternDetailsRS.FACTORIES.put("te", IDynamicPatternDetailsRS.TileEntityWrapper::create);
    }

    public static class VirtualPatternHandler
    implements ICraftingPattern {
        private static final NonNullList<ItemStack> EMPTY_IS = NonNullList.func_191196_a();
        private static final NonNullList<FluidStack> EMPTY_FS = NonNullList.func_191196_a();
        private final ICraftingPatternContainer container;
        private ItemStack stack;
        private ItemStack result;
        private final NonNullList<ItemStack> in;
        private final NonNullList<ItemStack> out;
        private final IDynamicPatternDetailsRS dynamic;
        private final boolean writingPattern;

        public VirtualPatternHandler(ItemStack is, ICraftingPatternContainer container) {
            this.container = container;
            this.stack = is;
            NBTTagCompound tag = is.func_77978_p();
            if (tag == null) {
                throw new IllegalArgumentException("No pattern here!");
            }
            if (tag.func_150297_b("out", 10)) {
                this.result = new ItemStack(tag.func_74775_l("out"));
            }
            this.in = NonNullList.func_191196_a();
            this.out = NonNullList.func_191196_a();
            this.out.add((Object)this.result);
            this.writingPattern = tag.func_74767_n("writer");
            NBTTagList inTag = tag.func_150295_c("in", 10);
            for (int x = 0; x < inTag.func_74745_c(); ++x) {
                NBTTagCompound ingredient = inTag.func_150305_b(x);
                ItemStack gs = new ItemStack(ingredient);
                if (!ingredient.func_82582_d() && gs.func_190926_b()) {
                    throw new IllegalArgumentException("No pattern here!");
                }
                this.in.add((Object)gs);
            }
            if (tag.func_150297_b("dynamic", 10)) {
                this.dynamic = IDynamicPatternDetailsRS.load(tag.func_74775_l("dynamic"));
                this.dynamic.getOutputs(this.result, null);
            } else {
                this.dynamic = null;
            }
        }

        public ICraftingPatternContainer getContainer() {
            return this.container;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public boolean isValid() {
            return true;
        }

        public boolean isProcessing() {
            return !this.writingPattern;
        }

        public boolean isOredict() {
            return false;
        }

        public List<NonNullList<ItemStack>> getInputs() {
            return (this.dynamic != null ? this.dynamic.getInputs(this.result, this.in) : this.in).stream().map(i -> NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{i})).collect(Collectors.toList());
        }

        public NonNullList<ItemStack> getOutputs() {
            return this.dynamic != null ? this.dynamic.getOutputs(this.result, this.out) : this.out;
        }

        public ItemStack getOutput(NonNullList<ItemStack> took) {
            if (this.writingPattern) {
                return this.result.func_77946_l();
            }
            throw new IllegalStateException("Cannot get crafting output from processing pattern");
        }

        public NonNullList<ItemStack> getByproducts() {
            if (this.writingPattern) {
                return EMPTY_IS;
            }
            throw new IllegalStateException("Cannot get byproduct outputs from processing pattern");
        }

        public NonNullList<ItemStack> getByproducts(NonNullList<ItemStack> took) {
            if (this.writingPattern) {
                return EMPTY_IS;
            }
            throw new IllegalStateException("Cannot get byproduct outputs from processing pattern");
        }

        public NonNullList<FluidStack> getFluidInputs() {
            return EMPTY_FS;
        }

        public NonNullList<FluidStack> getFluidOutputs() {
            return EMPTY_FS;
        }

        public String getId() {
            return "normal";
        }

        public boolean canBeInChainWith(ICraftingPattern other) {
            return other == this;
        }

        public int getChainHashCode() {
            int result = 0;
            result = 31 * result + 1;
            result = 31 * result;
            for (ItemStack input : this.in) {
                result = 31 * result + API.instance().getItemStackHashCode(input);
            }
            for (ItemStack output : this.out) {
                result = 31 * result + API.instance().getItemStackHashCode(output);
            }
            result = 31 * result + 69;
            return result;
        }
    }
}

