/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.module;

import com.tom.logisticsbridge.pipe.CraftingManager;
import com.tom.logisticsbridge.pipe.ResultPipe;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvide;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.modules.ChassiModule;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.DictCraftingTemplate;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IPromise;
import logisticspipes.request.ItemCraftingTemplate;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsExtraDictPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;

public class ModuleCrafterExt
extends ModuleCrafter {
    public ICraftingTemplate addCrafting(IResource toCraft) {
        IRouter r;
        int i;
        if (!(this._service instanceof CraftingManager)) {
            return null;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        List stack = this.getCraftedItems();
        if (stack == null) {
            return null;
        }
        ItemCraftingTemplate template = null;
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzyFlags.getBitSet().nextSetBit(0) != -1) {
            if (toCraft instanceof DictResource) {
                for (ItemIdentifierStack craftable : stack) {
                    DictResource dict = new DictResource(craftable, null);
                    dict.loadFromBitSet(this.outputFuzzyFlags.getBitSet());
                    if (!toCraft.matches(craftable.getItem(), IResource.MatchSettings.NORMAL) || !dict.matches(((DictResource)toCraft).getItem(), IResource.MatchSettings.NORMAL) || !dict.getBitSet().equals(((DictResource)toCraft).getBitSet())) continue;
                    template = new DictCraftingTemplate(dict, (ICraftItems)this, this.priority);
                    break;
                }
            }
        } else {
            for (ItemIdentifierStack craftable : stack) {
                if (!toCraft.matches(craftable.getItem(), IResource.MatchSettings.NORMAL)) continue;
                template = new ItemCraftingTemplate(craftable, (ICraftItems)this, this.priority);
                break;
            }
        }
        if (template == null) {
            return null;
        }
        boolean buffered = mngr.isBuffered();
        IRouter defSat = this.getSatelliteRouterByID(mngr.getSatelliteUUID());
        if (defSat == null) {
            return null;
        }
        IRequestItems[] target = new IRequestItems[9];
        if (buffered) {
            for (i = 0; i < 9; ++i) {
                target[i] = this;
            }
        } else {
            for (i = 0; i < 9; ++i) {
                target[i] = defSat.getPipe();
            }
            boolean hasSatellite = this.isSatelliteConnected();
            if (!hasSatellite) {
                return null;
            }
            if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
                IRouter r2 = this.getSatelliteRouter(-1);
                if (r2 != null) {
                    CoreRoutedPipe sat = r2.getPipe();
                    for (int i2 = 6; i2 < 9; ++i2) {
                        target[i2] = sat;
                    }
                }
            } else {
                for (int i3 = 0; i3 < 9; ++i3) {
                    r = this.getSatelliteRouter(i3);
                    if (r == null) continue;
                    target[i3] = r.getPipe();
                }
            }
        }
        for (i = 0; i < 9; ++i) {
            ItemIdentifierStack resourceStack = this.getMaterials(i);
            if (resourceStack == null || resourceStack.getStackSize() == 0) continue;
            ItemResource req = null;
            if (this.getUpgradeManager().isFuzzyUpgrade() && this.fuzzyCraftingFlagArray[i].getBitSet().nextSetBit(0) != -1) {
                DictResource dict = new DictResource(resourceStack, target[i]);
                req = dict;
                dict.loadFromBitSet(this.fuzzyCraftingFlagArray[i].getBitSet());
            } else {
                req = new ItemResource(resourceStack, target[i]);
            }
            template.addRequirement((IResource)req, (IAdditionalTargetInformation)new BufferInformation(i, this.getPositionInt()));
        }
        int liquidCrafter = this.getUpgradeManager().getFluidCrafter();
        IRequestFluid[] liquidTarget = new IRequestFluid[liquidCrafter];
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            r = this.getFluidSatelliteRouter(-1);
            if (r != null) {
                IRequestFluid sat = (IRequestFluid)r.getPipe();
                for (int i4 = 0; i4 < liquidCrafter; ++i4) {
                    liquidTarget[i4] = sat;
                }
            }
        } else {
            for (int i5 = 0; i5 < liquidCrafter; ++i5) {
                IRouter r3 = this.getFluidSatelliteRouter(i5);
                if (r3 == null) continue;
                liquidTarget[i5] = (IRequestFluid)r3.getPipe();
            }
        }
        for (int i6 = 0; i6 < liquidCrafter; ++i6) {
            FluidIdentifier liquid = this.getFluidMaterial(i6);
            int amount = this.getFluidAmount()[i6];
            if (liquid == null || amount <= 0 || liquidTarget[i6] == null) continue;
            template.addRequirement((IResource)new FluidResource(liquid, amount, liquidTarget[i6]), null);
        }
        if (this.getUpgradeManager().hasByproductExtractor() && this.getByproductItem() != null) {
            template.addByproduct(this.getByproductItem());
        }
        return template;
    }

    private IRouter getSatelliteRouter(int x) {
        if (x == -1) {
            int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(this.satelliteUUID);
            return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
        }
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(this.advancedSatelliteUUIDArray[x]);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    private IRouter getFluidSatelliteRouter(int x) {
        if (x == -1) {
            int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(this.liquidSatelliteUUID);
            return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
        }
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(this.liquidSatelliteUUIDArray[x]);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    public IRouter getSatelliteRouterByID(UUID id) {
        if (id == null) {
            return null;
        }
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(id);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    public IRouter getResultRouterByID(UUID id) {
        if (id == null) {
            return null;
        }
        int resultRouterId = SimpleServiceLocator.routerManager.getIDforUUID(id);
        return SimpleServiceLocator.routerManager.getRouter(resultRouterId);
    }

    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this._service.getItemOrderManager().hasExtras() || tree.hasBeenQueried((LogisticsOrderManager)this._service.getItemOrderManager())) {
            return;
        }
        if (!(this._service instanceof CraftingManager)) {
            return;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        IRouter resultR = this.getResultRouterByID(mngr.getResultUUID());
        if (resultR == null) {
            return;
        }
        CoreRoutedPipe coreRoutedPipe = resultR.getPipe();
        if (!(coreRoutedPipe instanceof ResultPipe)) {
            return;
        }
        ResultPipe res = (ResultPipe)coreRoutedPipe;
        IResource requestedItem = tree.getRequestType();
        if (!this.canCraft(requestedItem)) {
            return;
        }
        for (IFilter iFilter : filters) {
            if (iFilter.isBlocked() != iFilter.isFilteredItem(requestedItem) && !iFilter.blockProvider()) continue;
            return;
        }
        int remaining = 0;
        for (LogisticsItemOrder extra : this._service.getItemOrderManager()) {
            if (extra.getType() != IOrderInfoProvider.ResourceType.EXTRA || !extra.getResource().getItem().equals(requestedItem.getAsItem())) continue;
            remaining += extra.getResource().stack.getStackSize();
        }
        if ((remaining -= root.getAllPromissesFor((IProvide)res, this.getCraftedItem().getItem())) < 1) {
            return;
        }
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzyFlags.getBitSet().nextSetBit(0) != -1) {
            DictResource dictResource = new DictResource(this.getCraftedItem(), null).loadFromBitSet(this.outputFuzzyFlags.getBitSet());
            LogisticsExtraDictPromise promise = new LogisticsExtraDictPromise(dictResource, Math.min(remaining, tree.getMissingAmount()), (IProvideItems)res, true);
            tree.addPromise((IPromise)promise);
        } else {
            LogisticsExtraPromise logisticsExtraPromise = new LogisticsExtraPromise(this.getCraftedItem().getItem(), Math.min(remaining, tree.getMissingAmount()), (IProvideItems)res, true);
            tree.addPromise((IPromise)logisticsExtraPromise);
        }
        tree.setQueried((LogisticsOrderManager)this._service.getItemOrderManager());
    }

    public LogisticsItemOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        IRouter resultR;
        if (!(this._service instanceof CraftingManager)) {
            return null;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        ItemIdentifierStack result = this.getCraftedItem();
        if (result == null) {
            return null;
        }
        int multiply = (int)Math.ceil((float)promise.numberOfItems / (float)result.getStackSize());
        if (mngr.isBuffered()) {
            int i;
            ArrayList<Pair<IRequestItems, ItemIdentifierStack>> rec = new ArrayList<Pair<IRequestItems, ItemIdentifierStack>>();
            IRouter defSat = this.getSatelliteRouterByID(mngr.getSatelliteUUID());
            if (defSat == null) {
                return null;
            }
            IRequestItems[] target = new IRequestItems[9];
            for (int i2 = 0; i2 < 9; ++i2) {
                target[i2] = defSat.getPipe();
            }
            boolean hasSatellite = this.isSatelliteConnected();
            if (!hasSatellite) {
                return null;
            }
            if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
                IRouter r = this.getSatelliteRouter(-1);
                if (r != null) {
                    CoreRoutedPipe sat = r.getPipe();
                    for (int i3 = 6; i3 < 9; ++i3) {
                        target[i3] = sat;
                    }
                }
            } else {
                for (int i4 = 0; i4 < 9; ++i4) {
                    IRouter r = this.getSatelliteRouter(i4);
                    if (r == null) continue;
                    target[i4] = r.getPipe();
                }
            }
            for (i = 0; i < target.length; ++i) {
                ItemIdentifierStack mat = this.getMaterials(i);
                if (mat == null) continue;
                rec.add((Pair<IRequestItems, ItemIdentifierStack>)Pair.of((Object)target[i], (Object)mat));
            }
            for (i = 0; i < multiply; ++i) {
                mngr.addBuffered(rec);
            }
        }
        if ((resultR = this.getResultRouterByID(mngr.getResultUUID())) == null) {
            return null;
        }
        CoreRoutedPipe coreRoutedPipe = resultR.getPipe();
        if (!(coreRoutedPipe instanceof ResultPipe)) {
            return null;
        }
        ResultPipe res = (ResultPipe)coreRoutedPipe;
        return res.fullFill(promise, destination, info);
    }

    public void openAttachedGui(EntityPlayer player) {
    }

    public void registerExtras(IPromise promise) {
        if (!(this._service instanceof CraftingManager)) {
            return;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        IRouter resultR = this.getResultRouterByID(mngr.getResultUUID());
        if (resultR == null) {
            return;
        }
        CoreRoutedPipe coreRoutedPipe = resultR.getPipe();
        if (!(coreRoutedPipe instanceof ResultPipe)) {
            return;
        }
        ResultPipe res = (ResultPipe)coreRoutedPipe;
        res.registerExtras(promise);
    }

    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (!this._service.isNthTick(6)) {
            return;
        }
        if (!(this._service instanceof CraftingManager)) {
            return;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        if (!this._service.getItemOrderManager().hasOrders(new IOrderInfoProvider.ResourceType[]{IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA})) {
            if (this.getUpgradeManager().getCrafterCleanup() > 0) {
                IRouter resultR = this.getResultRouterByID(mngr.getResultUUID());
                if (resultR == null) {
                    return;
                }
                CoreRoutedPipe coreRoutedPipe = resultR.getPipe();
                if (!(coreRoutedPipe instanceof ResultPipe)) {
                    return;
                }
                ResultPipe res = (ResultPipe)coreRoutedPipe;
                res.extractCleanup(this._cleanupInventory, this.cleanupModeIsExclude, this.getUpgradeManager().getCrafterCleanup() * 3);
            }
            return;
        }
    }

    public void guiClosedByPlayer(EntityPlayer player) {
        super.guiClosedByPlayer(player);
        if (MainProxy.isClient((IBlockAccess)this._world.getWorld())) {
            return;
        }
        if (!(this._service instanceof CraftingManager)) {
            return;
        }
        CraftingManager mngr = (CraftingManager)this._service;
        ChassiModule m = mngr.getModules();
        for (int i = 0; i < 27; ++i) {
            if (m.getModule(i) != this) continue;
            mngr.save(i);
            break;
        }
    }

    public static class BufferInformation
    extends ModuleCrafter.CraftingChassieInformation {
        public BufferInformation(int craftingSlot, int moduleSlot) {
            super(craftingSlot, moduleSlot);
        }
    }
}

