/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.network;

import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.network.ProvideIDListPacket;
import com.tom.logisticsbridge.network.SetIDPacket;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class RequestIDListPacket
extends CoordinatesPacket {
    public int side;
    public int id;

    public RequestIDListPacket(int id) {
        super(id);
    }

    public void processPacket(EntityPlayer player) {
        SetIDPacket.IIdPipe rPipe;
        if (this.side != 0) {
            rPipe = LogisticsBridge.processReqIDList(player, this);
        } else {
            try {
                CoreUnroutedPipe cpipe = this.getPipe((World)player.func_130014_f_(), (CoordinatesPacket.LTGPCompletionCheck)CoordinatesPacket.LTGPCompletionCheck.PIPE).pipe;
                if (!(cpipe instanceof SetIDPacket.IIdPipe)) {
                    throw new TargetNotFoundException(null, (Object)this);
                }
                rPipe = (SetIDPacket.IIdPipe)cpipe;
            }
            catch (Exception e) {
                SetIDPacket.IIdPipe pp = (SetIDPacket.IIdPipe)this.getTileAs(player.field_70170_p, SetIDPacket.IIdPipe.class);
                if (pp == null) {
                    return;
                }
                rPipe = pp;
            }
        }
        if (rPipe == null) {
            return;
        }
        MainProxy.sendPacketToPlayer((ModernPacket)((ProvideIDListPacket)PacketHandler.getPacket(ProvideIDListPacket.class)).setList(rPipe.list(this.id)), (EntityPlayer)player);
    }

    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeByte(this.side);
        output.writeInt(this.id);
    }

    public void readData(LPDataInput input) {
        super.readData(input);
        this.side = input.readByte();
        this.id = input.readInt();
    }

    public ModernPacket template() {
        return new RequestIDListPacket(this.getId());
    }

    public RequestIDListPacket setSide(int side) {
        this.side = side;
        return this;
    }

    public RequestIDListPacket setId(int id) {
        this.id = id;
        return this;
    }
}

