/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.network;

import com.tom.logisticsbridge.LogisticsBridge;
import java.util.Collections;
import java.util.List;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SetIDPacket
extends CoordinatesPacket {
    public String pid;
    public int id;
    public int side;

    public SetIDPacket(int id) {
        super(id);
    }

    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeUTF(this.pid);
        output.writeInt(this.id);
        output.writeInt(this.side);
    }

    public void readData(LPDataInput input) {
        super.readData(input);
        this.pid = input.readUTF();
        this.id = input.readInt();
        this.side = input.readInt();
    }

    public ModernPacket template() {
        return new SetIDPacket(this.getId());
    }

    public SetIDPacket setName(String pid) {
        this.pid = pid;
        return this;
    }

    public SetIDPacket setId(int id) {
        this.id = id;
        return this;
    }

    public SetIDPacket setPos(CoreRoutedPipe pipe) {
        this.setBlockPos(pipe.getPos());
        return this;
    }

    public void processPacket(EntityPlayer player) {
        if (this.side != 0) {
            LogisticsBridge.processResIDMod(player, this);
        } else {
            try {
                LogisticsTileGenericPipe pipe = this.getPipe(player.field_70170_p, CoordinatesPacket.LTGPCompletionCheck.PIPE);
                if (pipe.pipe instanceof IIdPipe) {
                    ((IIdPipe)pipe.pipe).setPipeID(this.id, this.pid, player);
                }
            }
            catch (TargetNotFoundException e) {
                IIdPipe pp = (IIdPipe)this.getTileAs(player.field_70170_p, IIdPipe.class);
                if (pp == null) {
                    return;
                }
                pp.setPipeID(this.id, this.pid, player);
                return;
            }
        }
    }

    public SetIDPacket setSide(int side) {
        this.side = side + 1;
        return this;
    }

    public static interface IIdPipe {
        public String getPipeID(int var1);

        public void setPipeID(int var1, String var2, EntityPlayer var3);

        public String getName(int var1);

        default public List<String> list(int id) {
            return Collections.emptyList();
        }
    }
}

