/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.node;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.api.BridgeStack;
import com.tom.logisticsbridge.api.IDynamicPatternDetailsRS;
import com.tom.logisticsbridge.item.VirtualPatternRS;
import com.tom.logisticsbridge.pipe.BridgePipe;
import com.tom.logisticsbridge.tileentity.IBridge;
import com.tom.logisticsbridge.util.DynamicInventory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class NetworkNodeBridge
extends NetworkNode
implements IStorageProvider,
IStorage<ItemStack>,
IBridge,
IItemHandler,
IDynamicPatternDetailsRS,
ICraftingPatternContainer {
    public static final String ID = "lb.bridge";
    private static final String NBT_UUID = "BridgeUuid";
    private static final String NAME = "tile.lb.bridge.rs.name";
    private long lastInjectTime;
    private BridgePipe.Req reqapi;
    private IStackList<ItemStack> list = API.instance().createItemStackList();
    private boolean firstTick = true;
    private DynamicInventory patterns = new DynamicInventory();
    private DynamicInventory craftingItems = new DynamicInventory();
    private InvWrapper craftingItemsWrapper = new InvWrapper(this.craftingItems){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            NetworkNodeBridge.this.lastInjectTime = NetworkNodeBridge.this.world.func_82737_E();
            if (stack.func_77973_b() == LogisticsBridge.logisticsFakeItem) {
                if (NetworkNodeBridge.this.pushPattern(stack, simulate)) {
                    return ItemStack.field_190927_a;
                }
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlots() {
            return super.getSlots() + 16;
        }
    };
    private List<ICraftingPattern> craftingPatterns = new ArrayList<ICraftingPattern>();
    private Deque<ItemStack> requestList = new ArrayDeque<ItemStack>();
    @Nullable
    private UUID uuid = null;
    private boolean disableLP;
    private boolean bridgeMode;

    public NetworkNodeBridge(World world, BlockPos pos) {
        super(world, pos);
    }

    public int getEnergyUsage() {
        return 2;
    }

    @Override
    public String getId() {
        return ID;
    }

    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        storages.add(this);
    }

    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
    }

    public Collection<ItemStack> getStacks() {
        return this.list.getStacks();
    }

    public ItemStack insert(ItemStack stack, int size, Action action) {
        if (stack.func_77973_b() == LogisticsBridge.logisticsFakeItem) {
            return null;
        }
        ItemStack ret = stack.func_77946_l();
        ret.func_190920_e(size);
        return ret;
    }

    public ItemStack extract(ItemStack stack, int size, int flags, Action action) {
        if (stack.func_77973_b() == LogisticsBridge.logisticsFakeItem) {
            ItemStack st = (ItemStack)this.list.get((Object)stack, flags);
            int min = Math.min(size, st.func_190916_E());
            ItemStack ret = st.func_77946_l();
            st.func_190920_e(min);
            if (action == Action.PERFORM) {
                this.list.remove((Object)st, min);
            }
            return ret;
        }
        return null;
    }

    public int getStored() {
        return 0;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }

    public int getCacheDelta(int storedPreInsertion, int size, ItemStack remainder) {
        return 0;
    }

    @Override
    public long countItem(ItemStack stack, boolean requestable) {
        if (this.disableLP && !this.bridgeMode || this.network == null) {
            return 0L;
        }
        ItemStack is = (ItemStack)this.network.getItemStorageCache().getList().get((Object)stack);
        int inRS = is == null ? 0 : is.func_190916_E();
        int inBuf = this.craftingItems.stream().filter(s -> this.itemsEquals((ItemStack)s, stack)).mapToInt(ItemStack::func_190916_E).sum();
        return inRS + inBuf;
    }

    @Override
    public void craftStack(ItemStack stack, int count, boolean simulate) {
        ICraftingTask task = this.network.getCraftingManager().create(stack, count);
        if (task == null) {
            return;
        }
        ICraftingTaskError error = task.calculate();
        if (error == null && !task.hasMissing()) {
            this.network.getCraftingManager().add(task);
        }
    }

    @Override
    public List<BridgeStack<ItemStack>> getItems() {
        if (this.disableLP && !this.bridgeMode || this.network == null) {
            return Collections.emptyList();
        }
        return LogisticsBridge.concatStreams(this.network.getItemStorageCache().getList().getStacks().stream().filter(e -> e != null && e.func_77973_b() != LogisticsBridge.logisticsFakeItem).map(s -> new BridgeStack<ItemStack>((ItemStack)s, s.func_190916_E(), false, 0L)), this.network.getCraftingManager().getPatterns().stream().map(ICraftingPattern::getOutputs).flatMap(Collection::stream).filter(s -> s != null && !s.func_190926_b() && s.func_77973_b() != LogisticsBridge.logisticsFakeItem).map(s -> new BridgeStack<ItemStack>((ItemStack)s, 0L, true, 0L)), this.craftingItems.stream().map(s -> new BridgeStack<ItemStack>((ItemStack)s, s.func_190916_E(), false, 0L))).collect(Collectors.toList());
    }

    @Override
    public ItemStack extractStack(ItemStack stack, int count, boolean simulate) {
        if (this.network == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack ex = this.network.extractItem(stack, count, simulate ? Action.SIMULATE : Action.PERFORM);
        return ex;
    }

    @Override
    public void setReqAPI(BridgePipe.Req reqapi) {
        this.reqapi = reqapi;
    }

    public void update() {
        super.update();
        if (!this.world.field_72995_K) {
            long wt = this.world.func_82737_E();
            if (this.reqapi != null && wt % 20L == 0L && this.network != null) {
                ArrayList stack = new ArrayList(this.list.getStacks());
                List<ItemStack> pi = this.reqapi.getProvidedItems();
                this.list.clear();
                List crafts = this.patterns.stream().collect(Collectors.toList());
                this.patterns.func_174888_l();
                this.craftingPatterns.clear();
                List<ItemStack> ci = this.reqapi.getCraftedItems();
                IDynamicPatternDetailsRS.TileEntityWrapper wr = new IDynamicPatternDetailsRS.TileEntityWrapper(this.world, this.pos);
                pi.stream().forEach(i -> {
                    ItemStack r = i.func_77946_l();
                    r.func_190920_e(1);
                    this.list.add((Object)LogisticsBridge.fakeStack(r, i.func_190916_E()));
                    ICraftingPattern pattern = VirtualPatternRS.create(r, wr, (ICraftingPatternContainer)this);
                    this.patterns.addStack(pattern.getStack());
                    this.craftingPatterns.add(pattern);
                });
                this.list.add((Object)new ItemStack(LogisticsBridge.logisticsFakeItem, 65536));
                ci.stream().map(i -> VirtualPatternRS.create(i, wr, (ICraftingPatternContainer)this)).forEach(pattern -> {
                    this.patterns.addStack(pattern.getStack());
                    this.craftingPatterns.add((ICraftingPattern)pattern);
                    pattern = VirtualPatternRS.create(new ItemStack(LogisticsBridge.logisticsFakeItem), LogisticsBridge.fakeStack((ItemStack)pattern.getOutputs().get(0), 1), (ICraftingPatternContainer)this);
                    this.patterns.addStack(pattern.getStack());
                    this.craftingPatterns.add((ICraftingPattern)pattern);
                });
                if (this.firstTick || stack.size() != this.list.getStacks().size() || crafts.size() != this.patterns.func_70302_i_() || stack.stream().anyMatch(s -> {
                    ItemStack st = (ItemStack)this.list.get(s);
                    return st == null || st.func_190926_b() || st.func_190916_E() != s.func_190916_E();
                }) || this.patterns.stream().anyMatch(p -> !crafts.stream().anyMatch(i -> ItemStack.func_77970_a((ItemStack)i, (ItemStack)p)))) {
                    this.network.getItemStorageCache().invalidate();
                    this.network.getCraftingManager().rebuild();
                }
                this.firstTick = false;
            }
            if (this.lastInjectTime + 200L < wt && !this.craftingItems.func_191420_l()) {
                this.lastInjectTime = wt - 20L;
                for (int i2 = 0; i2 < this.craftingItems.func_70302_i_(); ++i2) {
                    this.craftingItems.func_70299_a(i2, this.insertItem(0, this.craftingItems.func_70301_a(i2), false));
                }
                this.craftingItems.removeEmpties();
            }
            if (wt % 5L == 0L && !this.requestList.isEmpty() && this.reqapi != null) {
                ItemStack toReq = this.requestList.pop();
                BridgePipe.OpResult opres = this.reqapi.performRequest(toReq, true);
                boolean pushed = opres.missing.isEmpty();
                if (!pushed) {
                    this.requestList.add(toReq);
                }
            }
        }
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.network == null) {
            return stack;
        }
        ItemStack is = simulate ? this.network.insertItem(stack, stack.func_190916_E(), Action.SIMULATE) : this.network.insertItemTracked(stack, stack.func_190916_E());
        return is == null ? ItemStack.field_190927_a : is;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public IItemHandler getConnectedInventory() {
        return this.craftingItemsWrapper;
    }

    public IFluidHandler getConnectedFluidInventory() {
        return null;
    }

    public TileEntity getConnectedTile() {
        return null;
    }

    public IItemHandlerModifiable getPatternInventory() {
        return null;
    }

    public List<ICraftingPattern> getPatterns() {
        return this.craftingPatterns;
    }

    public String getName() {
        return NAME;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public ICraftingPatternContainer getRootContainer() {
        return this;
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_186855_b(NBT_UUID)) {
            this.uuid = tag.func_186857_a(NBT_UUID);
        }
        NBTTagList list = tag.func_150295_c("reqList", 10);
        this.requestList.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.requestList.add(new ItemStack(list.func_150305_b(i)));
        }
        this.bridgeMode = tag.func_74767_n("bridgeMode");
        LogisticsBridge.loadAllItems(tag.func_150295_c("intInventory", 10), this.craftingItems);
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        if (this.uuid != null) {
            tag.func_186854_a(NBT_UUID, this.uuid);
        }
        NBTTagList list = new NBTTagList();
        this.requestList.stream().map(s -> s.func_77955_b(new NBTTagCompound())).forEach(arg_0 -> ((NBTTagList)list).func_74742_a(arg_0));
        tag.func_74782_a("reqList", (NBTBase)list);
        this.craftingItems.removeEmpties();
        tag.func_74782_a("intInventory", (NBTBase)LogisticsBridge.saveAllItems(this.craftingItems));
        tag.func_74757_a("bridgeMode", this.bridgeMode);
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NonNullList<ItemStack> getInputs(ItemStack res, NonNullList<ItemStack> def) {
        if (this.reqapi == null) {
            return def;
        }
        try {
            this.disableLP = true;
            BridgePipe.OpResult r = this.reqapi.simulateRequest(res, 1, true);
            NonNullList ret = NonNullList.func_191196_a();
            ret.addAll(r.missing);
            ret.add((Object)LogisticsBridge.fakeStack(res, 1));
            NonNullList nonNullList = ret;
            return nonNullList;
        }
        finally {
            this.disableLP = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NonNullList<ItemStack> getOutputs(ItemStack res, NonNullList<ItemStack> def) {
        if (this.reqapi == null) {
            return def;
        }
        try {
            this.disableLP = true;
            BridgePipe.OpResult r = this.reqapi.simulateRequest(res, 6, true);
            NonNullList ret = NonNullList.func_191196_a();
            if (def != null || this.bridgeMode) {
                ret.add((Object)res.func_77946_l());
            }
            if (!this.bridgeMode) {
                r.extra.forEach(i -> {
                    boolean added = false;
                    for (ItemStack e : ret) {
                        if (!this.itemsEquals(e, (ItemStack)i)) continue;
                        e.func_190917_f(i.func_190916_E());
                        added = true;
                        break;
                    }
                    if (!added) {
                        ret.add(i);
                    }
                });
            }
            if (def == null && !this.bridgeMode) {
                for (ItemStack e : ret) {
                    if (!this.itemsEquals(e, res)) continue;
                    res.func_190917_f(e.func_190916_E());
                }
                Iterator iterator = null;
                return iterator;
            }
            NonNullList nonNullList = ret;
            return nonNullList;
        }
        finally {
            this.disableLP = false;
        }
    }

    private boolean itemsEquals(ItemStack e, ItemStack i) {
        return ItemStack.func_179545_c((ItemStack)e, (ItemStack)i) && ItemStack.func_77970_a((ItemStack)e, (ItemStack)i);
    }

    public void blockClicked(EntityPlayer playerIn) {
        this.firstTick = true;
        if (playerIn.func_70093_af()) {
            this.bridgeMode = !this.bridgeMode;
            TextComponentTranslation text = new TextComponentTranslation("chat.logisticsbridge.bridgeMode", new Object[]{"RS", this.bridgeMode ? new TextComponentTranslation("chat.logisticsbridge.bridgeMode.simple", new Object[0]) : new TextComponentTranslation("chat.logisticsbridge.bridgeMode.smart", new Object[0])});
            playerIn.func_145747_a((ITextComponent)text);
        }
    }

    public boolean pushPattern(ItemStack stack, boolean simulate) {
        if (this.reqapi == null || !stack.func_77942_o()) {
            return false;
        }
        ItemStack res = new ItemStack(stack.func_77978_p());
        if (res.func_190926_b()) {
            return false;
        }
        if (!simulate) {
            this.requestList.add(res);
        }
        return true;
    }

    protected void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getCraftingManager().rebuild();
    }

    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel(task.getId()));
    }
}

