/*
 * Decompiled with CFR 0.152.
 */
package com.tom.logisticsbridge.pipe;

import com.tom.logisticsbridge.GuiHandler;
import com.tom.logisticsbridge.LogisticsBridge;
import com.tom.logisticsbridge.module.BufferUpgrade;
import com.tom.logisticsbridge.module.ModuleCrafterExt;
import com.tom.logisticsbridge.network.SetIDPacket;
import com.tom.logisticsbridge.pipe.ResultPipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import logisticspipes.LPItems;
import logisticspipes.api.ILPPipeTile;
import logisticspipes.gui.GuiChassiPipe;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IQueueCCEvent;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.items.ItemModule;
import logisticspipes.logisticspipes.ItemModuleInformationManager;
import logisticspipes.modules.ChassiModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.pipe.ChassiGuiProvider;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeItemsSatelliteLogistics;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingManager
extends PipeLogisticsChassi
implements SetIDPacket.IIdPipe {
    private List<List<Pair<IRequestItems, ItemIdentifierStack>>> buffered = new ArrayList<List<Pair<IRequestItems, ItemIdentifierStack>>>();
    public static Textures.TextureType TEXTURE = Textures.empty;
    public String satelliteId;
    public String resultId;
    private UUID satelliteUUID;
    private UUID resultUUID;
    private BlockingMode blockingMode = BlockingMode.OFF;
    private int sendCooldown = 0;
    @SideOnly(value=Side.CLIENT)
    private IInventory clientInv;
    private boolean readingNBT;

    public CraftingManager(Item item) {
        super(item);
        this.upgradeManager = new UpgradeManager((CoreRoutedPipe)this){

            public boolean hasUpgradeModuleUpgrade() {
                return false;
            }
        };
    }

    public Textures.TextureType getCenterTexture() {
        return TEXTURE;
    }

    public int getChassiSize() {
        return 27;
    }

    public void InventoryChanged(IInventory inventory) {
        ChassiModule _module = (ChassiModule)this.getLogisticsModule();
        boolean reInitGui = false;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) {
                if (!_module.hasModule(i)) continue;
                _module.removeModule(i);
                reInitGui = true;
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemModule)) continue;
            LogisticsModule current = _module.getModule(i);
            LogisticsModule next = this.getModuleForItem(stack, _module.getModule(i), (IWorldProvider)this, (IPipeServiceProvider)this);
            next.registerPosition(LogisticsModule.ModulePositionType.SLOT, i);
            next.registerCCEventQueuer((IQueueCCEvent)this);
            if (current != next) {
                _module.installModule(i, next);
                if (!MainProxy.isClient()) {
                    ItemModuleInformationManager.readInformation((ItemStack)stack, (LogisticsModule)next);
                }
            }
            inventory.func_70299_a(i, stack);
        }
        if (reInitGui && MainProxy.isClient((IBlockAccess)this.getWorld()) && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiChassiPipe) {
            FMLClientHandler.instance().getClient().field_71462_r.func_73866_w_();
        }
        if (!MainProxy.isClient((IBlockAccess)this.getWorld())) {
            this.sendSignData();
        }
    }

    private void sendSignData() {
        if (this.readingNBT) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            ModernPacket packet;
            if (this.signItem[i] == null || (packet = this.signItem[i].getPacket()) == null) continue;
            MainProxy.sendPacketToAllWatchingChunk((TileEntity)this.container, (ModernPacket)packet);
        }
    }

    public LogisticsModule getModuleForItem(ItemStack itemStack, LogisticsModule currentModule, IWorldProvider world, IPipeServiceProvider service) {
        if (itemStack == null) {
            return null;
        }
        if (!CraftingManager.isCraftingModule(itemStack)) {
            return null;
        }
        if (currentModule != null && ModuleCrafterExt.class.equals(currentModule.getClass())) {
            return currentModule;
        }
        ModuleCrafterExt newmodule = new ModuleCrafterExt();
        newmodule.registerHandler(world, service);
        return newmodule;
    }

    public IHeadUpDisplayRenderer getRenderer() {
        return null;
    }

    public void startWatching() {
    }

    public void stopWatching() {
    }

    public void playerStartWatching(EntityPlayer player, int mode) {
    }

    public void playerStopWatching(EntityPlayer player, int mode) {
    }

    public boolean handleClick(EntityPlayer entityplayer, SecuritySettings settings) {
        return this.handleClick0(entityplayer, settings);
    }

    private boolean handleClick0(EntityPlayer entityplayer, SecuritySettings settings) {
        if (entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
            return false;
        }
        if (!entityplayer.func_70093_af() && SimpleServiceLocator.configToolHandler.canWrench(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), (ILPPipeTile)this.container)) {
            if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
                if (settings == null || settings.openGui) {
                    this.openGui(entityplayer);
                } else {
                    entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            SimpleServiceLocator.configToolHandler.wrenchUsed(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), (ILPPipeTile)this.container);
            return true;
        }
        if (entityplayer.func_70093_af() && SimpleServiceLocator.configToolHandler.canWrench(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), (ILPPipeTile)this.container)) {
            if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
                if (settings == null || settings.openGui) {
                    ((PipeLogisticsChassi)this.container.pipe).nextOrientation();
                } else {
                    entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            SimpleServiceLocator.configToolHandler.wrenchUsed(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), (ILPPipeTile)this.container);
            return true;
        }
        if (!entityplayer.func_70093_af() && entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemModule) {
            if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
                if (settings == null || settings.openGui) {
                    return this.tryInsertingModule(entityplayer);
                }
                entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
            }
            return true;
        }
        return false;
    }

    private boolean tryInsertingModule(EntityPlayer entityplayer) {
        if (!CraftingManager.isCraftingModule(entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND))) {
            return false;
        }
        IInventory _moduleInventory = this.getModuleInventory();
        for (int i = 0; i < _moduleInventory.func_70302_i_(); ++i) {
            ItemStack item = _moduleInventory.func_70301_a(i);
            if (!item.func_190926_b()) continue;
            _moduleInventory.func_70299_a(i, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77979_a(1));
            this.InventoryChanged(_moduleInventory);
            return true;
        }
        return false;
    }

    public static boolean isCraftingModule(ItemStack itemStack) {
        return itemStack.func_77973_b() == Item.field_150901_e.func_82594_a(LPItems.modules.get((Object)ModuleCrafter.getName()));
    }

    public boolean isUpgradeModule(ItemStack itemStack, int slot) {
        return ChassiGuiProvider.checkStack((ItemStack)itemStack, (PipeLogisticsChassi)this, (int)slot);
    }

    public void openGui(EntityPlayer entityPlayer) {
        CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(this.isBuffered() ? Integer.toString(this.blockingMode.ordinal()) : "0").setId(2).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)entityPlayer);
        entityPlayer.openGui((Object)LogisticsBridge.modInstance, GuiHandler.GuiIDs.CraftingManager.ordinal(), this.getWorld(), this.getX(), this.getY(), this.getZ());
        packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(this.satelliteId).setId(0).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)entityPlayer);
        packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(this.resultId).setId(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)entityPlayer);
    }

    @Override
    public String getPipeID(int id) {
        return id == 0 ? this.satelliteId : (id == 1 ? this.resultId : Integer.toString(this.blockingMode.ordinal()));
    }

    @Override
    public void setPipeID(int id, String pipeID, EntityPlayer player) {
        if (player == null) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToServer((ModernPacket)packet);
        } else if (MainProxy.isServer((IBlockAccess)player.field_70170_p)) {
            CoordinatesPacket packet = ((SetIDPacket)PacketHandler.getPacket(SetIDPacket.class)).setName(pipeID).setId(id).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer((ModernPacket)packet, (EntityPlayer)player);
            this.satelliteUUID = null;
            this.resultUUID = null;
        }
        if (id == 0) {
            this.satelliteId = pipeID;
        } else if (id == 1) {
            this.resultId = pipeID;
        } else if (id == 2) {
            this.blockingMode = BlockingMode.VALUES[Math.abs(pipeID.charAt(0) - 48) % BlockingMode.VALUES.length];
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.resultId != null) {
            nbttagcompound.func_74778_a("resultname", this.resultId);
        }
        if (this.satelliteId != null) {
            nbttagcompound.func_74778_a("satellitename", this.satelliteId);
        }
        nbttagcompound.func_74774_a("blockingMode", (byte)this.blockingMode.ordinal());
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        try {
            this.readingNBT = true;
            super.readFromNBT(nbttagcompound);
            this.resultId = nbttagcompound.func_74779_i("resultname");
            this.satelliteId = nbttagcompound.func_74779_i("satellitename");
            if (nbttagcompound.func_74764_b("resultid")) {
                this.resultId = Integer.toString(nbttagcompound.func_74762_e("resultid"));
                this.satelliteId = Integer.toString(nbttagcompound.func_74762_e("satelliteid"));
            }
            this.blockingMode = BlockingMode.VALUES[Math.abs(nbttagcompound.func_74771_c("blockingMode")) % BlockingMode.VALUES.length];
        }
        finally {
            this.readingNBT = false;
        }
    }

    public void collectSpecificInterests(Collection<ItemIdentifier> itemidCollection) {
        for (int i = 0; i < this.getChassiSize(); ++i) {
            LogisticsModule module = this.getSubModule(i);
            if (module == null) continue;
            module.collectSpecificInterests(itemidCollection);
        }
    }

    public boolean hasGenericInterests() {
        for (int i = 0; i < this.getChassiSize(); ++i) {
            LogisticsModule x = this.getSubModule(i);
            if (x == null || !x.hasGenericInterests()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName(int id) {
        return null;
    }

    private UUID getUUIDForSatelliteName(String name) {
        for (PipeItemsSatelliteLogistics pipe : PipeItemsSatelliteLogistics.AllSatellites) {
            if (!pipe.getSatellitePipeName().equals(name)) continue;
            return pipe.getRouter().getId();
        }
        return null;
    }

    private UUID getUUIDForResultName(String name) {
        for (ResultPipe pipe : ResultPipe.AllResults) {
            if (!pipe.getResultPipeName().equals(name)) continue;
            return pipe.getRouter().getId();
        }
        return null;
    }

    public UUID getSatelliteUUID() {
        if (this.satelliteUUID == null) {
            this.satelliteUUID = this.getUUIDForSatelliteName(this.satelliteId);
        }
        return this.satelliteUUID;
    }

    public UUID getResultUUID() {
        if (this.resultUUID == null) {
            this.resultUUID = this.getUUIDForResultName(this.resultId);
        }
        return this.resultUUID;
    }

    @Override
    public List<String> list(int id) {
        if (id == 0) {
            return PipeItemsSatelliteLogistics.AllSatellites.stream().filter(Objects::nonNull).filter(it -> it.getRouter() != null).filter(it -> this.getRouter().getRouteTable().size() > it.getRouterId()).filter(it -> this.getRouter().getRouteTable().get(it.getRouterId()) != null).filter(it -> !((List)this.getRouter().getRouteTable().get(it.getRouterId())).isEmpty()).sorted(Comparator.comparingDouble(it -> ((List)this.getRouter().getRouteTable().get(it.getRouterId())).stream().map(it1 -> it1.distanceToDestination).min(Double::compare).get())).map(PipeItemsSatelliteLogistics::getSatellitePipeName).collect(Collectors.toList());
        }
        if (id == 1) {
            return ResultPipe.AllResults.stream().filter(Objects::nonNull).filter(it -> it.getRouter() != null).filter(it -> this.getRouter().getRouteTable().size() > it.getRouterId()).filter(it -> this.getRouter().getRouteTable().get(it.getRouterId()) != null).filter(it -> !((List)this.getRouter().getRouteTable().get(it.getRouterId())).isEmpty()).sorted(Comparator.comparingDouble(it -> ((List)this.getRouter().getRouteTable().get(it.getRouterId())).stream().map(it1 -> it1.distanceToDestination).min(Double::compare).get())).map(ResultPipe::getResultPipeName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean isBuffered() {
        for (int i = 0; i < 9; ++i) {
            if (!(this.upgradeManager.getUpgrade(i) instanceof BufferUpgrade)) continue;
            return true;
        }
        return false;
    }

    public void addBuffered(List<Pair<IRequestItems, ItemIdentifierStack>> rec) {
        this.buffered.add(rec);
    }

    public IRouter getSatelliteRouterByID(UUID id) {
        if (id == null) {
            return null;
        }
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(id);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    public IRouter getResultRouterByID(UUID id) {
        if (id == null) {
            return null;
        }
        int resultRouterId = SimpleServiceLocator.routerManager.getIDforUUID(id);
        return SimpleServiceLocator.routerManager.getRouter(resultRouterId);
    }

    private boolean checkBlocking() {
        switch (this.blockingMode) {
            case EMPTY_MAIN_SATELLITE: {
                IRouter defSat = this.getSatelliteRouterByID(this.getSatelliteUUID());
                if (defSat == null) {
                    return false;
                }
                if (!(defSat.getPipe() instanceof PipeItemsSatelliteLogistics)) {
                    return false;
                }
                IInventoryUtil inv = ((PipeItemsSatelliteLogistics)defSat.getPipe()).getPointedInventory();
                if (inv != null) {
                    for (int i = 0; i < inv.getSizeInventory(); ++i) {
                        ItemStack stackInSlot = inv.getStackInSlot(i);
                        if (stackInSlot.func_190926_b()) continue;
                        return false;
                    }
                }
                return true;
            }
            case REDSTONE_HIGH: {
                return this.getWorld().func_175640_z(this.getPos());
            }
            case REDSTONE_LOW: {
                return !this.getWorld().func_175640_z(this.getPos());
            }
        }
        return true;
    }

    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (!this.isNthTick(5)) {
            return;
        }
        if (this.isBuffered()) {
            if (this.sendCooldown > 0) {
                this.spawnParticle(Particles.RedParticle, 1);
                --this.sendCooldown;
                return;
            }
            if (this.blockingMode == BlockingMode.NULL) {
                this.blockingMode = BlockingMode.OFF;
            }
            if (!this.buffered.isEmpty()) {
                boolean allow = this.checkBlocking();
                if (!allow) {
                    this.spawnParticle(Particles.RedParticle, 1);
                    return;
                }
                NeighborTileEntity pointedItemHandler = this.getPointedItemHandler();
                if (this.canUseEnergy(this.neededEnergy()) && pointedItemHandler != null && pointedItemHandler.isItemHandler()) {
                    IInventoryUtil util = pointedItemHandler.getInventoryUtil();
                    for (List<Pair<IRequestItems, ItemIdentifierStack>> map : this.buffered) {
                        if (!map.stream().map(Pair::getValue).allMatch(i -> util.itemCount(i.getItem()) >= i.getStackSize())) continue;
                        int maxDist = 0;
                        for (Pair<IRequestItems, ItemIdentifierStack> en : map) {
                            ItemIdentifierStack toSend = (ItemIdentifierStack)en.getValue();
                            ItemStack removed = util.getMultipleItems(toSend.getItem(), toSend.getStackSize());
                            if (removed == null || removed.func_190926_b()) continue;
                            this.sendStack(removed, ((IRequestItems)en.getKey()).getID(), CoreRoutedPipe.ItemSendMode.Fast, null);
                            maxDist = Math.max(maxDist, (int)((IRequestItems)en.getKey()).getRouter().getPipe().getPos().func_177951_i((Vec3i)this.getPos()));
                        }
                        this.useEnergy(this.neededEnergy(), true);
                        this.buffered.remove(map);
                        if (this.blockingMode != BlockingMode.EMPTY_MAIN_SATELLITE) break;
                        this.sendCooldown = Math.min(maxDist, 16);
                        break;
                    }
                }
            }
        }
    }

    private int neededEnergy() {
        return 20;
    }

    public void save(int i) {
        ItemStack st = this.getModuleInventory().func_70301_a(i);
        if (!st.func_190926_b()) {
            ItemModuleInformationManager.saveInformation((ItemStack)st, (LogisticsModule)this.getModules().getModule(i));
            this.getModuleInventory().func_70299_a(i, st);
        }
        this.sendSignData();
    }

    public BlockingMode getBlockingMode() {
        return this.blockingMode;
    }

    @SideOnly(value=Side.CLIENT)
    public IInventory getClientModuleInventory() {
        if (this.clientInv == null) {
            this.clientInv = new InventoryBasic(null, false, 27);
        }
        return this.clientInv;
    }

    public static enum BlockingMode {
        NULL,
        OFF,
        EMPTY_MAIN_SATELLITE,
        REDSTONE_LOW,
        REDSTONE_HIGH;

        public static final BlockingMode[] VALUES;

        static {
            VALUES = BlockingMode.values();
        }
    }
}

